import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Search operator used when joining mulitple search clauses
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/user#compound_search_operator DataOktaUser#compound_search_operator}
    */
    readonly compoundSearchOperator?: string;
    /**
    * Force delay of the user read by N seconds. Useful when eventual consistency of user information needs to be allowed for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/user#delay_read_seconds DataOktaUser#delay_read_seconds}
    */
    readonly delayReadSeconds?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/user#id DataOktaUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Do not populate user groups information (prevents additional API call)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/user#skip_groups DataOktaUser#skip_groups}
    */
    readonly skipGroups?: boolean | cdktf.IResolvable;
    /**
    * Do not populate user roles information (prevents additional API call)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/user#skip_roles DataOktaUser#skip_roles}
    */
    readonly skipRoles?: boolean | cdktf.IResolvable;
    /**
    * Retrieve a single user based on their id
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/user#user_id DataOktaUser#user_id}
    */
    readonly userId?: string;
    /**
    * search block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/user#search DataOktaUser#search}
    */
    readonly search?: DataOktaUserSearch[] | cdktf.IResolvable;
}
export interface DataOktaUserSearch {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/user#comparison DataOktaUser#comparison}
    */
    readonly comparison?: string;
    /**
    * A raw search expression string. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/user#expression DataOktaUser#expression}
    */
    readonly expression?: string;
    /**
    * Property name to search for. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/user#name DataOktaUser#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/user#value DataOktaUser#value}
    */
    readonly value?: string;
}
export declare function dataOktaUserSearchToTerraform(struct?: DataOktaUserSearch | cdktf.IResolvable): any;
export declare class DataOktaUserSearchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOktaUserSearch | cdktf.IResolvable | undefined;
    set internalValue(value: DataOktaUserSearch | cdktf.IResolvable | undefined);
    private _comparison?;
    get comparison(): string;
    set comparison(value: string);
    resetComparison(): void;
    get comparisonInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    resetExpression(): void;
    get expressionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class DataOktaUserSearchList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataOktaUserSearch[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOktaUserSearchOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/user okta_user}
*/
export declare class DataOktaUser extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/user okta_user} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaUserConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataOktaUserConfig);
    get adminRoles(): string[];
    get city(): string;
    private _compoundSearchOperator?;
    get compoundSearchOperator(): string;
    set compoundSearchOperator(value: string);
    resetCompoundSearchOperator(): void;
    get compoundSearchOperatorInput(): string | undefined;
    get costCenter(): string;
    get countryCode(): string;
    get customProfileAttributes(): string;
    private _delayReadSeconds?;
    get delayReadSeconds(): string;
    set delayReadSeconds(value: string);
    resetDelayReadSeconds(): void;
    get delayReadSecondsInput(): string | undefined;
    get department(): string;
    get displayName(): string;
    get division(): string;
    get email(): string;
    get employeeNumber(): string;
    get firstName(): string;
    get groupMemberships(): string[];
    get honorificPrefix(): string;
    get honorificSuffix(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastName(): string;
    get locale(): string;
    get login(): string;
    get manager(): string;
    get managerId(): string;
    get middleName(): string;
    get mobilePhone(): string;
    get nickName(): string;
    get organization(): string;
    get postalAddress(): string;
    get preferredLanguage(): string;
    get primaryPhone(): string;
    get profileUrl(): string;
    get secondEmail(): string;
    private _skipGroups?;
    get skipGroups(): boolean | cdktf.IResolvable;
    set skipGroups(value: boolean | cdktf.IResolvable);
    resetSkipGroups(): void;
    get skipGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _skipRoles?;
    get skipRoles(): boolean | cdktf.IResolvable;
    set skipRoles(value: boolean | cdktf.IResolvable);
    resetSkipRoles(): void;
    get skipRolesInput(): boolean | cdktf.IResolvable | undefined;
    get state(): string;
    get status(): string;
    get streetAddress(): string;
    get timezone(): string;
    get title(): string;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    resetUserId(): void;
    get userIdInput(): string | undefined;
    get userType(): string;
    get zipCode(): string;
    private _search;
    get search(): DataOktaUserSearchList;
    putSearch(value: DataOktaUserSearch[] | cdktf.IResolvable): void;
    resetSearch(): void;
    get searchInput(): cdktf.IResolvable | DataOktaUserSearch[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
