import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaUsersConfig extends cdktf.TerraformMetaArguments {
    /**
    * Search operator used when joining mulitple search clauses
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/users#compound_search_operator DataOktaUsers#compound_search_operator}
    */
    readonly compoundSearchOperator?: string;
    /**
    * Force delay of the users read by N seconds. Useful when eventual consistency of users information needs to be allowed for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/users#delay_read_seconds DataOktaUsers#delay_read_seconds}
    */
    readonly delayReadSeconds?: string;
    /**
    * Find users based on group membership using the id of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/users#group_id DataOktaUsers#group_id}
    */
    readonly groupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/users#id DataOktaUsers#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Fetch group memberships for each user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/users#include_groups DataOktaUsers#include_groups}
    */
    readonly includeGroups?: boolean | cdktf.IResolvable;
    /**
    * Fetch user roles for each user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/users#include_roles DataOktaUsers#include_roles}
    */
    readonly includeRoles?: boolean | cdktf.IResolvable;
    /**
    * search block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/users#search DataOktaUsers#search}
    */
    readonly search?: DataOktaUsersSearch[] | cdktf.IResolvable;
}
export interface DataOktaUsersUsers {
}
export declare function dataOktaUsersUsersToTerraform(struct?: DataOktaUsersUsers): any;
export declare class DataOktaUsersUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOktaUsersUsers | undefined;
    set internalValue(value: DataOktaUsersUsers | undefined);
    get adminRoles(): string[];
    get city(): string;
    get costCenter(): string;
    get countryCode(): string;
    get customProfileAttributes(): string;
    get department(): string;
    get displayName(): string;
    get division(): string;
    get email(): string;
    get employeeNumber(): string;
    get firstName(): string;
    get groupMemberships(): string[];
    get honorificPrefix(): string;
    get honorificSuffix(): string;
    get id(): string;
    get lastName(): string;
    get locale(): string;
    get login(): string;
    get manager(): string;
    get managerId(): string;
    get middleName(): string;
    get mobilePhone(): string;
    get nickName(): string;
    get organization(): string;
    get postalAddress(): string;
    get preferredLanguage(): string;
    get primaryPhone(): string;
    get profileUrl(): string;
    get secondEmail(): string;
    get state(): string;
    get status(): string;
    get streetAddress(): string;
    get timezone(): string;
    get title(): string;
    get userType(): string;
    get zipCode(): string;
}
export declare class DataOktaUsersUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOktaUsersUsersOutputReference;
}
export interface DataOktaUsersSearch {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/users#comparison DataOktaUsers#comparison}
    */
    readonly comparison?: string;
    /**
    * A raw search expression string. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/users#expression DataOktaUsers#expression}
    */
    readonly expression?: string;
    /**
    * Property name to search for. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/users#name DataOktaUsers#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/users#value DataOktaUsers#value}
    */
    readonly value?: string;
}
export declare function dataOktaUsersSearchToTerraform(struct?: DataOktaUsersSearch | cdktf.IResolvable): any;
export declare class DataOktaUsersSearchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOktaUsersSearch | cdktf.IResolvable | undefined;
    set internalValue(value: DataOktaUsersSearch | cdktf.IResolvable | undefined);
    private _comparison?;
    get comparison(): string;
    set comparison(value: string);
    resetComparison(): void;
    get comparisonInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    resetExpression(): void;
    get expressionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class DataOktaUsersSearchList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataOktaUsersSearch[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOktaUsersSearchOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/users okta_users}
*/
export declare class DataOktaUsers extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_users";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/users okta_users} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaUsersConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataOktaUsersConfig);
    private _compoundSearchOperator?;
    get compoundSearchOperator(): string;
    set compoundSearchOperator(value: string);
    resetCompoundSearchOperator(): void;
    get compoundSearchOperatorInput(): string | undefined;
    private _delayReadSeconds?;
    get delayReadSeconds(): string;
    set delayReadSeconds(value: string);
    resetDelayReadSeconds(): void;
    get delayReadSecondsInput(): string | undefined;
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    resetGroupId(): void;
    get groupIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _includeGroups?;
    get includeGroups(): boolean | cdktf.IResolvable;
    set includeGroups(value: boolean | cdktf.IResolvable);
    resetIncludeGroups(): void;
    get includeGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _includeRoles?;
    get includeRoles(): boolean | cdktf.IResolvable;
    set includeRoles(value: boolean | cdktf.IResolvable);
    resetIncludeRoles(): void;
    get includeRolesInput(): boolean | cdktf.IResolvable | undefined;
    private _users;
    get users(): DataOktaUsersUsersList;
    private _search;
    get search(): DataOktaUsersSearchList;
    putSearch(value: DataOktaUsersSearch[] | cdktf.IResolvable): void;
    resetSearch(): void;
    get searchInput(): cdktf.IResolvable | DataOktaUsersSearch[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
