import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DomainVerificationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Domain's ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/domain_verification#domain_id DomainVerification#domain_id}
    */
    readonly domainId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/domain_verification#id DomainVerification#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/domain_verification okta_domain_verification}
*/
export declare class DomainVerification extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_domain_verification";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/domain_verification okta_domain_verification} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DomainVerificationConfig
    */
    constructor(scope: Construct, id: string, config: DomainVerificationConfig);
    private _domainId?;
    get domainId(): string;
    set domainId(value: string);
    get domainIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
