import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Certificate source type that indicates whether the certificate is provided by the user or Okta. Accepted values: MANUAL, OKTA_MANAGED. Warning: Use of OKTA_MANAGED requires a feature flag to be enabled. Default value = MANUAL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/domain#certificate_source_type Domain#certificate_source_type}
    */
    readonly certificateSourceType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/domain#id Domain#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Custom Domain name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/domain#name Domain#name}
    */
    readonly name: string;
    /**
    * Indicates whether the domain should be verified during creation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/domain#verify Domain#verify}
    */
    readonly verify?: boolean | cdktf.IResolvable;
}
export interface DomainDnsRecords {
}
export declare function domainDnsRecordsToTerraform(struct?: DomainDnsRecords): any;
export declare class DomainDnsRecordsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DomainDnsRecords | undefined;
    set internalValue(value: DomainDnsRecords | undefined);
    get expiration(): string;
    get fqdn(): string;
    get recordType(): string;
    get values(): string[];
}
export declare class DomainDnsRecordsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DomainDnsRecordsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/domain okta_domain}
*/
export declare class Domain extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_domain";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/domain okta_domain} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DomainConfig
    */
    constructor(scope: Construct, id: string, config: DomainConfig);
    private _certificateSourceType?;
    get certificateSourceType(): string;
    set certificateSourceType(value: string);
    resetCertificateSourceType(): void;
    get certificateSourceTypeInput(): string | undefined;
    private _dnsRecords;
    get dnsRecords(): DomainDnsRecordsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get validationStatus(): string;
    private _verify?;
    get verify(): boolean | cdktf.IResolvable;
    set verify(value: boolean | cdktf.IResolvable);
    resetVerify(): void;
    get verifyInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
