import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EmailCustomizationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The body of the customization
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/email_customization#body EmailCustomization#body}
    */
    readonly body?: string;
    /**
    * Brand ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/email_customization#brand_id EmailCustomization#brand_id}
    */
    readonly brandId: string;
    /**
    * Whether the customization is the default
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/email_customization#is_default EmailCustomization#is_default}
    */
    readonly isDefault?: boolean | cdktf.IResolvable;
    /**
    * The language supported by the customization
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/email_customization#language EmailCustomization#language}
    */
    readonly language?: string;
    /**
    * The subject of the customization
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/email_customization#subject EmailCustomization#subject}
    */
    readonly subject?: string;
    /**
    * Template Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/email_customization#template_name EmailCustomization#template_name}
    */
    readonly templateName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/email_customization okta_email_customization}
*/
export declare class EmailCustomization extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_email_customization";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/email_customization okta_email_customization} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EmailCustomizationConfig
    */
    constructor(scope: Construct, id: string, config: EmailCustomizationConfig);
    private _body?;
    get body(): string;
    set body(value: string);
    resetBody(): void;
    get bodyInput(): string | undefined;
    private _brandId?;
    get brandId(): string;
    set brandId(value: string);
    get brandIdInput(): string | undefined;
    get id(): string;
    private _isDefault?;
    get isDefault(): boolean | cdktf.IResolvable;
    set isDefault(value: boolean | cdktf.IResolvable);
    resetIsDefault(): void;
    get isDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _language?;
    get language(): string;
    set language(value: string);
    resetLanguage(): void;
    get languageInput(): string | undefined;
    get links(): string;
    private _subject?;
    get subject(): string;
    set subject(value: string);
    resetSubject(): void;
    get subjectInput(): string | undefined;
    private _templateName?;
    get templateName(): string;
    set templateName(value: string);
    get templateNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
