import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EmailSenderVerificationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/email_sender_verification#id EmailSenderVerification#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Email sender ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/email_sender_verification#sender_id EmailSenderVerification#sender_id}
    */
    readonly senderId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/email_sender_verification okta_email_sender_verification}
*/
export declare class EmailSenderVerification extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_email_sender_verification";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/email_sender_verification okta_email_sender_verification} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EmailSenderVerificationConfig
    */
    constructor(scope: Construct, id: string, config: EmailSenderVerificationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _senderId?;
    get senderId(): string;
    set senderId(value: string);
    get senderIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
