import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EmailSenderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Email address to send from
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/email_sender#from_address EmailSender#from_address}
    */
    readonly fromAddress: string;
    /**
    * Name of sender
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/email_sender#from_name EmailSender#from_name}
    */
    readonly fromName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/email_sender#id EmailSender#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Mail domain to send from
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/email_sender#subdomain EmailSender#subdomain}
    */
    readonly subdomain: string;
}
export interface EmailSenderDnsRecords {
}
export declare function emailSenderDnsRecordsToTerraform(struct?: EmailSenderDnsRecords): any;
export declare class EmailSenderDnsRecordsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EmailSenderDnsRecords | undefined;
    set internalValue(value: EmailSenderDnsRecords | undefined);
    get fqdn(): string;
    get recordType(): string;
    get value(): string;
}
export declare class EmailSenderDnsRecordsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EmailSenderDnsRecordsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/email_sender okta_email_sender}
*/
export declare class EmailSender extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_email_sender";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/email_sender okta_email_sender} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EmailSenderConfig
    */
    constructor(scope: Construct, id: string, config: EmailSenderConfig);
    private _dnsRecords;
    get dnsRecords(): EmailSenderDnsRecordsList;
    private _fromAddress?;
    get fromAddress(): string;
    set fromAddress(value: string);
    get fromAddressInput(): string | undefined;
    private _fromName?;
    get fromName(): string;
    set fromName(value: string);
    get fromNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get status(): string;
    private _subdomain?;
    get subdomain(): string;
    set subdomain(value: string);
    get subdomainInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
