import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FactorTotpConfig extends cdktf.TerraformMetaArguments {
    /**
    * Clock drift interval
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/factor_totp#clock_drift_interval FactorTotp#clock_drift_interval}
    */
    readonly clockDriftInterval?: number;
    /**
    * Hash-based message authentication code algorithm
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/factor_totp#hmac_algorithm FactorTotp#hmac_algorithm}
    */
    readonly hmacAlgorithm?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/factor_totp#id FactorTotp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Factor name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/factor_totp#name FactorTotp#name}
    */
    readonly name: string;
    /**
    * Factor name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/factor_totp#otp_length FactorTotp#otp_length}
    */
    readonly otpLength?: number;
    /**
    * Shared secret encoding
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/factor_totp#shared_secret_encoding FactorTotp#shared_secret_encoding}
    */
    readonly sharedSecretEncoding?: string;
    /**
    * Time step in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/factor_totp#time_step FactorTotp#time_step}
    */
    readonly timeStep?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/factor_totp okta_factor_totp}
*/
export declare class FactorTotp extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_factor_totp";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/factor_totp okta_factor_totp} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FactorTotpConfig
    */
    constructor(scope: Construct, id: string, config: FactorTotpConfig);
    private _clockDriftInterval?;
    get clockDriftInterval(): number;
    set clockDriftInterval(value: number);
    resetClockDriftInterval(): void;
    get clockDriftIntervalInput(): number | undefined;
    private _hmacAlgorithm?;
    get hmacAlgorithm(): string;
    set hmacAlgorithm(value: string);
    resetHmacAlgorithm(): void;
    get hmacAlgorithmInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _otpLength?;
    get otpLength(): number;
    set otpLength(value: number);
    resetOtpLength(): void;
    get otpLengthInput(): number | undefined;
    private _sharedSecretEncoding?;
    get sharedSecretEncoding(): string;
    set sharedSecretEncoding(value: string);
    resetSharedSecretEncoding(): void;
    get sharedSecretEncodingInput(): string | undefined;
    private _timeStep?;
    get timeStep(): number;
    set timeStep(value: number);
    resetTimeStep(): void;
    get timeStepInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
