"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FactorTotp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/factor_totp okta_factor_totp}
*/
class FactorTotp extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/factor_totp okta_factor_totp} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FactorTotpConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'okta_factor_totp',
            terraformGeneratorMetadata: {
                providerName: 'okta',
                providerVersion: '3.35.0',
                providerVersionConstraint: '~> 3.20'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._clockDriftInterval = config.clockDriftInterval;
        this._hmacAlgorithm = config.hmacAlgorithm;
        this._id = config.id;
        this._name = config.name;
        this._otpLength = config.otpLength;
        this._sharedSecretEncoding = config.sharedSecretEncoding;
        this._timeStep = config.timeStep;
    }
    get clockDriftInterval() {
        return this.getNumberAttribute('clock_drift_interval');
    }
    set clockDriftInterval(value) {
        this._clockDriftInterval = value;
    }
    resetClockDriftInterval() {
        this._clockDriftInterval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clockDriftIntervalInput() {
        return this._clockDriftInterval;
    }
    get hmacAlgorithm() {
        return this.getStringAttribute('hmac_algorithm');
    }
    set hmacAlgorithm(value) {
        this._hmacAlgorithm = value;
    }
    resetHmacAlgorithm() {
        this._hmacAlgorithm = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hmacAlgorithmInput() {
        return this._hmacAlgorithm;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get otpLength() {
        return this.getNumberAttribute('otp_length');
    }
    set otpLength(value) {
        this._otpLength = value;
    }
    resetOtpLength() {
        this._otpLength = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get otpLengthInput() {
        return this._otpLength;
    }
    get sharedSecretEncoding() {
        return this.getStringAttribute('shared_secret_encoding');
    }
    set sharedSecretEncoding(value) {
        this._sharedSecretEncoding = value;
    }
    resetSharedSecretEncoding() {
        this._sharedSecretEncoding = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sharedSecretEncodingInput() {
        return this._sharedSecretEncoding;
    }
    get timeStep() {
        return this.getNumberAttribute('time_step');
    }
    set timeStep(value) {
        this._timeStep = value;
    }
    resetTimeStep() {
        this._timeStep = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeStepInput() {
        return this._timeStep;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            clock_drift_interval: cdktf.numberToTerraform(this._clockDriftInterval),
            hmac_algorithm: cdktf.stringToTerraform(this._hmacAlgorithm),
            id: cdktf.stringToTerraform(this._id),
            name: cdktf.stringToTerraform(this._name),
            otp_length: cdktf.numberToTerraform(this._otpLength),
            shared_secret_encoding: cdktf.stringToTerraform(this._sharedSecretEncoding),
            time_step: cdktf.numberToTerraform(this._timeStep),
        };
    }
}
exports.FactorTotp = FactorTotp;
_a = JSII_RTTI_SYMBOL_1;
FactorTotp[_a] = { fqn: "@cdktf/provider-okta.FactorTotp", version: "2.0.46" };
// =================
// STATIC PROPERTIES
// =================
FactorTotp.tfResourceType = "okta_factor_totp";
//# sourceMappingURL=data:application/json;base64,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