import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FactorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Is this provider active?
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/factor#active Factor#active}
    */
    readonly active?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/factor#id Factor#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Factor provider ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/factor#provider_id Factor#provider_id}
    */
    readonly providerId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/factor okta_factor}
*/
export declare class Factor extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_factor";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/factor okta_factor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FactorConfig
    */
    constructor(scope: Construct, id: string, config: FactorConfig);
    private _active?;
    get active(): boolean | cdktf.IResolvable;
    set active(value: boolean | cdktf.IResolvable);
    resetActive(): void;
    get activeInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _providerId?;
    get providerId(): string;
    set providerId(value: string);
    get providerIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
