import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupMembershipsConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of a Okta group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_memberships#group_id GroupMemberships#group_id}
    */
    readonly groupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_memberships#id GroupMemberships#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource concerns itself with all users added/deleted to the group; even those managed outside of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_memberships#track_all_users GroupMemberships#track_all_users}
    */
    readonly trackAllUsers?: boolean | cdktf.IResolvable;
    /**
    * The list of Okta user IDs which the group should have membership managed for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_memberships#users GroupMemberships#users}
    */
    readonly users: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/group_memberships okta_group_memberships}
*/
export declare class GroupMemberships extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_group_memberships";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/group_memberships okta_group_memberships} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupMembershipsConfig
    */
    constructor(scope: Construct, id: string, config: GroupMembershipsConfig);
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _trackAllUsers?;
    get trackAllUsers(): boolean | cdktf.IResolvable;
    set trackAllUsers(value: boolean | cdktf.IResolvable);
    resetTrackAllUsers(): void;
    get trackAllUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _users?;
    get users(): string[];
    set users(value: string[]);
    get usersInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
