import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * When this setting is enabled, the admins won't receive any of the default Okta administrator emails
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_role#disable_notifications GroupRole#disable_notifications}
    */
    readonly disableNotifications?: boolean | cdktf.IResolvable;
    /**
    * ID of group to attach admin roles to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_role#group_id GroupRole#group_id}
    */
    readonly groupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_role#id GroupRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Type of Role to assign
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_role#role_type GroupRole#role_type}
    */
    readonly roleType: string;
    /**
    * List of apps ids for the targets of the admin role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_role#target_app_list GroupRole#target_app_list}
    */
    readonly targetAppList?: string[];
    /**
    * List of groups ids for the targets of the admin role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_role#target_group_list GroupRole#target_group_list}
    */
    readonly targetGroupList?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/group_role okta_group_role}
*/
export declare class GroupRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_group_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/group_role okta_group_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupRoleConfig
    */
    constructor(scope: Construct, id: string, config: GroupRoleConfig);
    private _disableNotifications?;
    get disableNotifications(): boolean | cdktf.IResolvable;
    set disableNotifications(value: boolean | cdktf.IResolvable);
    resetDisableNotifications(): void;
    get disableNotificationsInput(): boolean | cdktf.IResolvable | undefined;
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _roleType?;
    get roleType(): string;
    set roleType(value: string);
    get roleTypeInput(): string | undefined;
    private _targetAppList?;
    get targetAppList(): string[];
    set targetAppList(value: string[]);
    resetTargetAppList(): void;
    get targetAppListInput(): string[] | undefined;
    private _targetGroupList?;
    get targetGroupList(): string[];
    set targetGroupList(value: string[]);
    resetTargetGroupList(): void;
    get targetGroupListInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
