import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupRolesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Admin roles associated with the group. This can also be done per user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_roles#admin_roles GroupRoles#admin_roles}
    */
    readonly adminRoles?: string[];
    /**
    * ID of group to attach admin roles to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_roles#group_id GroupRoles#group_id}
    */
    readonly groupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_roles#id GroupRoles#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/group_roles okta_group_roles}
*/
export declare class GroupRoles extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_group_roles";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/group_roles okta_group_roles} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupRolesConfig
    */
    constructor(scope: Construct, id: string, config: GroupRolesConfig);
    private _adminRoles?;
    get adminRoles(): string[];
    set adminRoles(value: string[]);
    resetAdminRoles(): void;
    get adminRolesInput(): string[] | undefined;
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
