import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_rule#expression_type GroupRule#expression_type}
    */
    readonly expressionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_rule#expression_value GroupRule#expression_value}
    */
    readonly expressionValue: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_rule#group_assignments GroupRule#group_assignments}
    */
    readonly groupAssignments: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_rule#id GroupRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_rule#name GroupRule#name}
    */
    readonly name: string;
    /**
    * Remove users added by this rule from the assigned group after deleting this resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_rule#remove_assigned_users GroupRule#remove_assigned_users}
    */
    readonly removeAssignedUsers?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_rule#status GroupRule#status}
    */
    readonly status?: string;
    /**
    * The list of user IDs that would be excluded when rules are processed
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_rule#users_excluded GroupRule#users_excluded}
    */
    readonly usersExcluded?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/group_rule okta_group_rule}
*/
export declare class GroupRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_group_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/group_rule okta_group_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupRuleConfig
    */
    constructor(scope: Construct, id: string, config: GroupRuleConfig);
    private _expressionType?;
    get expressionType(): string;
    set expressionType(value: string);
    resetExpressionType(): void;
    get expressionTypeInput(): string | undefined;
    private _expressionValue?;
    get expressionValue(): string;
    set expressionValue(value: string);
    get expressionValueInput(): string | undefined;
    private _groupAssignments?;
    get groupAssignments(): string[];
    set groupAssignments(value: string[]);
    get groupAssignmentsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _removeAssignedUsers?;
    get removeAssignedUsers(): boolean | cdktf.IResolvable;
    set removeAssignedUsers(value: boolean | cdktf.IResolvable);
    resetRemoveAssignedUsers(): void;
    get removeAssignedUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _usersExcluded?;
    get usersExcluded(): string[];
    set usersExcluded(value: string[]);
    resetUsersExcluded(): void;
    get usersExcludedInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
