import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupSchemaPropertyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Custom Subschema enumerated value of a property of type array.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#array_enum GroupSchemaProperty#array_enum}
    */
    readonly arrayEnum?: string[];
    /**
    * Subschema array type: string, number, integer, reference. Type field must be an array.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#array_type GroupSchemaProperty#array_type}
    */
    readonly arrayType?: string;
    /**
    * Custom Subschema description
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#description GroupSchemaProperty#description}
    */
    readonly description?: string;
    /**
    * Custom Subschema enumerated value of the property. see: developer.okta.com/docs/api/resources/schemas#user-profile-schema-property-object
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#enum GroupSchemaProperty#enum}
    */
    readonly enum?: string[];
    /**
    * Subschema external name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#external_name GroupSchemaProperty#external_name}
    */
    readonly externalName?: string;
    /**
    * Subschema external namespace
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#external_namespace GroupSchemaProperty#external_namespace}
    */
    readonly externalNamespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#id GroupSchemaProperty#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Subschema unique string identifier
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#index GroupSchemaProperty#index}
    */
    readonly index: string;
    /**
    * SubSchema profile manager, if not set it will inherit its setting.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#master GroupSchemaProperty#master}
    */
    readonly master?: string;
    /**
    * Subschema of type string maximum length
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#max_length GroupSchemaProperty#max_length}
    */
    readonly maxLength?: number;
    /**
    * Subschema of type string minimum length
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#min_length GroupSchemaProperty#min_length}
    */
    readonly minLength?: number;
    /**
    * SubSchema permissions: HIDE, READ_ONLY, or READ_WRITE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#permissions GroupSchemaProperty#permissions}
    */
    readonly permissions?: string;
    /**
    * Whether the subschema is required
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#required GroupSchemaProperty#required}
    */
    readonly required?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#scope GroupSchemaProperty#scope}
    */
    readonly scope?: string;
    /**
    * Subschema title (display name)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#title GroupSchemaProperty#title}
    */
    readonly title: string;
    /**
    * Subschema type: string, boolean, number, integer, array, or object
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#type GroupSchemaProperty#type}
    */
    readonly type: string;
    /**
    * Subschema unique restriction
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#unique GroupSchemaProperty#unique}
    */
    readonly unique?: string;
    /**
    * array_one_of block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#array_one_of GroupSchemaProperty#array_one_of}
    */
    readonly arrayOneOf?: GroupSchemaPropertyArrayOneOf[] | cdktf.IResolvable;
    /**
    * master_override_priority block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#master_override_priority GroupSchemaProperty#master_override_priority}
    */
    readonly masterOverridePriority?: GroupSchemaPropertyMasterOverridePriority[] | cdktf.IResolvable;
    /**
    * one_of block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#one_of GroupSchemaProperty#one_of}
    */
    readonly oneOf?: GroupSchemaPropertyOneOf[] | cdktf.IResolvable;
}
export interface GroupSchemaPropertyArrayOneOf {
    /**
    * Enum value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#const GroupSchemaProperty#const}
    */
    readonly const: string;
    /**
    * Enum title
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#title GroupSchemaProperty#title}
    */
    readonly title: string;
}
export declare function groupSchemaPropertyArrayOneOfToTerraform(struct?: GroupSchemaPropertyArrayOneOf | cdktf.IResolvable): any;
export declare class GroupSchemaPropertyArrayOneOfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GroupSchemaPropertyArrayOneOf | cdktf.IResolvable | undefined;
    set internalValue(value: GroupSchemaPropertyArrayOneOf | cdktf.IResolvable | undefined);
    private _const?;
    get const(): string;
    set const(value: string);
    get constInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
export declare class GroupSchemaPropertyArrayOneOfList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GroupSchemaPropertyArrayOneOf[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GroupSchemaPropertyArrayOneOfOutputReference;
}
export interface GroupSchemaPropertyMasterOverridePriority {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#type GroupSchemaProperty#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#value GroupSchemaProperty#value}
    */
    readonly value: string;
}
export declare function groupSchemaPropertyMasterOverridePriorityToTerraform(struct?: GroupSchemaPropertyMasterOverridePriority | cdktf.IResolvable): any;
export declare class GroupSchemaPropertyMasterOverridePriorityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GroupSchemaPropertyMasterOverridePriority | cdktf.IResolvable | undefined;
    set internalValue(value: GroupSchemaPropertyMasterOverridePriority | cdktf.IResolvable | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class GroupSchemaPropertyMasterOverridePriorityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GroupSchemaPropertyMasterOverridePriority[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GroupSchemaPropertyMasterOverridePriorityOutputReference;
}
export interface GroupSchemaPropertyOneOf {
    /**
    * Enum value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#const GroupSchemaProperty#const}
    */
    readonly const: string;
    /**
    * Enum title
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property#title GroupSchemaProperty#title}
    */
    readonly title: string;
}
export declare function groupSchemaPropertyOneOfToTerraform(struct?: GroupSchemaPropertyOneOf | cdktf.IResolvable): any;
export declare class GroupSchemaPropertyOneOfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GroupSchemaPropertyOneOf | cdktf.IResolvable | undefined;
    set internalValue(value: GroupSchemaPropertyOneOf | cdktf.IResolvable | undefined);
    private _const?;
    get const(): string;
    set const(value: string);
    get constInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
export declare class GroupSchemaPropertyOneOfList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GroupSchemaPropertyOneOf[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GroupSchemaPropertyOneOfOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property okta_group_schema_property}
*/
export declare class GroupSchemaProperty extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_group_schema_property";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property okta_group_schema_property} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupSchemaPropertyConfig
    */
    constructor(scope: Construct, id: string, config: GroupSchemaPropertyConfig);
    private _arrayEnum?;
    get arrayEnum(): string[];
    set arrayEnum(value: string[]);
    resetArrayEnum(): void;
    get arrayEnumInput(): string[] | undefined;
    private _arrayType?;
    get arrayType(): string;
    set arrayType(value: string);
    resetArrayType(): void;
    get arrayTypeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enum?;
    get enum(): string[];
    set enum(value: string[]);
    resetEnum(): void;
    get enumInput(): string[] | undefined;
    private _externalName?;
    get externalName(): string;
    set externalName(value: string);
    resetExternalName(): void;
    get externalNameInput(): string | undefined;
    private _externalNamespace?;
    get externalNamespace(): string;
    set externalNamespace(value: string);
    resetExternalNamespace(): void;
    get externalNamespaceInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _master?;
    get master(): string;
    set master(value: string);
    resetMaster(): void;
    get masterInput(): string | undefined;
    private _maxLength?;
    get maxLength(): number;
    set maxLength(value: number);
    resetMaxLength(): void;
    get maxLengthInput(): number | undefined;
    private _minLength?;
    get minLength(): number;
    set minLength(value: number);
    resetMinLength(): void;
    get minLengthInput(): number | undefined;
    private _permissions?;
    get permissions(): string;
    set permissions(value: string);
    resetPermissions(): void;
    get permissionsInput(): string | undefined;
    private _required?;
    get required(): boolean | cdktf.IResolvable;
    set required(value: boolean | cdktf.IResolvable);
    resetRequired(): void;
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _unique?;
    get unique(): string;
    set unique(value: string);
    resetUnique(): void;
    get uniqueInput(): string | undefined;
    private _arrayOneOf;
    get arrayOneOf(): GroupSchemaPropertyArrayOneOfList;
    putArrayOneOf(value: GroupSchemaPropertyArrayOneOf[] | cdktf.IResolvable): void;
    resetArrayOneOf(): void;
    get arrayOneOfInput(): cdktf.IResolvable | GroupSchemaPropertyArrayOneOf[] | undefined;
    private _masterOverridePriority;
    get masterOverridePriority(): GroupSchemaPropertyMasterOverridePriorityList;
    putMasterOverridePriority(value: GroupSchemaPropertyMasterOverridePriority[] | cdktf.IResolvable): void;
    resetMasterOverridePriority(): void;
    get masterOverridePriorityInput(): cdktf.IResolvable | GroupSchemaPropertyMasterOverridePriority[] | undefined;
    private _oneOf;
    get oneOf(): GroupSchemaPropertyOneOfList;
    putOneOf(value: GroupSchemaPropertyOneOf[] | cdktf.IResolvable): void;
    resetOneOf(): void;
    get oneOfInput(): cdktf.IResolvable | GroupSchemaPropertyOneOf[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
