import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * JSON formatted custom attributes for a group. It must be JSON due to various types Okta allows.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group#custom_profile_attributes Group#custom_profile_attributes}
    */
    readonly customProfileAttributes?: string;
    /**
    * Group description
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group#description Group#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group#id Group#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Group name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group#name Group#name}
    */
    readonly name: string;
    /**
    * Ignore users sync. This is a temporary solution until 'users' field is supported in this resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group#skip_users Group#skip_users}
    */
    readonly skipUsers?: boolean | cdktf.IResolvable;
    /**
    * Users associated with the group. This can also be done per user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group#users Group#users}
    */
    readonly users?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/group okta_group}
*/
export declare class Group extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/group okta_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupConfig
    */
    constructor(scope: Construct, id: string, config: GroupConfig);
    private _customProfileAttributes?;
    get customProfileAttributes(): string;
    set customProfileAttributes(value: string);
    resetCustomProfileAttributes(): void;
    get customProfileAttributesInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _skipUsers?;
    get skipUsers(): boolean | cdktf.IResolvable;
    set skipUsers(value: boolean | cdktf.IResolvable);
    resetSkipUsers(): void;
    get skipUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _users?;
    get users(): string[];
    set users(value: string[]);
    resetUsers(): void;
    get usersInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
