import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdpOidcConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#account_link_action IdpOidc#account_link_action}
    */
    readonly accountLinkAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#account_link_group_include IdpOidc#account_link_group_include}
    */
    readonly accountLinkGroupInclude?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#authorization_binding IdpOidc#authorization_binding}
    */
    readonly authorizationBinding: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#authorization_url IdpOidc#authorization_url}
    */
    readonly authorizationUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#client_id IdpOidc#client_id}
    */
    readonly clientId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#client_secret IdpOidc#client_secret}
    */
    readonly clientSecret: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#deprovisioned_action IdpOidc#deprovisioned_action}
    */
    readonly deprovisionedAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#groups_action IdpOidc#groups_action}
    */
    readonly groupsAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#groups_assignment IdpOidc#groups_assignment}
    */
    readonly groupsAssignment?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#groups_attribute IdpOidc#groups_attribute}
    */
    readonly groupsAttribute?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#groups_filter IdpOidc#groups_filter}
    */
    readonly groupsFilter?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#id IdpOidc#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#issuer_mode IdpOidc#issuer_mode}
    */
    readonly issuerMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#issuer_url IdpOidc#issuer_url}
    */
    readonly issuerUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#jwks_binding IdpOidc#jwks_binding}
    */
    readonly jwksBinding: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#jwks_url IdpOidc#jwks_url}
    */
    readonly jwksUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#max_clock_skew IdpOidc#max_clock_skew}
    */
    readonly maxClockSkew?: number;
    /**
    * Name of the IdP
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#name IdpOidc#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#profile_master IdpOidc#profile_master}
    */
    readonly profileMaster?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#protocol_type IdpOidc#protocol_type}
    */
    readonly protocolType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#provisioning_action IdpOidc#provisioning_action}
    */
    readonly provisioningAction?: string;
    /**
    * The HMAC Signature Algorithm used when signing an authorization request
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#request_signature_algorithm IdpOidc#request_signature_algorithm}
    */
    readonly requestSignatureAlgorithm?: string;
    /**
    * Specifies whether to digitally sign an authorization request to the IdP
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#request_signature_scope IdpOidc#request_signature_scope}
    */
    readonly requestSignatureScope?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#scopes IdpOidc#scopes}
    */
    readonly scopes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#status IdpOidc#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#subject_match_attribute IdpOidc#subject_match_attribute}
    */
    readonly subjectMatchAttribute?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#subject_match_type IdpOidc#subject_match_type}
    */
    readonly subjectMatchType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#suspended_action IdpOidc#suspended_action}
    */
    readonly suspendedAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#token_binding IdpOidc#token_binding}
    */
    readonly tokenBinding: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#token_url IdpOidc#token_url}
    */
    readonly tokenUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#user_info_binding IdpOidc#user_info_binding}
    */
    readonly userInfoBinding?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#user_info_url IdpOidc#user_info_url}
    */
    readonly userInfoUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc#username_template IdpOidc#username_template}
    */
    readonly usernameTemplate?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc okta_idp_oidc}
*/
export declare class IdpOidc extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_idp_oidc";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc okta_idp_oidc} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdpOidcConfig
    */
    constructor(scope: Construct, id: string, config: IdpOidcConfig);
    private _accountLinkAction?;
    get accountLinkAction(): string;
    set accountLinkAction(value: string);
    resetAccountLinkAction(): void;
    get accountLinkActionInput(): string | undefined;
    private _accountLinkGroupInclude?;
    get accountLinkGroupInclude(): string[];
    set accountLinkGroupInclude(value: string[]);
    resetAccountLinkGroupInclude(): void;
    get accountLinkGroupIncludeInput(): string[] | undefined;
    private _authorizationBinding?;
    get authorizationBinding(): string;
    set authorizationBinding(value: string);
    get authorizationBindingInput(): string | undefined;
    private _authorizationUrl?;
    get authorizationUrl(): string;
    set authorizationUrl(value: string);
    get authorizationUrlInput(): string | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    get clientSecretInput(): string | undefined;
    private _deprovisionedAction?;
    get deprovisionedAction(): string;
    set deprovisionedAction(value: string);
    resetDeprovisionedAction(): void;
    get deprovisionedActionInput(): string | undefined;
    private _groupsAction?;
    get groupsAction(): string;
    set groupsAction(value: string);
    resetGroupsAction(): void;
    get groupsActionInput(): string | undefined;
    private _groupsAssignment?;
    get groupsAssignment(): string[];
    set groupsAssignment(value: string[]);
    resetGroupsAssignment(): void;
    get groupsAssignmentInput(): string[] | undefined;
    private _groupsAttribute?;
    get groupsAttribute(): string;
    set groupsAttribute(value: string);
    resetGroupsAttribute(): void;
    get groupsAttributeInput(): string | undefined;
    private _groupsFilter?;
    get groupsFilter(): string[];
    set groupsFilter(value: string[]);
    resetGroupsFilter(): void;
    get groupsFilterInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _issuerMode?;
    get issuerMode(): string;
    set issuerMode(value: string);
    resetIssuerMode(): void;
    get issuerModeInput(): string | undefined;
    private _issuerUrl?;
    get issuerUrl(): string;
    set issuerUrl(value: string);
    get issuerUrlInput(): string | undefined;
    private _jwksBinding?;
    get jwksBinding(): string;
    set jwksBinding(value: string);
    get jwksBindingInput(): string | undefined;
    private _jwksUrl?;
    get jwksUrl(): string;
    set jwksUrl(value: string);
    get jwksUrlInput(): string | undefined;
    private _maxClockSkew?;
    get maxClockSkew(): number;
    set maxClockSkew(value: number);
    resetMaxClockSkew(): void;
    get maxClockSkewInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _profileMaster?;
    get profileMaster(): boolean | cdktf.IResolvable;
    set profileMaster(value: boolean | cdktf.IResolvable);
    resetProfileMaster(): void;
    get profileMasterInput(): boolean | cdktf.IResolvable | undefined;
    private _protocolType?;
    get protocolType(): string;
    set protocolType(value: string);
    resetProtocolType(): void;
    get protocolTypeInput(): string | undefined;
    private _provisioningAction?;
    get provisioningAction(): string;
    set provisioningAction(value: string);
    resetProvisioningAction(): void;
    get provisioningActionInput(): string | undefined;
    private _requestSignatureAlgorithm?;
    get requestSignatureAlgorithm(): string;
    set requestSignatureAlgorithm(value: string);
    resetRequestSignatureAlgorithm(): void;
    get requestSignatureAlgorithmInput(): string | undefined;
    private _requestSignatureScope?;
    get requestSignatureScope(): string;
    set requestSignatureScope(value: string);
    resetRequestSignatureScope(): void;
    get requestSignatureScopeInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _subjectMatchAttribute?;
    get subjectMatchAttribute(): string;
    set subjectMatchAttribute(value: string);
    resetSubjectMatchAttribute(): void;
    get subjectMatchAttributeInput(): string | undefined;
    private _subjectMatchType?;
    get subjectMatchType(): string;
    set subjectMatchType(value: string);
    resetSubjectMatchType(): void;
    get subjectMatchTypeInput(): string | undefined;
    private _suspendedAction?;
    get suspendedAction(): string;
    set suspendedAction(value: string);
    resetSuspendedAction(): void;
    get suspendedActionInput(): string | undefined;
    private _tokenBinding?;
    get tokenBinding(): string;
    set tokenBinding(value: string);
    get tokenBindingInput(): string | undefined;
    private _tokenUrl?;
    get tokenUrl(): string;
    set tokenUrl(value: string);
    get tokenUrlInput(): string | undefined;
    get type(): string;
    private _userInfoBinding?;
    get userInfoBinding(): string;
    set userInfoBinding(value: string);
    resetUserInfoBinding(): void;
    get userInfoBindingInput(): string | undefined;
    private _userInfoUrl?;
    get userInfoUrl(): string;
    set userInfoUrl(value: string);
    resetUserInfoUrl(): void;
    get userInfoUrlInput(): string | undefined;
    get userTypeId(): string;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
