import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdpSamlConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#account_link_action IdpSaml#account_link_action}
    */
    readonly accountLinkAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#account_link_group_include IdpSaml#account_link_group_include}
    */
    readonly accountLinkGroupInclude?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#acs_binding IdpSaml#acs_binding}
    */
    readonly acsBinding?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#acs_type IdpSaml#acs_type}
    */
    readonly acsType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#deprovisioned_action IdpSaml#deprovisioned_action}
    */
    readonly deprovisionedAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#groups_action IdpSaml#groups_action}
    */
    readonly groupsAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#groups_assignment IdpSaml#groups_assignment}
    */
    readonly groupsAssignment?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#groups_attribute IdpSaml#groups_attribute}
    */
    readonly groupsAttribute?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#groups_filter IdpSaml#groups_filter}
    */
    readonly groupsFilter?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#id IdpSaml#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#issuer IdpSaml#issuer}
    */
    readonly issuer: string;
    /**
    * Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#issuer_mode IdpSaml#issuer_mode}
    */
    readonly issuerMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#kid IdpSaml#kid}
    */
    readonly kid: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#max_clock_skew IdpSaml#max_clock_skew}
    */
    readonly maxClockSkew?: number;
    /**
    * Name of the IdP
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#name IdpSaml#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#name_format IdpSaml#name_format}
    */
    readonly nameFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#profile_master IdpSaml#profile_master}
    */
    readonly profileMaster?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#provisioning_action IdpSaml#provisioning_action}
    */
    readonly provisioningAction?: string;
    /**
    * The XML digital Signature Algorithm used when signing an <AuthnRequest> message
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#request_signature_algorithm IdpSaml#request_signature_algorithm}
    */
    readonly requestSignatureAlgorithm?: string;
    /**
    * Specifies whether to digitally sign <AuthnRequest> messages to the IdP
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#request_signature_scope IdpSaml#request_signature_scope}
    */
    readonly requestSignatureScope?: string;
    /**
    * The minimum XML digital Signature Algorithm allowed when verifying a <SAMLResponse> message or <Assertion> element
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#response_signature_algorithm IdpSaml#response_signature_algorithm}
    */
    readonly responseSignatureAlgorithm?: string;
    /**
    * Specifies whether to verify a <SAMLResponse> message or <Assertion> element XML digital signature
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#response_signature_scope IdpSaml#response_signature_scope}
    */
    readonly responseSignatureScope?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#sso_binding IdpSaml#sso_binding}
    */
    readonly ssoBinding?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#sso_destination IdpSaml#sso_destination}
    */
    readonly ssoDestination?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#sso_url IdpSaml#sso_url}
    */
    readonly ssoUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#status IdpSaml#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#subject_filter IdpSaml#subject_filter}
    */
    readonly subjectFilter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#subject_format IdpSaml#subject_format}
    */
    readonly subjectFormat?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#subject_match_attribute IdpSaml#subject_match_attribute}
    */
    readonly subjectMatchAttribute?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#subject_match_type IdpSaml#subject_match_type}
    */
    readonly subjectMatchType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#suspended_action IdpSaml#suspended_action}
    */
    readonly suspendedAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_saml#username_template IdpSaml#username_template}
    */
    readonly usernameTemplate?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/idp_saml okta_idp_saml}
*/
export declare class IdpSaml extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_idp_saml";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/idp_saml okta_idp_saml} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdpSamlConfig
    */
    constructor(scope: Construct, id: string, config: IdpSamlConfig);
    private _accountLinkAction?;
    get accountLinkAction(): string;
    set accountLinkAction(value: string);
    resetAccountLinkAction(): void;
    get accountLinkActionInput(): string | undefined;
    private _accountLinkGroupInclude?;
    get accountLinkGroupInclude(): string[];
    set accountLinkGroupInclude(value: string[]);
    resetAccountLinkGroupInclude(): void;
    get accountLinkGroupIncludeInput(): string[] | undefined;
    private _acsBinding?;
    get acsBinding(): string;
    set acsBinding(value: string);
    resetAcsBinding(): void;
    get acsBindingInput(): string | undefined;
    private _acsType?;
    get acsType(): string;
    set acsType(value: string);
    resetAcsType(): void;
    get acsTypeInput(): string | undefined;
    get audience(): string;
    private _deprovisionedAction?;
    get deprovisionedAction(): string;
    set deprovisionedAction(value: string);
    resetDeprovisionedAction(): void;
    get deprovisionedActionInput(): string | undefined;
    private _groupsAction?;
    get groupsAction(): string;
    set groupsAction(value: string);
    resetGroupsAction(): void;
    get groupsActionInput(): string | undefined;
    private _groupsAssignment?;
    get groupsAssignment(): string[];
    set groupsAssignment(value: string[]);
    resetGroupsAssignment(): void;
    get groupsAssignmentInput(): string[] | undefined;
    private _groupsAttribute?;
    get groupsAttribute(): string;
    set groupsAttribute(value: string);
    resetGroupsAttribute(): void;
    get groupsAttributeInput(): string | undefined;
    private _groupsFilter?;
    get groupsFilter(): string[];
    set groupsFilter(value: string[]);
    resetGroupsFilter(): void;
    get groupsFilterInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    get issuerInput(): string | undefined;
    private _issuerMode?;
    get issuerMode(): string;
    set issuerMode(value: string);
    resetIssuerMode(): void;
    get issuerModeInput(): string | undefined;
    private _kid?;
    get kid(): string;
    set kid(value: string);
    get kidInput(): string | undefined;
    private _maxClockSkew?;
    get maxClockSkew(): number;
    set maxClockSkew(value: number);
    resetMaxClockSkew(): void;
    get maxClockSkewInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nameFormat?;
    get nameFormat(): string;
    set nameFormat(value: string);
    resetNameFormat(): void;
    get nameFormatInput(): string | undefined;
    private _profileMaster?;
    get profileMaster(): boolean | cdktf.IResolvable;
    set profileMaster(value: boolean | cdktf.IResolvable);
    resetProfileMaster(): void;
    get profileMasterInput(): boolean | cdktf.IResolvable | undefined;
    private _provisioningAction?;
    get provisioningAction(): string;
    set provisioningAction(value: string);
    resetProvisioningAction(): void;
    get provisioningActionInput(): string | undefined;
    private _requestSignatureAlgorithm?;
    get requestSignatureAlgorithm(): string;
    set requestSignatureAlgorithm(value: string);
    resetRequestSignatureAlgorithm(): void;
    get requestSignatureAlgorithmInput(): string | undefined;
    private _requestSignatureScope?;
    get requestSignatureScope(): string;
    set requestSignatureScope(value: string);
    resetRequestSignatureScope(): void;
    get requestSignatureScopeInput(): string | undefined;
    private _responseSignatureAlgorithm?;
    get responseSignatureAlgorithm(): string;
    set responseSignatureAlgorithm(value: string);
    resetResponseSignatureAlgorithm(): void;
    get responseSignatureAlgorithmInput(): string | undefined;
    private _responseSignatureScope?;
    get responseSignatureScope(): string;
    set responseSignatureScope(value: string);
    resetResponseSignatureScope(): void;
    get responseSignatureScopeInput(): string | undefined;
    private _ssoBinding?;
    get ssoBinding(): string;
    set ssoBinding(value: string);
    resetSsoBinding(): void;
    get ssoBindingInput(): string | undefined;
    private _ssoDestination?;
    get ssoDestination(): string;
    set ssoDestination(value: string);
    resetSsoDestination(): void;
    get ssoDestinationInput(): string | undefined;
    private _ssoUrl?;
    get ssoUrl(): string;
    set ssoUrl(value: string);
    get ssoUrlInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _subjectFilter?;
    get subjectFilter(): string;
    set subjectFilter(value: string);
    resetSubjectFilter(): void;
    get subjectFilterInput(): string | undefined;
    private _subjectFormat?;
    get subjectFormat(): string[];
    set subjectFormat(value: string[]);
    resetSubjectFormat(): void;
    get subjectFormatInput(): string[] | undefined;
    private _subjectMatchAttribute?;
    get subjectMatchAttribute(): string;
    set subjectMatchAttribute(value: string);
    resetSubjectMatchAttribute(): void;
    get subjectMatchAttributeInput(): string | undefined;
    private _subjectMatchType?;
    get subjectMatchType(): string;
    set subjectMatchType(value: string);
    resetSubjectMatchType(): void;
    get subjectMatchTypeInput(): string | undefined;
    private _suspendedAction?;
    get suspendedAction(): string;
    set suspendedAction(value: string);
    resetSuspendedAction(): void;
    get suspendedActionInput(): string | undefined;
    get type(): string;
    get userTypeId(): string;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
