"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IdpSaml = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/idp_saml okta_idp_saml}
*/
class IdpSaml extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/idp_saml okta_idp_saml} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdpSamlConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'okta_idp_saml',
            terraformGeneratorMetadata: {
                providerName: 'okta',
                providerVersion: '3.35.0',
                providerVersionConstraint: '~> 3.20'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._accountLinkAction = config.accountLinkAction;
        this._accountLinkGroupInclude = config.accountLinkGroupInclude;
        this._acsBinding = config.acsBinding;
        this._acsType = config.acsType;
        this._deprovisionedAction = config.deprovisionedAction;
        this._groupsAction = config.groupsAction;
        this._groupsAssignment = config.groupsAssignment;
        this._groupsAttribute = config.groupsAttribute;
        this._groupsFilter = config.groupsFilter;
        this._id = config.id;
        this._issuer = config.issuer;
        this._issuerMode = config.issuerMode;
        this._kid = config.kid;
        this._maxClockSkew = config.maxClockSkew;
        this._name = config.name;
        this._nameFormat = config.nameFormat;
        this._profileMaster = config.profileMaster;
        this._provisioningAction = config.provisioningAction;
        this._requestSignatureAlgorithm = config.requestSignatureAlgorithm;
        this._requestSignatureScope = config.requestSignatureScope;
        this._responseSignatureAlgorithm = config.responseSignatureAlgorithm;
        this._responseSignatureScope = config.responseSignatureScope;
        this._ssoBinding = config.ssoBinding;
        this._ssoDestination = config.ssoDestination;
        this._ssoUrl = config.ssoUrl;
        this._status = config.status;
        this._subjectFilter = config.subjectFilter;
        this._subjectFormat = config.subjectFormat;
        this._subjectMatchAttribute = config.subjectMatchAttribute;
        this._subjectMatchType = config.subjectMatchType;
        this._suspendedAction = config.suspendedAction;
        this._usernameTemplate = config.usernameTemplate;
    }
    get accountLinkAction() {
        return this.getStringAttribute('account_link_action');
    }
    set accountLinkAction(value) {
        this._accountLinkAction = value;
    }
    resetAccountLinkAction() {
        this._accountLinkAction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accountLinkActionInput() {
        return this._accountLinkAction;
    }
    get accountLinkGroupInclude() {
        return cdktf.Fn.tolist(this.getListAttribute('account_link_group_include'));
    }
    set accountLinkGroupInclude(value) {
        this._accountLinkGroupInclude = value;
    }
    resetAccountLinkGroupInclude() {
        this._accountLinkGroupInclude = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accountLinkGroupIncludeInput() {
        return this._accountLinkGroupInclude;
    }
    get acsBinding() {
        return this.getStringAttribute('acs_binding');
    }
    set acsBinding(value) {
        this._acsBinding = value;
    }
    resetAcsBinding() {
        this._acsBinding = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get acsBindingInput() {
        return this._acsBinding;
    }
    get acsType() {
        return this.getStringAttribute('acs_type');
    }
    set acsType(value) {
        this._acsType = value;
    }
    resetAcsType() {
        this._acsType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get acsTypeInput() {
        return this._acsType;
    }
    // audience - computed: true, optional: false, required: false
    get audience() {
        return this.getStringAttribute('audience');
    }
    get deprovisionedAction() {
        return this.getStringAttribute('deprovisioned_action');
    }
    set deprovisionedAction(value) {
        this._deprovisionedAction = value;
    }
    resetDeprovisionedAction() {
        this._deprovisionedAction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deprovisionedActionInput() {
        return this._deprovisionedAction;
    }
    get groupsAction() {
        return this.getStringAttribute('groups_action');
    }
    set groupsAction(value) {
        this._groupsAction = value;
    }
    resetGroupsAction() {
        this._groupsAction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupsActionInput() {
        return this._groupsAction;
    }
    get groupsAssignment() {
        return cdktf.Fn.tolist(this.getListAttribute('groups_assignment'));
    }
    set groupsAssignment(value) {
        this._groupsAssignment = value;
    }
    resetGroupsAssignment() {
        this._groupsAssignment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupsAssignmentInput() {
        return this._groupsAssignment;
    }
    get groupsAttribute() {
        return this.getStringAttribute('groups_attribute');
    }
    set groupsAttribute(value) {
        this._groupsAttribute = value;
    }
    resetGroupsAttribute() {
        this._groupsAttribute = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupsAttributeInput() {
        return this._groupsAttribute;
    }
    get groupsFilter() {
        return cdktf.Fn.tolist(this.getListAttribute('groups_filter'));
    }
    set groupsFilter(value) {
        this._groupsFilter = value;
    }
    resetGroupsFilter() {
        this._groupsFilter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupsFilterInput() {
        return this._groupsFilter;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get issuer() {
        return this.getStringAttribute('issuer');
    }
    set issuer(value) {
        this._issuer = value;
    }
    // Temporarily expose input value. Use with caution.
    get issuerInput() {
        return this._issuer;
    }
    get issuerMode() {
        return this.getStringAttribute('issuer_mode');
    }
    set issuerMode(value) {
        this._issuerMode = value;
    }
    resetIssuerMode() {
        this._issuerMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuerModeInput() {
        return this._issuerMode;
    }
    get kid() {
        return this.getStringAttribute('kid');
    }
    set kid(value) {
        this._kid = value;
    }
    // Temporarily expose input value. Use with caution.
    get kidInput() {
        return this._kid;
    }
    get maxClockSkew() {
        return this.getNumberAttribute('max_clock_skew');
    }
    set maxClockSkew(value) {
        this._maxClockSkew = value;
    }
    resetMaxClockSkew() {
        this._maxClockSkew = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxClockSkewInput() {
        return this._maxClockSkew;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get nameFormat() {
        return this.getStringAttribute('name_format');
    }
    set nameFormat(value) {
        this._nameFormat = value;
    }
    resetNameFormat() {
        this._nameFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nameFormatInput() {
        return this._nameFormat;
    }
    get profileMaster() {
        return this.getBooleanAttribute('profile_master');
    }
    set profileMaster(value) {
        this._profileMaster = value;
    }
    resetProfileMaster() {
        this._profileMaster = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get profileMasterInput() {
        return this._profileMaster;
    }
    get provisioningAction() {
        return this.getStringAttribute('provisioning_action');
    }
    set provisioningAction(value) {
        this._provisioningAction = value;
    }
    resetProvisioningAction() {
        this._provisioningAction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get provisioningActionInput() {
        return this._provisioningAction;
    }
    get requestSignatureAlgorithm() {
        return this.getStringAttribute('request_signature_algorithm');
    }
    set requestSignatureAlgorithm(value) {
        this._requestSignatureAlgorithm = value;
    }
    resetRequestSignatureAlgorithm() {
        this._requestSignatureAlgorithm = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestSignatureAlgorithmInput() {
        return this._requestSignatureAlgorithm;
    }
    get requestSignatureScope() {
        return this.getStringAttribute('request_signature_scope');
    }
    set requestSignatureScope(value) {
        this._requestSignatureScope = value;
    }
    resetRequestSignatureScope() {
        this._requestSignatureScope = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestSignatureScopeInput() {
        return this._requestSignatureScope;
    }
    get responseSignatureAlgorithm() {
        return this.getStringAttribute('response_signature_algorithm');
    }
    set responseSignatureAlgorithm(value) {
        this._responseSignatureAlgorithm = value;
    }
    resetResponseSignatureAlgorithm() {
        this._responseSignatureAlgorithm = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get responseSignatureAlgorithmInput() {
        return this._responseSignatureAlgorithm;
    }
    get responseSignatureScope() {
        return this.getStringAttribute('response_signature_scope');
    }
    set responseSignatureScope(value) {
        this._responseSignatureScope = value;
    }
    resetResponseSignatureScope() {
        this._responseSignatureScope = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get responseSignatureScopeInput() {
        return this._responseSignatureScope;
    }
    get ssoBinding() {
        return this.getStringAttribute('sso_binding');
    }
    set ssoBinding(value) {
        this._ssoBinding = value;
    }
    resetSsoBinding() {
        this._ssoBinding = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ssoBindingInput() {
        return this._ssoBinding;
    }
    get ssoDestination() {
        return this.getStringAttribute('sso_destination');
    }
    set ssoDestination(value) {
        this._ssoDestination = value;
    }
    resetSsoDestination() {
        this._ssoDestination = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ssoDestinationInput() {
        return this._ssoDestination;
    }
    get ssoUrl() {
        return this.getStringAttribute('sso_url');
    }
    set ssoUrl(value) {
        this._ssoUrl = value;
    }
    // Temporarily expose input value. Use with caution.
    get ssoUrlInput() {
        return this._ssoUrl;
    }
    get status() {
        return this.getStringAttribute('status');
    }
    set status(value) {
        this._status = value;
    }
    resetStatus() {
        this._status = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get statusInput() {
        return this._status;
    }
    get subjectFilter() {
        return this.getStringAttribute('subject_filter');
    }
    set subjectFilter(value) {
        this._subjectFilter = value;
    }
    resetSubjectFilter() {
        this._subjectFilter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get subjectFilterInput() {
        return this._subjectFilter;
    }
    get subjectFormat() {
        return cdktf.Fn.tolist(this.getListAttribute('subject_format'));
    }
    set subjectFormat(value) {
        this._subjectFormat = value;
    }
    resetSubjectFormat() {
        this._subjectFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get subjectFormatInput() {
        return this._subjectFormat;
    }
    get subjectMatchAttribute() {
        return this.getStringAttribute('subject_match_attribute');
    }
    set subjectMatchAttribute(value) {
        this._subjectMatchAttribute = value;
    }
    resetSubjectMatchAttribute() {
        this._subjectMatchAttribute = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get subjectMatchAttributeInput() {
        return this._subjectMatchAttribute;
    }
    get subjectMatchType() {
        return this.getStringAttribute('subject_match_type');
    }
    set subjectMatchType(value) {
        this._subjectMatchType = value;
    }
    resetSubjectMatchType() {
        this._subjectMatchType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get subjectMatchTypeInput() {
        return this._subjectMatchType;
    }
    get suspendedAction() {
        return this.getStringAttribute('suspended_action');
    }
    set suspendedAction(value) {
        this._suspendedAction = value;
    }
    resetSuspendedAction() {
        this._suspendedAction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get suspendedActionInput() {
        return this._suspendedAction;
    }
    // type - computed: true, optional: false, required: false
    get type() {
        return this.getStringAttribute('type');
    }
    // user_type_id - computed: true, optional: false, required: false
    get userTypeId() {
        return this.getStringAttribute('user_type_id');
    }
    get usernameTemplate() {
        return this.getStringAttribute('username_template');
    }
    set usernameTemplate(value) {
        this._usernameTemplate = value;
    }
    resetUsernameTemplate() {
        this._usernameTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get usernameTemplateInput() {
        return this._usernameTemplate;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            account_link_action: cdktf.stringToTerraform(this._accountLinkAction),
            account_link_group_include: cdktf.listMapper(cdktf.stringToTerraform, false)(this._accountLinkGroupInclude),
            acs_binding: cdktf.stringToTerraform(this._acsBinding),
            acs_type: cdktf.stringToTerraform(this._acsType),
            deprovisioned_action: cdktf.stringToTerraform(this._deprovisionedAction),
            groups_action: cdktf.stringToTerraform(this._groupsAction),
            groups_assignment: cdktf.listMapper(cdktf.stringToTerraform, false)(this._groupsAssignment),
            groups_attribute: cdktf.stringToTerraform(this._groupsAttribute),
            groups_filter: cdktf.listMapper(cdktf.stringToTerraform, false)(this._groupsFilter),
            id: cdktf.stringToTerraform(this._id),
            issuer: cdktf.stringToTerraform(this._issuer),
            issuer_mode: cdktf.stringToTerraform(this._issuerMode),
            kid: cdktf.stringToTerraform(this._kid),
            max_clock_skew: cdktf.numberToTerraform(this._maxClockSkew),
            name: cdktf.stringToTerraform(this._name),
            name_format: cdktf.stringToTerraform(this._nameFormat),
            profile_master: cdktf.booleanToTerraform(this._profileMaster),
            provisioning_action: cdktf.stringToTerraform(this._provisioningAction),
            request_signature_algorithm: cdktf.stringToTerraform(this._requestSignatureAlgorithm),
            request_signature_scope: cdktf.stringToTerraform(this._requestSignatureScope),
            response_signature_algorithm: cdktf.stringToTerraform(this._responseSignatureAlgorithm),
            response_signature_scope: cdktf.stringToTerraform(this._responseSignatureScope),
            sso_binding: cdktf.stringToTerraform(this._ssoBinding),
            sso_destination: cdktf.stringToTerraform(this._ssoDestination),
            sso_url: cdktf.stringToTerraform(this._ssoUrl),
            status: cdktf.stringToTerraform(this._status),
            subject_filter: cdktf.stringToTerraform(this._subjectFilter),
            subject_format: cdktf.listMapper(cdktf.stringToTerraform, false)(this._subjectFormat),
            subject_match_attribute: cdktf.stringToTerraform(this._subjectMatchAttribute),
            subject_match_type: cdktf.stringToTerraform(this._subjectMatchType),
            suspended_action: cdktf.stringToTerraform(this._suspendedAction),
            username_template: cdktf.stringToTerraform(this._usernameTemplate),
        };
    }
}
exports.IdpSaml = IdpSaml;
_a = JSII_RTTI_SYMBOL_1;
IdpSaml[_a] = { fqn: "@cdktf/provider-okta.IdpSaml", version: "2.0.46" };
// =================
// STATIC PROPERTIES
// =================
IdpSaml.tfResourceType = "okta_idp_saml";
//# sourceMappingURL=data:application/json;base64,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