import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdpSocialConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#account_link_action IdpSocial#account_link_action}
    */
    readonly accountLinkAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#account_link_group_include IdpSocial#account_link_group_include}
    */
    readonly accountLinkGroupInclude?: string[];
    /**
    * The Key ID that you obtained from Apple when you created the private key for the client
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#apple_kid IdpSocial#apple_kid}
    */
    readonly appleKid?: string;
    /**
    * The PKCS #8 encoded private key that you created for the client and downloaded from Apple
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#apple_private_key IdpSocial#apple_private_key}
    */
    readonly applePrivateKey?: string;
    /**
    * The Team ID associated with your Apple developer account
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#apple_team_id IdpSocial#apple_team_id}
    */
    readonly appleTeamId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#client_id IdpSocial#client_id}
    */
    readonly clientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#client_secret IdpSocial#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#deprovisioned_action IdpSocial#deprovisioned_action}
    */
    readonly deprovisionedAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#groups_action IdpSocial#groups_action}
    */
    readonly groupsAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#groups_assignment IdpSocial#groups_assignment}
    */
    readonly groupsAssignment?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#groups_attribute IdpSocial#groups_attribute}
    */
    readonly groupsAttribute?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#groups_filter IdpSocial#groups_filter}
    */
    readonly groupsFilter?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#id IdpSocial#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#issuer_mode IdpSocial#issuer_mode}
    */
    readonly issuerMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#match_attribute IdpSocial#match_attribute}
    */
    readonly matchAttribute?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#match_type IdpSocial#match_type}
    */
    readonly matchType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#max_clock_skew IdpSocial#max_clock_skew}
    */
    readonly maxClockSkew?: number;
    /**
    * Name of the IdP
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#name IdpSocial#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#profile_master IdpSocial#profile_master}
    */
    readonly profileMaster?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#protocol_type IdpSocial#protocol_type}
    */
    readonly protocolType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#provisioning_action IdpSocial#provisioning_action}
    */
    readonly provisioningAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#scopes IdpSocial#scopes}
    */
    readonly scopes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#status IdpSocial#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#subject_match_attribute IdpSocial#subject_match_attribute}
    */
    readonly subjectMatchAttribute?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#subject_match_type IdpSocial#subject_match_type}
    */
    readonly subjectMatchType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#suspended_action IdpSocial#suspended_action}
    */
    readonly suspendedAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#type IdpSocial#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_social#username_template IdpSocial#username_template}
    */
    readonly usernameTemplate?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/idp_social okta_idp_social}
*/
export declare class IdpSocial extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_idp_social";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/idp_social okta_idp_social} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdpSocialConfig
    */
    constructor(scope: Construct, id: string, config: IdpSocialConfig);
    private _accountLinkAction?;
    get accountLinkAction(): string;
    set accountLinkAction(value: string);
    resetAccountLinkAction(): void;
    get accountLinkActionInput(): string | undefined;
    private _accountLinkGroupInclude?;
    get accountLinkGroupInclude(): string[];
    set accountLinkGroupInclude(value: string[]);
    resetAccountLinkGroupInclude(): void;
    get accountLinkGroupIncludeInput(): string[] | undefined;
    private _appleKid?;
    get appleKid(): string;
    set appleKid(value: string);
    resetAppleKid(): void;
    get appleKidInput(): string | undefined;
    private _applePrivateKey?;
    get applePrivateKey(): string;
    set applePrivateKey(value: string);
    resetApplePrivateKey(): void;
    get applePrivateKeyInput(): string | undefined;
    private _appleTeamId?;
    get appleTeamId(): string;
    set appleTeamId(value: string);
    resetAppleTeamId(): void;
    get appleTeamIdInput(): string | undefined;
    get authorizationBinding(): string;
    get authorizationUrl(): string;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _deprovisionedAction?;
    get deprovisionedAction(): string;
    set deprovisionedAction(value: string);
    resetDeprovisionedAction(): void;
    get deprovisionedActionInput(): string | undefined;
    private _groupsAction?;
    get groupsAction(): string;
    set groupsAction(value: string);
    resetGroupsAction(): void;
    get groupsActionInput(): string | undefined;
    private _groupsAssignment?;
    get groupsAssignment(): string[];
    set groupsAssignment(value: string[]);
    resetGroupsAssignment(): void;
    get groupsAssignmentInput(): string[] | undefined;
    private _groupsAttribute?;
    get groupsAttribute(): string;
    set groupsAttribute(value: string);
    resetGroupsAttribute(): void;
    get groupsAttributeInput(): string | undefined;
    private _groupsFilter?;
    get groupsFilter(): string[];
    set groupsFilter(value: string[]);
    resetGroupsFilter(): void;
    get groupsFilterInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _issuerMode?;
    get issuerMode(): string;
    set issuerMode(value: string);
    resetIssuerMode(): void;
    get issuerModeInput(): string | undefined;
    private _matchAttribute?;
    get matchAttribute(): string;
    set matchAttribute(value: string);
    resetMatchAttribute(): void;
    get matchAttributeInput(): string | undefined;
    private _matchType?;
    get matchType(): string;
    set matchType(value: string);
    resetMatchType(): void;
    get matchTypeInput(): string | undefined;
    private _maxClockSkew?;
    get maxClockSkew(): number;
    set maxClockSkew(value: number);
    resetMaxClockSkew(): void;
    get maxClockSkewInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _profileMaster?;
    get profileMaster(): boolean | cdktf.IResolvable;
    set profileMaster(value: boolean | cdktf.IResolvable);
    resetProfileMaster(): void;
    get profileMasterInput(): boolean | cdktf.IResolvable | undefined;
    private _protocolType?;
    get protocolType(): string;
    set protocolType(value: string);
    resetProtocolType(): void;
    get protocolTypeInput(): string | undefined;
    private _provisioningAction?;
    get provisioningAction(): string;
    set provisioningAction(value: string);
    resetProvisioningAction(): void;
    get provisioningActionInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _subjectMatchAttribute?;
    get subjectMatchAttribute(): string;
    set subjectMatchAttribute(value: string);
    resetSubjectMatchAttribute(): void;
    get subjectMatchAttributeInput(): string | undefined;
    private _subjectMatchType?;
    get subjectMatchType(): string;
    set subjectMatchType(value: string);
    resetSubjectMatchType(): void;
    get subjectMatchTypeInput(): string | undefined;
    private _suspendedAction?;
    get suspendedAction(): string;
    set suspendedAction(value: string);
    resetSuspendedAction(): void;
    get suspendedActionInput(): string | undefined;
    get tokenBinding(): string;
    get tokenUrl(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
