import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LinkDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the associated relationship.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/link_definition#associated_description LinkDefinition#associated_description}
    */
    readonly associatedDescription: string;
    /**
    * API name of the associated link.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/link_definition#associated_name LinkDefinition#associated_name}
    */
    readonly associatedName: string;
    /**
    * Display name of the associated link.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/link_definition#associated_title LinkDefinition#associated_title}
    */
    readonly associatedTitle: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/link_definition#id LinkDefinition#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Description of the primary relationship.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/link_definition#primary_description LinkDefinition#primary_description}
    */
    readonly primaryDescription: string;
    /**
    * API name of the primary link.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/link_definition#primary_name LinkDefinition#primary_name}
    */
    readonly primaryName: string;
    /**
    * Display name of the primary link.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/link_definition#primary_title LinkDefinition#primary_title}
    */
    readonly primaryTitle: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/link_definition okta_link_definition}
*/
export declare class LinkDefinition extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_link_definition";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/link_definition okta_link_definition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LinkDefinitionConfig
    */
    constructor(scope: Construct, id: string, config: LinkDefinitionConfig);
    private _associatedDescription?;
    get associatedDescription(): string;
    set associatedDescription(value: string);
    get associatedDescriptionInput(): string | undefined;
    private _associatedName?;
    get associatedName(): string;
    set associatedName(value: string);
    get associatedNameInput(): string | undefined;
    private _associatedTitle?;
    get associatedTitle(): string;
    set associatedTitle(value: string);
    get associatedTitleInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _primaryDescription?;
    get primaryDescription(): string;
    set primaryDescription(value: string);
    get primaryDescriptionInput(): string | undefined;
    private _primaryName?;
    get primaryName(): string;
    set primaryName(value: string);
    get primaryNameInput(): string | undefined;
    private _primaryTitle?;
    get primaryTitle(): string;
    set primaryTitle(value: string);
    get primaryTitleInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
