import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LinkValueConfig extends cdktf.TerraformMetaArguments {
    /**
    * Set of User IDs or login values of the users to be assigned the 'associated' relationship.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/link_value#associated_user_ids LinkValue#associated_user_ids}
    */
    readonly associatedUserIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/link_value#id LinkValue#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the 'primary' relationship being assigned.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/link_value#primary_name LinkValue#primary_name}
    */
    readonly primaryName: string;
    /**
    * User ID to be assigned to 'primary' for the 'associated' user in the specified relationship.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/link_value#primary_user_id LinkValue#primary_user_id}
    */
    readonly primaryUserId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/link_value okta_link_value}
*/
export declare class LinkValue extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_link_value";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/link_value okta_link_value} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LinkValueConfig
    */
    constructor(scope: Construct, id: string, config: LinkValueConfig);
    private _associatedUserIds?;
    get associatedUserIds(): string[];
    set associatedUserIds(value: string[]);
    resetAssociatedUserIds(): void;
    get associatedUserIdsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _primaryName?;
    get primaryName(): string;
    set primaryName(value: string);
    get primaryNameInput(): string | undefined;
    private _primaryUserId?;
    get primaryUserId(): string;
    set primaryUserId(value: string);
    get primaryUserIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
