import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MfaPolicyRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Should the user be enrolled the first time they LOGIN, the next time they are CHALLENGED, or NEVER?
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule#enroll MfaPolicyRule#enroll}
    */
    readonly enroll?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule#id MfaPolicyRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Policy Rule Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule#name MfaPolicyRule#name}
    */
    readonly name: string;
    /**
    * Network selection mode: ANYWHERE, ZONE, ON_NETWORK, or OFF_NETWORK.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule#network_connection MfaPolicyRule#network_connection}
    */
    readonly networkConnection?: string;
    /**
    * The zones to exclude
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule#network_excludes MfaPolicyRule#network_excludes}
    */
    readonly networkExcludes?: string[];
    /**
    * The zones to include
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule#network_includes MfaPolicyRule#network_includes}
    */
    readonly networkIncludes?: string[];
    /**
    * Policy ID of the Rule
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule#policy_id MfaPolicyRule#policy_id}
    */
    readonly policyId?: string;
    /**
    * Policy ID of the Rule
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule#policyid MfaPolicyRule#policyid}
    */
    readonly policyid?: string;
    /**
    * Policy Rule Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule#priority MfaPolicyRule#priority}
    */
    readonly priority?: number;
    /**
    * Policy Rule Status: ACTIVE or INACTIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule#status MfaPolicyRule#status}
    */
    readonly status?: string;
    /**
    * Set of User IDs to Exclude
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule#users_excluded MfaPolicyRule#users_excluded}
    */
    readonly usersExcluded?: string[];
    /**
    * app_exclude block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule#app_exclude MfaPolicyRule#app_exclude}
    */
    readonly appExclude?: MfaPolicyRuleAppExclude[] | cdktf.IResolvable;
    /**
    * app_include block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule#app_include MfaPolicyRule#app_include}
    */
    readonly appInclude?: MfaPolicyRuleAppInclude[] | cdktf.IResolvable;
}
export interface MfaPolicyRuleAppExclude {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule#id MfaPolicyRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule#name MfaPolicyRule#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule#type MfaPolicyRule#type}
    */
    readonly type: string;
}
export declare function mfaPolicyRuleAppExcludeToTerraform(struct?: MfaPolicyRuleAppExclude | cdktf.IResolvable): any;
export declare class MfaPolicyRuleAppExcludeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MfaPolicyRuleAppExclude | cdktf.IResolvable | undefined;
    set internalValue(value: MfaPolicyRuleAppExclude | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class MfaPolicyRuleAppExcludeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MfaPolicyRuleAppExclude[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MfaPolicyRuleAppExcludeOutputReference;
}
export interface MfaPolicyRuleAppInclude {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule#id MfaPolicyRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule#name MfaPolicyRule#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule#type MfaPolicyRule#type}
    */
    readonly type: string;
}
export declare function mfaPolicyRuleAppIncludeToTerraform(struct?: MfaPolicyRuleAppInclude | cdktf.IResolvable): any;
export declare class MfaPolicyRuleAppIncludeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MfaPolicyRuleAppInclude | cdktf.IResolvable | undefined;
    set internalValue(value: MfaPolicyRuleAppInclude | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class MfaPolicyRuleAppIncludeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MfaPolicyRuleAppInclude[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MfaPolicyRuleAppIncludeOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule okta_mfa_policy_rule}
*/
export declare class MfaPolicyRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_mfa_policy_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule okta_mfa_policy_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MfaPolicyRuleConfig
    */
    constructor(scope: Construct, id: string, config: MfaPolicyRuleConfig);
    private _enroll?;
    get enroll(): string;
    set enroll(value: string);
    resetEnroll(): void;
    get enrollInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkConnection?;
    get networkConnection(): string;
    set networkConnection(value: string);
    resetNetworkConnection(): void;
    get networkConnectionInput(): string | undefined;
    private _networkExcludes?;
    get networkExcludes(): string[];
    set networkExcludes(value: string[]);
    resetNetworkExcludes(): void;
    get networkExcludesInput(): string[] | undefined;
    private _networkIncludes?;
    get networkIncludes(): string[];
    set networkIncludes(value: string[]);
    resetNetworkIncludes(): void;
    get networkIncludesInput(): string[] | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    resetPolicyId(): void;
    get policyIdInput(): string | undefined;
    private _policyid?;
    get policyid(): string;
    set policyid(value: string);
    resetPolicyid(): void;
    get policyidInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _usersExcluded?;
    get usersExcluded(): string[];
    set usersExcluded(value: string[]);
    resetUsersExcluded(): void;
    get usersExcludedInput(): string[] | undefined;
    private _appExclude;
    get appExclude(): MfaPolicyRuleAppExcludeList;
    putAppExclude(value: MfaPolicyRuleAppExclude[] | cdktf.IResolvable): void;
    resetAppExclude(): void;
    get appExcludeInput(): cdktf.IResolvable | MfaPolicyRuleAppExclude[] | undefined;
    private _appInclude;
    get appInclude(): MfaPolicyRuleAppIncludeList;
    putAppInclude(value: MfaPolicyRuleAppInclude[] | cdktf.IResolvable): void;
    resetAppInclude(): void;
    get appIncludeInput(): cdktf.IResolvable | MfaPolicyRuleAppInclude[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
