import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MfaPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Policy Description
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#description MfaPolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#duo MfaPolicy#duo}
    */
    readonly duo?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#external_idp MfaPolicy#external_idp}
    */
    readonly externalIdp?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#fido_u2f MfaPolicy#fido_u2f}
    */
    readonly fidoU2F?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#fido_webauthn MfaPolicy#fido_webauthn}
    */
    readonly fidoWebauthn?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#google_otp MfaPolicy#google_otp}
    */
    readonly googleOtp?: {
        [key: string]: string;
    };
    /**
    * List of Group IDs to Include
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#groups_included MfaPolicy#groups_included}
    */
    readonly groupsIncluded?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#hotp MfaPolicy#hotp}
    */
    readonly hotp?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#id MfaPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Is the policy using Okta Identity Engine (OIE) with authenticators instead of factors?
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#is_oie MfaPolicy#is_oie}
    */
    readonly isOie?: boolean | cdktf.IResolvable;
    /**
    * Policy Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#name MfaPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#okta_call MfaPolicy#okta_call}
    */
    readonly oktaCall?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#okta_email MfaPolicy#okta_email}
    */
    readonly oktaEmail?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#okta_otp MfaPolicy#okta_otp}
    */
    readonly oktaOtp?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#okta_password MfaPolicy#okta_password}
    */
    readonly oktaPassword?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#okta_push MfaPolicy#okta_push}
    */
    readonly oktaPush?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#okta_question MfaPolicy#okta_question}
    */
    readonly oktaQuestion?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#okta_sms MfaPolicy#okta_sms}
    */
    readonly oktaSms?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#okta_verify MfaPolicy#okta_verify}
    */
    readonly oktaVerify?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#onprem_mfa MfaPolicy#onprem_mfa}
    */
    readonly onpremMfa?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#phone_number MfaPolicy#phone_number}
    */
    readonly phoneNumber?: {
        [key: string]: string;
    };
    /**
    * Policy Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#priority MfaPolicy#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#rsa_token MfaPolicy#rsa_token}
    */
    readonly rsaToken?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#security_question MfaPolicy#security_question}
    */
    readonly securityQuestion?: {
        [key: string]: string;
    };
    /**
    * Policy Status: ACTIVE or INACTIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#status MfaPolicy#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#symantec_vip MfaPolicy#symantec_vip}
    */
    readonly symantecVip?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#webauthn MfaPolicy#webauthn}
    */
    readonly webauthn?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy#yubikey_token MfaPolicy#yubikey_token}
    */
    readonly yubikeyToken?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy okta_mfa_policy}
*/
export declare class MfaPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_mfa_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy okta_mfa_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MfaPolicyConfig
    */
    constructor(scope: Construct, id: string, config: MfaPolicyConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _duo?;
    get duo(): {
        [key: string]: string;
    };
    set duo(value: {
        [key: string]: string;
    });
    resetDuo(): void;
    get duoInput(): {
        [key: string]: string;
    } | undefined;
    private _externalIdp?;
    get externalIdp(): {
        [key: string]: string;
    };
    set externalIdp(value: {
        [key: string]: string;
    });
    resetExternalIdp(): void;
    get externalIdpInput(): {
        [key: string]: string;
    } | undefined;
    private _fidoU2F?;
    get fidoU2F(): {
        [key: string]: string;
    };
    set fidoU2F(value: {
        [key: string]: string;
    });
    resetFidoU2F(): void;
    get fidoU2FInput(): {
        [key: string]: string;
    } | undefined;
    private _fidoWebauthn?;
    get fidoWebauthn(): {
        [key: string]: string;
    };
    set fidoWebauthn(value: {
        [key: string]: string;
    });
    resetFidoWebauthn(): void;
    get fidoWebauthnInput(): {
        [key: string]: string;
    } | undefined;
    private _googleOtp?;
    get googleOtp(): {
        [key: string]: string;
    };
    set googleOtp(value: {
        [key: string]: string;
    });
    resetGoogleOtp(): void;
    get googleOtpInput(): {
        [key: string]: string;
    } | undefined;
    private _groupsIncluded?;
    get groupsIncluded(): string[];
    set groupsIncluded(value: string[]);
    resetGroupsIncluded(): void;
    get groupsIncludedInput(): string[] | undefined;
    private _hotp?;
    get hotp(): {
        [key: string]: string;
    };
    set hotp(value: {
        [key: string]: string;
    });
    resetHotp(): void;
    get hotpInput(): {
        [key: string]: string;
    } | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isOie?;
    get isOie(): boolean | cdktf.IResolvable;
    set isOie(value: boolean | cdktf.IResolvable);
    resetIsOie(): void;
    get isOieInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _oktaCall?;
    get oktaCall(): {
        [key: string]: string;
    };
    set oktaCall(value: {
        [key: string]: string;
    });
    resetOktaCall(): void;
    get oktaCallInput(): {
        [key: string]: string;
    } | undefined;
    private _oktaEmail?;
    get oktaEmail(): {
        [key: string]: string;
    };
    set oktaEmail(value: {
        [key: string]: string;
    });
    resetOktaEmail(): void;
    get oktaEmailInput(): {
        [key: string]: string;
    } | undefined;
    private _oktaOtp?;
    get oktaOtp(): {
        [key: string]: string;
    };
    set oktaOtp(value: {
        [key: string]: string;
    });
    resetOktaOtp(): void;
    get oktaOtpInput(): {
        [key: string]: string;
    } | undefined;
    private _oktaPassword?;
    get oktaPassword(): {
        [key: string]: string;
    };
    set oktaPassword(value: {
        [key: string]: string;
    });
    resetOktaPassword(): void;
    get oktaPasswordInput(): {
        [key: string]: string;
    } | undefined;
    private _oktaPush?;
    get oktaPush(): {
        [key: string]: string;
    };
    set oktaPush(value: {
        [key: string]: string;
    });
    resetOktaPush(): void;
    get oktaPushInput(): {
        [key: string]: string;
    } | undefined;
    private _oktaQuestion?;
    get oktaQuestion(): {
        [key: string]: string;
    };
    set oktaQuestion(value: {
        [key: string]: string;
    });
    resetOktaQuestion(): void;
    get oktaQuestionInput(): {
        [key: string]: string;
    } | undefined;
    private _oktaSms?;
    get oktaSms(): {
        [key: string]: string;
    };
    set oktaSms(value: {
        [key: string]: string;
    });
    resetOktaSms(): void;
    get oktaSmsInput(): {
        [key: string]: string;
    } | undefined;
    private _oktaVerify?;
    get oktaVerify(): {
        [key: string]: string;
    };
    set oktaVerify(value: {
        [key: string]: string;
    });
    resetOktaVerify(): void;
    get oktaVerifyInput(): {
        [key: string]: string;
    } | undefined;
    private _onpremMfa?;
    get onpremMfa(): {
        [key: string]: string;
    };
    set onpremMfa(value: {
        [key: string]: string;
    });
    resetOnpremMfa(): void;
    get onpremMfaInput(): {
        [key: string]: string;
    } | undefined;
    private _phoneNumber?;
    get phoneNumber(): {
        [key: string]: string;
    };
    set phoneNumber(value: {
        [key: string]: string;
    });
    resetPhoneNumber(): void;
    get phoneNumberInput(): {
        [key: string]: string;
    } | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _rsaToken?;
    get rsaToken(): {
        [key: string]: string;
    };
    set rsaToken(value: {
        [key: string]: string;
    });
    resetRsaToken(): void;
    get rsaTokenInput(): {
        [key: string]: string;
    } | undefined;
    private _securityQuestion?;
    get securityQuestion(): {
        [key: string]: string;
    };
    set securityQuestion(value: {
        [key: string]: string;
    });
    resetSecurityQuestion(): void;
    get securityQuestionInput(): {
        [key: string]: string;
    } | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _symantecVip?;
    get symantecVip(): {
        [key: string]: string;
    };
    set symantecVip(value: {
        [key: string]: string;
    });
    resetSymantecVip(): void;
    get symantecVipInput(): {
        [key: string]: string;
    } | undefined;
    private _webauthn?;
    get webauthn(): {
        [key: string]: string;
    };
    set webauthn(value: {
        [key: string]: string;
    });
    resetWebauthn(): void;
    get webauthnInput(): {
        [key: string]: string;
    } | undefined;
    private _yubikeyToken?;
    get yubikeyToken(): {
        [key: string]: string;
    };
    set yubikeyToken(value: {
        [key: string]: string;
    });
    resetYubikeyToken(): void;
    get yubikeyTokenInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
