import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkZoneConfig extends cdktf.TerraformMetaArguments {
    /**
    * Format of each array value: a string representation of an ASN numeric value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/network_zone#asns NetworkZone#asns}
    */
    readonly asns?: string[];
    /**
    * Array of locations ISO-3166-1(2). Format code: countryCode OR countryCode-regionCode
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/network_zone#dynamic_locations NetworkZone#dynamic_locations}
    */
    readonly dynamicLocations?: string[];
    /**
    * Type of proxy being controlled by this network zone
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/network_zone#dynamic_proxy_type NetworkZone#dynamic_proxy_type}
    */
    readonly dynamicProxyType?: string;
    /**
    * Array of values in CIDR/range form depending on the way it's been declared (i.e. CIDR will contain /suffix). Please check API docs for examples
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/network_zone#gateways NetworkZone#gateways}
    */
    readonly gateways?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/network_zone#id NetworkZone#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the Network Zone Resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/network_zone#name NetworkZone#name}
    */
    readonly name: string;
    /**
    * Array of values in CIDR/range form depending on the way it's been declared (i.e. CIDR will contain /suffix). Please check API docs for examples
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/network_zone#proxies NetworkZone#proxies}
    */
    readonly proxies?: string[];
    /**
    * Type of the Network Zone - can either be IP or DYNAMIC only
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/network_zone#type NetworkZone#type}
    */
    readonly type: string;
    /**
    * Zone's purpose: POLICY or BLOCKLIST
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/network_zone#usage NetworkZone#usage}
    */
    readonly usage?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/network_zone okta_network_zone}
*/
export declare class NetworkZone extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_network_zone";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/network_zone okta_network_zone} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkZoneConfig
    */
    constructor(scope: Construct, id: string, config: NetworkZoneConfig);
    private _asns?;
    get asns(): string[];
    set asns(value: string[]);
    resetAsns(): void;
    get asnsInput(): string[] | undefined;
    private _dynamicLocations?;
    get dynamicLocations(): string[];
    set dynamicLocations(value: string[]);
    resetDynamicLocations(): void;
    get dynamicLocationsInput(): string[] | undefined;
    private _dynamicProxyType?;
    get dynamicProxyType(): string;
    set dynamicProxyType(value: string);
    resetDynamicProxyType(): void;
    get dynamicProxyTypeInput(): string | undefined;
    private _gateways?;
    get gateways(): string[];
    set gateways(value: string[]);
    resetGateways(): void;
    get gatewaysInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _proxies?;
    get proxies(): string[];
    set proxies(value: string[]);
    resetProxies(): void;
    get proxiesInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _usage?;
    get usage(): string;
    set usage(value: string);
    resetUsage(): void;
    get usageInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
