import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OauthAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Custom error page URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#accessibility_error_redirect_url OauthApp#accessibility_error_redirect_url}
    */
    readonly accessibilityErrorRedirectUrl?: string;
    /**
    * Custom login page URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#accessibility_login_redirect_url OauthApp#accessibility_login_redirect_url}
    */
    readonly accessibilityLoginRedirectUrl?: string;
    /**
    * Enable self service
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#accessibility_self_service OauthApp#accessibility_self_service}
    */
    readonly accessibilitySelfService?: boolean | cdktf.IResolvable;
    /**
    * Application notes for admins.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#admin_note OauthApp#admin_note}
    */
    readonly adminNote?: string;
    /**
    * Displays specific appLinks for the app
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#app_links_json OauthApp#app_links_json}
    */
    readonly appLinksJson?: string;
    /**
    * Application settings in JSON format
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#app_settings_json OauthApp#app_settings_json}
    */
    readonly appSettingsJson?: string;
    /**
    * Id of this apps authentication policy
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#authentication_policy OauthApp#authentication_policy}
    */
    readonly authenticationPolicy?: string;
    /**
    * Requested key rotation mode.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#auto_key_rotation OauthApp#auto_key_rotation}
    */
    readonly autoKeyRotation?: boolean | cdktf.IResolvable;
    /**
    * Display auto submit toolbar
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#auto_submit_toolbar OauthApp#auto_submit_toolbar}
    */
    readonly autoSubmitToolbar?: boolean | cdktf.IResolvable;
    /**
    * OAuth client secret key, this can be set when token_endpoint_auth_method is client_secret_basic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#client_basic_secret OauthApp#client_basic_secret}
    */
    readonly clientBasicSecret?: string;
    /**
    * OAuth client ID. If set during creation, app is created with this id.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#client_id OauthApp#client_id}
    */
    readonly clientId?: string;
    /**
    * URI to a web page providing information about the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#client_uri OauthApp#client_uri}
    */
    readonly clientUri?: string;
    /**
    * *Early Access Property*. Indicates whether user consent is required or implicit. Valid values: REQUIRED, TRUSTED. Default value is TRUSTED
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#consent_method OauthApp#consent_method}
    */
    readonly consentMethod?: string;
    /**
    * **Deprecated** This property allows you to set your client_id during creation. NOTE: updating after creation will be a no-op, use client_id for that behavior instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#custom_client_id OauthApp#custom_client_id}
    */
    readonly customClientId?: string;
    /**
    * Application notes for end users.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#enduser_note OauthApp#enduser_note}
    */
    readonly enduserNote?: string;
    /**
    * List of OAuth 2.0 grant types. Conditional validation params found here https://developer.okta.com/docs/api/resources/apps#credentials-settings-details. Defaults to minimum requirements per app type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#grant_types OauthApp#grant_types}
    */
    readonly grantTypes?: string[];
    /**
    * Groups associated with the application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#groups OauthApp#groups}
    */
    readonly groups?: string[];
    /**
    * Do not display application icon on mobile app
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#hide_ios OauthApp#hide_ios}
    */
    readonly hideIos?: boolean | cdktf.IResolvable;
    /**
    * Do not display application icon to users
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#hide_web OauthApp#hide_web}
    */
    readonly hideWeb?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#id OauthApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * *Early Access Property*. Enable Federation Broker Mode.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#implicit_assignment OauthApp#implicit_assignment}
    */
    readonly implicitAssignment?: boolean | cdktf.IResolvable;
    /**
    * *Early Access Property*. Indicates whether the Okta Authorization Server uses the original Okta org domain URL or a custom domain URL as the issuer of ID token for this client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#issuer_mode OauthApp#issuer_mode}
    */
    readonly issuerMode?: string;
    /**
    * Pretty name of app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#label OauthApp#label}
    */
    readonly label: string;
    /**
    * The type of Idp-Initiated login that the client supports, if any
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#login_mode OauthApp#login_mode}
    */
    readonly loginMode?: string;
    /**
    * List of scopes to use for the request
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#login_scopes OauthApp#login_scopes}
    */
    readonly loginScopes?: string[];
    /**
    * URI that initiates login.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#login_uri OauthApp#login_uri}
    */
    readonly loginUri?: string;
    /**
    * Local path to logo of the application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#logo OauthApp#logo}
    */
    readonly logo?: string;
    /**
    * URI that references a logo for the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#logo_uri OauthApp#logo_uri}
    */
    readonly logoUri?: string;
    /**
    * This tells the provider not to persist the application's secret to state. If this is ever changes from true => false your app will be recreated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#omit_secret OauthApp#omit_secret}
    */
    readonly omitSecret?: boolean | cdktf.IResolvable;
    /**
    * URI to web page providing client policy document.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#policy_uri OauthApp#policy_uri}
    */
    readonly policyUri?: string;
    /**
    * List of URIs for redirection after logout. Note: see okta_app_oauth_post_logout_redirect_uri for appending to this list in a decentralized way.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#post_logout_redirect_uris OauthApp#post_logout_redirect_uris}
    */
    readonly postLogoutRedirectUris?: string[];
    /**
    * Custom JSON that represents an OAuth application's profile
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#profile OauthApp#profile}
    */
    readonly profile?: string;
    /**
    * List of URIs for use in the redirect-based flow. This is required for all application types except service. Note: see okta_app_oauth_redirect_uri for appending to this list in a decentralized way.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#redirect_uris OauthApp#redirect_uris}
    */
    readonly redirectUris?: string[];
    /**
    * *Early Access Property* Grace period for token rotation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#refresh_token_leeway OauthApp#refresh_token_leeway}
    */
    readonly refreshTokenLeeway?: number;
    /**
    * *Early Access Property* Refresh token rotation behavior
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#refresh_token_rotation OauthApp#refresh_token_rotation}
    */
    readonly refreshTokenRotation?: string;
    /**
    * List of OAuth 2.0 response type strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#response_types OauthApp#response_types}
    */
    readonly responseTypes?: string[];
    /**
    * Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#skip_groups OauthApp#skip_groups}
    */
    readonly skipGroups?: boolean | cdktf.IResolvable;
    /**
    * Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#skip_users OauthApp#skip_users}
    */
    readonly skipUsers?: boolean | cdktf.IResolvable;
    /**
    * Status of application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#status OauthApp#status}
    */
    readonly status?: string;
    /**
    * Requested authentication method for the token endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#token_endpoint_auth_method OauthApp#token_endpoint_auth_method}
    */
    readonly tokenEndpointAuthMethod?: string;
    /**
    * URI to web page providing client tos (terms of service).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#tos_uri OauthApp#tos_uri}
    */
    readonly tosUri?: string;
    /**
    * The type of client application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#type OauthApp#type}
    */
    readonly type: string;
    /**
    * Username template
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#user_name_template OauthApp#user_name_template}
    */
    readonly userNameTemplate?: string;
    /**
    * Push username on update
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#user_name_template_push_status OauthApp#user_name_template_push_status}
    */
    readonly userNameTemplatePushStatus?: string;
    /**
    * Username template suffix
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#user_name_template_suffix OauthApp#user_name_template_suffix}
    */
    readonly userNameTemplateSuffix?: string;
    /**
    * Username template type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#user_name_template_type OauthApp#user_name_template_type}
    */
    readonly userNameTemplateType?: string;
    /**
    * *Early Access Property*. Indicates if the client is allowed to use wildcard matching of redirect_uris
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#wildcard_redirect OauthApp#wildcard_redirect}
    */
    readonly wildcardRedirect?: string;
    /**
    * groups_claim block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#groups_claim OauthApp#groups_claim}
    */
    readonly groupsClaim?: OauthAppGroupsClaim;
    /**
    * jwks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#jwks OauthApp#jwks}
    */
    readonly jwks?: OauthAppJwks[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#timeouts OauthApp#timeouts}
    */
    readonly timeouts?: OauthAppTimeouts;
    /**
    * users block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#users OauthApp#users}
    */
    readonly users?: OauthAppUsers[] | cdktf.IResolvable;
}
export interface OauthAppGroupsClaim {
    /**
    * Groups claim filter. Can only be set if type is FILTER.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#filter_type OauthApp#filter_type}
    */
    readonly filterType?: string;
    /**
    * Name of the claim that will be used in the token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#name OauthApp#name}
    */
    readonly name: string;
    /**
    * Groups claim type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#type OauthApp#type}
    */
    readonly type: string;
    /**
    * Value of the claim. Can be an Okta Expression Language statement that evaluates at the time the token is minted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#value OauthApp#value}
    */
    readonly value: string;
}
export declare function oauthAppGroupsClaimToTerraform(struct?: OauthAppGroupsClaimOutputReference | OauthAppGroupsClaim): any;
export declare class OauthAppGroupsClaimOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OauthAppGroupsClaim | undefined;
    set internalValue(value: OauthAppGroupsClaim | undefined);
    private _filterType?;
    get filterType(): string;
    set filterType(value: string);
    resetFilterType(): void;
    get filterTypeInput(): string | undefined;
    get issuerMode(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export interface OauthAppJwks {
    /**
    * RSA Exponent
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#e OauthApp#e}
    */
    readonly e?: string;
    /**
    * Key ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#kid OauthApp#kid}
    */
    readonly kid: string;
    /**
    * Key type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#kty OauthApp#kty}
    */
    readonly kty: string;
    /**
    * RSA Modulus
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#n OauthApp#n}
    */
    readonly n?: string;
}
export declare function oauthAppJwksToTerraform(struct?: OauthAppJwks | cdktf.IResolvable): any;
export declare class OauthAppJwksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthAppJwks | cdktf.IResolvable | undefined;
    set internalValue(value: OauthAppJwks | cdktf.IResolvable | undefined);
    private _e?;
    get e(): string;
    set e(value: string);
    resetE(): void;
    get eInput(): string | undefined;
    private _kid?;
    get kid(): string;
    set kid(value: string);
    get kidInput(): string | undefined;
    private _kty?;
    get kty(): string;
    set kty(value: string);
    get ktyInput(): string | undefined;
    private _n?;
    get n(): string;
    set n(value: string);
    resetN(): void;
    get nInput(): string | undefined;
}
export declare class OauthAppJwksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OauthAppJwks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthAppJwksOutputReference;
}
export interface OauthAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#create OauthApp#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#read OauthApp#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#update OauthApp#update}
    */
    readonly update?: string;
}
export declare function oauthAppTimeoutsToTerraform(struct?: OauthAppTimeoutsOutputReference | OauthAppTimeouts | cdktf.IResolvable): any;
export declare class OauthAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OauthAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: OauthAppTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface OauthAppUsers {
    /**
    * User ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#id OauthApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Password for user application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#password OauthApp#password}
    */
    readonly password?: string;
    /**
    * Username for user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app#username OauthApp#username}
    */
    readonly username?: string;
}
export declare function oauthAppUsersToTerraform(struct?: OauthAppUsers | cdktf.IResolvable): any;
export declare class OauthAppUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthAppUsers | cdktf.IResolvable | undefined;
    set internalValue(value: OauthAppUsers | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    get scope(): string;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export declare class OauthAppUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OauthAppUsers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthAppUsersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/oauth_app okta_oauth_app}
*/
export declare class OauthApp extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_oauth_app";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/oauth_app okta_oauth_app} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OauthAppConfig
    */
    constructor(scope: Construct, id: string, config: OauthAppConfig);
    private _accessibilityErrorRedirectUrl?;
    get accessibilityErrorRedirectUrl(): string;
    set accessibilityErrorRedirectUrl(value: string);
    resetAccessibilityErrorRedirectUrl(): void;
    get accessibilityErrorRedirectUrlInput(): string | undefined;
    private _accessibilityLoginRedirectUrl?;
    get accessibilityLoginRedirectUrl(): string;
    set accessibilityLoginRedirectUrl(value: string);
    resetAccessibilityLoginRedirectUrl(): void;
    get accessibilityLoginRedirectUrlInput(): string | undefined;
    private _accessibilitySelfService?;
    get accessibilitySelfService(): boolean | cdktf.IResolvable;
    set accessibilitySelfService(value: boolean | cdktf.IResolvable);
    resetAccessibilitySelfService(): void;
    get accessibilitySelfServiceInput(): boolean | cdktf.IResolvable | undefined;
    private _adminNote?;
    get adminNote(): string;
    set adminNote(value: string);
    resetAdminNote(): void;
    get adminNoteInput(): string | undefined;
    private _appLinksJson?;
    get appLinksJson(): string;
    set appLinksJson(value: string);
    resetAppLinksJson(): void;
    get appLinksJsonInput(): string | undefined;
    private _appSettingsJson?;
    get appSettingsJson(): string;
    set appSettingsJson(value: string);
    resetAppSettingsJson(): void;
    get appSettingsJsonInput(): string | undefined;
    private _authenticationPolicy?;
    get authenticationPolicy(): string;
    set authenticationPolicy(value: string);
    resetAuthenticationPolicy(): void;
    get authenticationPolicyInput(): string | undefined;
    private _autoKeyRotation?;
    get autoKeyRotation(): boolean | cdktf.IResolvable;
    set autoKeyRotation(value: boolean | cdktf.IResolvable);
    resetAutoKeyRotation(): void;
    get autoKeyRotationInput(): boolean | cdktf.IResolvable | undefined;
    private _autoSubmitToolbar?;
    get autoSubmitToolbar(): boolean | cdktf.IResolvable;
    set autoSubmitToolbar(value: boolean | cdktf.IResolvable);
    resetAutoSubmitToolbar(): void;
    get autoSubmitToolbarInput(): boolean | cdktf.IResolvable | undefined;
    private _clientBasicSecret?;
    get clientBasicSecret(): string;
    set clientBasicSecret(value: string);
    resetClientBasicSecret(): void;
    get clientBasicSecretInput(): string | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    get clientSecret(): string;
    private _clientUri?;
    get clientUri(): string;
    set clientUri(value: string);
    resetClientUri(): void;
    get clientUriInput(): string | undefined;
    private _consentMethod?;
    get consentMethod(): string;
    set consentMethod(value: string);
    resetConsentMethod(): void;
    get consentMethodInput(): string | undefined;
    private _customClientId?;
    get customClientId(): string;
    set customClientId(value: string);
    resetCustomClientId(): void;
    get customClientIdInput(): string | undefined;
    private _enduserNote?;
    get enduserNote(): string;
    set enduserNote(value: string);
    resetEnduserNote(): void;
    get enduserNoteInput(): string | undefined;
    private _grantTypes?;
    get grantTypes(): string[];
    set grantTypes(value: string[]);
    resetGrantTypes(): void;
    get grantTypesInput(): string[] | undefined;
    private _groups?;
    get groups(): string[];
    set groups(value: string[]);
    resetGroups(): void;
    get groupsInput(): string[] | undefined;
    private _hideIos?;
    get hideIos(): boolean | cdktf.IResolvable;
    set hideIos(value: boolean | cdktf.IResolvable);
    resetHideIos(): void;
    get hideIosInput(): boolean | cdktf.IResolvable | undefined;
    private _hideWeb?;
    get hideWeb(): boolean | cdktf.IResolvable;
    set hideWeb(value: boolean | cdktf.IResolvable);
    resetHideWeb(): void;
    get hideWebInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _implicitAssignment?;
    get implicitAssignment(): boolean | cdktf.IResolvable;
    set implicitAssignment(value: boolean | cdktf.IResolvable);
    resetImplicitAssignment(): void;
    get implicitAssignmentInput(): boolean | cdktf.IResolvable | undefined;
    private _issuerMode?;
    get issuerMode(): string;
    set issuerMode(value: string);
    resetIssuerMode(): void;
    get issuerModeInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    get labelInput(): string | undefined;
    private _loginMode?;
    get loginMode(): string;
    set loginMode(value: string);
    resetLoginMode(): void;
    get loginModeInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
    private _loginUri?;
    get loginUri(): string;
    set loginUri(value: string);
    resetLoginUri(): void;
    get loginUriInput(): string | undefined;
    private _logo?;
    get logo(): string;
    set logo(value: string);
    resetLogo(): void;
    get logoInput(): string | undefined;
    private _logoUri?;
    get logoUri(): string;
    set logoUri(value: string);
    resetLogoUri(): void;
    get logoUriInput(): string | undefined;
    get logoUrl(): string;
    get name(): string;
    private _omitSecret?;
    get omitSecret(): boolean | cdktf.IResolvable;
    set omitSecret(value: boolean | cdktf.IResolvable);
    resetOmitSecret(): void;
    get omitSecretInput(): boolean | cdktf.IResolvable | undefined;
    private _policyUri?;
    get policyUri(): string;
    set policyUri(value: string);
    resetPolicyUri(): void;
    get policyUriInput(): string | undefined;
    private _postLogoutRedirectUris?;
    get postLogoutRedirectUris(): string[];
    set postLogoutRedirectUris(value: string[]);
    resetPostLogoutRedirectUris(): void;
    get postLogoutRedirectUrisInput(): string[] | undefined;
    private _profile?;
    get profile(): string;
    set profile(value: string);
    resetProfile(): void;
    get profileInput(): string | undefined;
    private _redirectUris?;
    get redirectUris(): string[];
    set redirectUris(value: string[]);
    resetRedirectUris(): void;
    get redirectUrisInput(): string[] | undefined;
    private _refreshTokenLeeway?;
    get refreshTokenLeeway(): number;
    set refreshTokenLeeway(value: number);
    resetRefreshTokenLeeway(): void;
    get refreshTokenLeewayInput(): number | undefined;
    private _refreshTokenRotation?;
    get refreshTokenRotation(): string;
    set refreshTokenRotation(value: string);
    resetRefreshTokenRotation(): void;
    get refreshTokenRotationInput(): string | undefined;
    private _responseTypes?;
    get responseTypes(): string[];
    set responseTypes(value: string[]);
    resetResponseTypes(): void;
    get responseTypesInput(): string[] | undefined;
    get signOnMode(): string;
    private _skipGroups?;
    get skipGroups(): boolean | cdktf.IResolvable;
    set skipGroups(value: boolean | cdktf.IResolvable);
    resetSkipGroups(): void;
    get skipGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _skipUsers?;
    get skipUsers(): boolean | cdktf.IResolvable;
    set skipUsers(value: boolean | cdktf.IResolvable);
    resetSkipUsers(): void;
    get skipUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _tokenEndpointAuthMethod?;
    get tokenEndpointAuthMethod(): string;
    set tokenEndpointAuthMethod(value: string);
    resetTokenEndpointAuthMethod(): void;
    get tokenEndpointAuthMethodInput(): string | undefined;
    private _tosUri?;
    get tosUri(): string;
    set tosUri(value: string);
    resetTosUri(): void;
    get tosUriInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _userNameTemplate?;
    get userNameTemplate(): string;
    set userNameTemplate(value: string);
    resetUserNameTemplate(): void;
    get userNameTemplateInput(): string | undefined;
    private _userNameTemplatePushStatus?;
    get userNameTemplatePushStatus(): string;
    set userNameTemplatePushStatus(value: string);
    resetUserNameTemplatePushStatus(): void;
    get userNameTemplatePushStatusInput(): string | undefined;
    private _userNameTemplateSuffix?;
    get userNameTemplateSuffix(): string;
    set userNameTemplateSuffix(value: string);
    resetUserNameTemplateSuffix(): void;
    get userNameTemplateSuffixInput(): string | undefined;
    private _userNameTemplateType?;
    get userNameTemplateType(): string;
    set userNameTemplateType(value: string);
    resetUserNameTemplateType(): void;
    get userNameTemplateTypeInput(): string | undefined;
    private _wildcardRedirect?;
    get wildcardRedirect(): string;
    set wildcardRedirect(value: string);
    resetWildcardRedirect(): void;
    get wildcardRedirectInput(): string | undefined;
    private _groupsClaim;
    get groupsClaim(): OauthAppGroupsClaimOutputReference;
    putGroupsClaim(value: OauthAppGroupsClaim): void;
    resetGroupsClaim(): void;
    get groupsClaimInput(): OauthAppGroupsClaim | undefined;
    private _jwks;
    get jwks(): OauthAppJwksList;
    putJwks(value: OauthAppJwks[] | cdktf.IResolvable): void;
    resetJwks(): void;
    get jwksInput(): cdktf.IResolvable | OauthAppJwks[] | undefined;
    private _timeouts;
    get timeouts(): OauthAppTimeoutsOutputReference;
    putTimeouts(value: OauthAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | OauthAppTimeouts | undefined;
    private _users;
    get users(): OauthAppUsersList;
    putUsers(value: OauthAppUsers[] | cdktf.IResolvable): void;
    resetUsers(): void;
    get usersInput(): cdktf.IResolvable | OauthAppUsers[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
