import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OktaProviderConfig {
    /**
    * Bearer token granting privileges to Okta API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#access_token OktaProvider#access_token}
    */
    readonly accessToken?: string;
    /**
    * API Token granting privileges to Okta API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#api_token OktaProvider#api_token}
    */
    readonly apiToken?: string;
    /**
    * Use exponential back off strategy for rate limits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#backoff OktaProvider#backoff}
    */
    readonly backoff?: boolean | cdktf.IResolvable;
    /**
    * The Okta url. (Use 'oktapreview.com' for Okta testing)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#base_url OktaProvider#base_url}
    */
    readonly baseUrl?: string;
    /**
    * API Token granting privileges to Okta API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#client_id OktaProvider#client_id}
    */
    readonly clientId?: string;
    /**
    * Alternate HTTP proxy of scheme://hostname or scheme://hostname:port format
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#http_proxy OktaProvider#http_proxy}
    */
    readonly httpProxy?: string;
    /**
    * providers log level. Minimum is 1 (TRACE), and maximum is 5 (ERROR)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#log_level OktaProvider#log_level}
    */
    readonly logLevel?: number;
    /**
    * (Experimental) sets what percentage of capacity the provider can use of the total rate limit capacity while making calls to the Okta management API endpoints. Okta API operates in one minute buckets. See Okta Management API Rate Limits: https://developer.okta.com/docs/reference/rl-global-mgmt/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#max_api_capacity OktaProvider#max_api_capacity}
    */
    readonly maxApiCapacity?: number;
    /**
    * maximum number of retries to attempt before erroring out.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#max_retries OktaProvider#max_retries}
    */
    readonly maxRetries?: number;
    /**
    * maximum seconds to wait when rate limit is hit. We use exponential backoffs when backoff is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#max_wait_seconds OktaProvider#max_wait_seconds}
    */
    readonly maxWaitSeconds?: number;
    /**
    * minimum seconds to wait when rate limit is hit. We use exponential backoffs when backoff is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#min_wait_seconds OktaProvider#min_wait_seconds}
    */
    readonly minWaitSeconds?: number;
    /**
    * The organization to manage in Okta.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#org_name OktaProvider#org_name}
    */
    readonly orgName?: string;
    /**
    * Number of concurrent requests to make within a resource where bulk operations are not possible. Take note of https://developer.okta.com/docs/api/getting_started/rate-limits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#parallelism OktaProvider#parallelism}
    */
    readonly parallelism?: number;
    /**
    * API Token granting privileges to Okta API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#private_key OktaProvider#private_key}
    */
    readonly privateKey?: string;
    /**
    * API Token Id granting privileges to Okta API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#private_key_id OktaProvider#private_key_id}
    */
    readonly privateKeyId?: string;
    /**
    * Timeout for single request (in seconds) which is made to Okta, the default is `0` (means no limit is set). The maximum value can be `300`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#request_timeout OktaProvider#request_timeout}
    */
    readonly requestTimeout?: number;
    /**
    * API Token granting privileges to Okta API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#scopes OktaProvider#scopes}
    */
    readonly scopes?: string[];
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#alias OktaProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta okta}
*/
export declare class OktaProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "okta";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta okta} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OktaProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: OktaProviderConfig);
    private _accessToken?;
    get accessToken(): string | undefined;
    set accessToken(value: string | undefined);
    resetAccessToken(): void;
    get accessTokenInput(): string | undefined;
    private _apiToken?;
    get apiToken(): string | undefined;
    set apiToken(value: string | undefined);
    resetApiToken(): void;
    get apiTokenInput(): string | undefined;
    private _backoff?;
    get backoff(): boolean | cdktf.IResolvable | undefined;
    set backoff(value: boolean | cdktf.IResolvable | undefined);
    resetBackoff(): void;
    get backoffInput(): boolean | cdktf.IResolvable | undefined;
    private _baseUrl?;
    get baseUrl(): string | undefined;
    set baseUrl(value: string | undefined);
    resetBaseUrl(): void;
    get baseUrlInput(): string | undefined;
    private _clientId?;
    get clientId(): string | undefined;
    set clientId(value: string | undefined);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _httpProxy?;
    get httpProxy(): string | undefined;
    set httpProxy(value: string | undefined);
    resetHttpProxy(): void;
    get httpProxyInput(): string | undefined;
    private _logLevel?;
    get logLevel(): number | undefined;
    set logLevel(value: number | undefined);
    resetLogLevel(): void;
    get logLevelInput(): number | undefined;
    private _maxApiCapacity?;
    get maxApiCapacity(): number | undefined;
    set maxApiCapacity(value: number | undefined);
    resetMaxApiCapacity(): void;
    get maxApiCapacityInput(): number | undefined;
    private _maxRetries?;
    get maxRetries(): number | undefined;
    set maxRetries(value: number | undefined);
    resetMaxRetries(): void;
    get maxRetriesInput(): number | undefined;
    private _maxWaitSeconds?;
    get maxWaitSeconds(): number | undefined;
    set maxWaitSeconds(value: number | undefined);
    resetMaxWaitSeconds(): void;
    get maxWaitSecondsInput(): number | undefined;
    private _minWaitSeconds?;
    get minWaitSeconds(): number | undefined;
    set minWaitSeconds(value: number | undefined);
    resetMinWaitSeconds(): void;
    get minWaitSecondsInput(): number | undefined;
    private _orgName?;
    get orgName(): string | undefined;
    set orgName(value: string | undefined);
    resetOrgName(): void;
    get orgNameInput(): string | undefined;
    private _parallelism?;
    get parallelism(): number | undefined;
    set parallelism(value: number | undefined);
    resetParallelism(): void;
    get parallelismInput(): number | undefined;
    private _privateKey?;
    get privateKey(): string | undefined;
    set privateKey(value: string | undefined);
    resetPrivateKey(): void;
    get privateKeyInput(): string | undefined;
    private _privateKeyId?;
    get privateKeyId(): string | undefined;
    set privateKeyId(value: string | undefined);
    resetPrivateKeyId(): void;
    get privateKeyIdInput(): string | undefined;
    private _requestTimeout?;
    get requestTimeout(): number | undefined;
    set requestTimeout(value: number | undefined);
    resetRequestTimeout(): void;
    get requestTimeoutInput(): number | undefined;
    private _scopes?;
    get scopes(): string[] | undefined;
    set scopes(value: string[] | undefined);
    resetScopes(): void;
    get scopesInput(): string[] | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
