import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrgConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Primary address of org
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration#address_1 OrgConfiguration#address_1}
    */
    readonly address1?: string;
    /**
    * Secondary address of org
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration#address_2 OrgConfiguration#address_2}
    */
    readonly address2?: string;
    /**
    * User ID representing the billing contact
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration#billing_contact_user OrgConfiguration#billing_contact_user}
    */
    readonly billingContactUser?: string;
    /**
    * City of org
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration#city OrgConfiguration#city}
    */
    readonly city?: string;
    /**
    * Name of org
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration#company_name OrgConfiguration#company_name}
    */
    readonly companyName: string;
    /**
    * Country of org
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration#country OrgConfiguration#country}
    */
    readonly country?: string;
    /**
    * Support link of org
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration#end_user_support_help_url OrgConfiguration#end_user_support_help_url}
    */
    readonly endUserSupportHelpUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration#id OrgConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Local path to logo of the org.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration#logo OrgConfiguration#logo}
    */
    readonly logo?: string;
    /**
    * Indicates whether the org's users receive Okta Communication emails
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration#opt_out_communication_emails OrgConfiguration#opt_out_communication_emails}
    */
    readonly optOutCommunicationEmails?: boolean | cdktf.IResolvable;
    /**
    * Support help phone of org
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration#phone_number OrgConfiguration#phone_number}
    */
    readonly phoneNumber?: string;
    /**
    * Postal code of org
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration#postal_code OrgConfiguration#postal_code}
    */
    readonly postalCode?: string;
    /**
    * State of org
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration#state OrgConfiguration#state}
    */
    readonly state?: string;
    /**
    * Support help phone of org
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration#support_phone_number OrgConfiguration#support_phone_number}
    */
    readonly supportPhoneNumber?: string;
    /**
    * User ID representing the technical contact
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration#technical_contact_user OrgConfiguration#technical_contact_user}
    */
    readonly technicalContactUser?: string;
    /**
    * The org's website
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration#website OrgConfiguration#website}
    */
    readonly website?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/org_configuration okta_org_configuration}
*/
export declare class OrgConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_org_configuration";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/org_configuration okta_org_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OrgConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: OrgConfigurationConfig);
    private _address1?;
    get address1(): string;
    set address1(value: string);
    resetAddress1(): void;
    get address1Input(): string | undefined;
    private _address2?;
    get address2(): string;
    set address2(value: string);
    resetAddress2(): void;
    get address2Input(): string | undefined;
    private _billingContactUser?;
    get billingContactUser(): string;
    set billingContactUser(value: string);
    resetBillingContactUser(): void;
    get billingContactUserInput(): string | undefined;
    private _city?;
    get city(): string;
    set city(value: string);
    resetCity(): void;
    get cityInput(): string | undefined;
    private _companyName?;
    get companyName(): string;
    set companyName(value: string);
    get companyNameInput(): string | undefined;
    private _country?;
    get country(): string;
    set country(value: string);
    resetCountry(): void;
    get countryInput(): string | undefined;
    private _endUserSupportHelpUrl?;
    get endUserSupportHelpUrl(): string;
    set endUserSupportHelpUrl(value: string);
    resetEndUserSupportHelpUrl(): void;
    get endUserSupportHelpUrlInput(): string | undefined;
    get expiresAt(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logo?;
    get logo(): string;
    set logo(value: string);
    resetLogo(): void;
    get logoInput(): string | undefined;
    private _optOutCommunicationEmails?;
    get optOutCommunicationEmails(): boolean | cdktf.IResolvable;
    set optOutCommunicationEmails(value: boolean | cdktf.IResolvable);
    resetOptOutCommunicationEmails(): void;
    get optOutCommunicationEmailsInput(): boolean | cdktf.IResolvable | undefined;
    private _phoneNumber?;
    get phoneNumber(): string;
    set phoneNumber(value: string);
    resetPhoneNumber(): void;
    get phoneNumberInput(): string | undefined;
    private _postalCode?;
    get postalCode(): string;
    set postalCode(value: string);
    resetPostalCode(): void;
    get postalCodeInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    get subdomain(): string;
    private _supportPhoneNumber?;
    get supportPhoneNumber(): string;
    set supportPhoneNumber(value: string);
    resetSupportPhoneNumber(): void;
    get supportPhoneNumberInput(): string | undefined;
    private _technicalContactUser?;
    get technicalContactUser(): string;
    set technicalContactUser(value: string);
    resetTechnicalContactUser(): void;
    get technicalContactUserInput(): string | undefined;
    private _website?;
    get website(): string;
    set website(value: string);
    resetWebsite(): void;
    get websiteInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
