"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrgConfiguration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/org_configuration okta_org_configuration}
*/
class OrgConfiguration extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/org_configuration okta_org_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OrgConfigurationConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'okta_org_configuration',
            terraformGeneratorMetadata: {
                providerName: 'okta',
                providerVersion: '3.35.0',
                providerVersionConstraint: '~> 3.20'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._address1 = config.address1;
        this._address2 = config.address2;
        this._billingContactUser = config.billingContactUser;
        this._city = config.city;
        this._companyName = config.companyName;
        this._country = config.country;
        this._endUserSupportHelpUrl = config.endUserSupportHelpUrl;
        this._id = config.id;
        this._logo = config.logo;
        this._optOutCommunicationEmails = config.optOutCommunicationEmails;
        this._phoneNumber = config.phoneNumber;
        this._postalCode = config.postalCode;
        this._state = config.state;
        this._supportPhoneNumber = config.supportPhoneNumber;
        this._technicalContactUser = config.technicalContactUser;
        this._website = config.website;
    }
    get address1() {
        return this.getStringAttribute('address_1');
    }
    set address1(value) {
        this._address1 = value;
    }
    resetAddress1() {
        this._address1 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get address1Input() {
        return this._address1;
    }
    get address2() {
        return this.getStringAttribute('address_2');
    }
    set address2(value) {
        this._address2 = value;
    }
    resetAddress2() {
        this._address2 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get address2Input() {
        return this._address2;
    }
    get billingContactUser() {
        return this.getStringAttribute('billing_contact_user');
    }
    set billingContactUser(value) {
        this._billingContactUser = value;
    }
    resetBillingContactUser() {
        this._billingContactUser = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get billingContactUserInput() {
        return this._billingContactUser;
    }
    get city() {
        return this.getStringAttribute('city');
    }
    set city(value) {
        this._city = value;
    }
    resetCity() {
        this._city = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cityInput() {
        return this._city;
    }
    get companyName() {
        return this.getStringAttribute('company_name');
    }
    set companyName(value) {
        this._companyName = value;
    }
    // Temporarily expose input value. Use with caution.
    get companyNameInput() {
        return this._companyName;
    }
    get country() {
        return this.getStringAttribute('country');
    }
    set country(value) {
        this._country = value;
    }
    resetCountry() {
        this._country = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get countryInput() {
        return this._country;
    }
    get endUserSupportHelpUrl() {
        return this.getStringAttribute('end_user_support_help_url');
    }
    set endUserSupportHelpUrl(value) {
        this._endUserSupportHelpUrl = value;
    }
    resetEndUserSupportHelpUrl() {
        this._endUserSupportHelpUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get endUserSupportHelpUrlInput() {
        return this._endUserSupportHelpUrl;
    }
    // expires_at - computed: true, optional: false, required: false
    get expiresAt() {
        return this.getStringAttribute('expires_at');
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get logo() {
        return this.getStringAttribute('logo');
    }
    set logo(value) {
        this._logo = value;
    }
    resetLogo() {
        this._logo = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get logoInput() {
        return this._logo;
    }
    get optOutCommunicationEmails() {
        return this.getBooleanAttribute('opt_out_communication_emails');
    }
    set optOutCommunicationEmails(value) {
        this._optOutCommunicationEmails = value;
    }
    resetOptOutCommunicationEmails() {
        this._optOutCommunicationEmails = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get optOutCommunicationEmailsInput() {
        return this._optOutCommunicationEmails;
    }
    get phoneNumber() {
        return this.getStringAttribute('phone_number');
    }
    set phoneNumber(value) {
        this._phoneNumber = value;
    }
    resetPhoneNumber() {
        this._phoneNumber = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get phoneNumberInput() {
        return this._phoneNumber;
    }
    get postalCode() {
        return this.getStringAttribute('postal_code');
    }
    set postalCode(value) {
        this._postalCode = value;
    }
    resetPostalCode() {
        this._postalCode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get postalCodeInput() {
        return this._postalCode;
    }
    get state() {
        return this.getStringAttribute('state');
    }
    set state(value) {
        this._state = value;
    }
    resetState() {
        this._state = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get stateInput() {
        return this._state;
    }
    // subdomain - computed: true, optional: false, required: false
    get subdomain() {
        return this.getStringAttribute('subdomain');
    }
    get supportPhoneNumber() {
        return this.getStringAttribute('support_phone_number');
    }
    set supportPhoneNumber(value) {
        this._supportPhoneNumber = value;
    }
    resetSupportPhoneNumber() {
        this._supportPhoneNumber = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get supportPhoneNumberInput() {
        return this._supportPhoneNumber;
    }
    get technicalContactUser() {
        return this.getStringAttribute('technical_contact_user');
    }
    set technicalContactUser(value) {
        this._technicalContactUser = value;
    }
    resetTechnicalContactUser() {
        this._technicalContactUser = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get technicalContactUserInput() {
        return this._technicalContactUser;
    }
    get website() {
        return this.getStringAttribute('website');
    }
    set website(value) {
        this._website = value;
    }
    resetWebsite() {
        this._website = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get websiteInput() {
        return this._website;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            address_1: cdktf.stringToTerraform(this._address1),
            address_2: cdktf.stringToTerraform(this._address2),
            billing_contact_user: cdktf.stringToTerraform(this._billingContactUser),
            city: cdktf.stringToTerraform(this._city),
            company_name: cdktf.stringToTerraform(this._companyName),
            country: cdktf.stringToTerraform(this._country),
            end_user_support_help_url: cdktf.stringToTerraform(this._endUserSupportHelpUrl),
            id: cdktf.stringToTerraform(this._id),
            logo: cdktf.stringToTerraform(this._logo),
            opt_out_communication_emails: cdktf.booleanToTerraform(this._optOutCommunicationEmails),
            phone_number: cdktf.stringToTerraform(this._phoneNumber),
            postal_code: cdktf.stringToTerraform(this._postalCode),
            state: cdktf.stringToTerraform(this._state),
            support_phone_number: cdktf.stringToTerraform(this._supportPhoneNumber),
            technical_contact_user: cdktf.stringToTerraform(this._technicalContactUser),
            website: cdktf.stringToTerraform(this._website),
        };
    }
}
exports.OrgConfiguration = OrgConfiguration;
_a = JSII_RTTI_SYMBOL_1;
OrgConfiguration[_a] = { fqn: "@cdktf/provider-okta.OrgConfiguration", version: "2.0.46" };
// =================
// STATIC PROPERTIES
// =================
OrgConfiguration.tfResourceType = "okta_org_configuration";
//# sourceMappingURL=data:application/json;base64,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