import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrgSupportConfig extends cdktf.TerraformMetaArguments {
    /**
    * Number of days the support should be extended by
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_support#extend_by OrgSupport#extend_by}
    */
    readonly extendBy?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_support#id OrgSupport#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/org_support okta_org_support}
*/
export declare class OrgSupport extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_org_support";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/org_support okta_org_support} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OrgSupportConfig = {}
    */
    constructor(scope: Construct, id: string, config?: OrgSupportConfig);
    get expiration(): string;
    private _extendBy?;
    get extendBy(): number;
    set extendBy(value: number);
    resetExtendBy(): void;
    get extendByInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get status(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
