import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PolicyMfaDefaultConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#duo PolicyMfaDefault#duo}
    */
    readonly duo?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#external_idp PolicyMfaDefault#external_idp}
    */
    readonly externalIdp?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#fido_u2f PolicyMfaDefault#fido_u2f}
    */
    readonly fidoU2F?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#fido_webauthn PolicyMfaDefault#fido_webauthn}
    */
    readonly fidoWebauthn?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#google_otp PolicyMfaDefault#google_otp}
    */
    readonly googleOtp?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#hotp PolicyMfaDefault#hotp}
    */
    readonly hotp?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#id PolicyMfaDefault#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Is the policy using Okta Identity Engine (OIE) with authenticators instead of factors?
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#is_oie PolicyMfaDefault#is_oie}
    */
    readonly isOie?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#okta_call PolicyMfaDefault#okta_call}
    */
    readonly oktaCall?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#okta_email PolicyMfaDefault#okta_email}
    */
    readonly oktaEmail?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#okta_otp PolicyMfaDefault#okta_otp}
    */
    readonly oktaOtp?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#okta_password PolicyMfaDefault#okta_password}
    */
    readonly oktaPassword?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#okta_push PolicyMfaDefault#okta_push}
    */
    readonly oktaPush?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#okta_question PolicyMfaDefault#okta_question}
    */
    readonly oktaQuestion?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#okta_sms PolicyMfaDefault#okta_sms}
    */
    readonly oktaSms?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#okta_verify PolicyMfaDefault#okta_verify}
    */
    readonly oktaVerify?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#onprem_mfa PolicyMfaDefault#onprem_mfa}
    */
    readonly onpremMfa?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#phone_number PolicyMfaDefault#phone_number}
    */
    readonly phoneNumber?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#rsa_token PolicyMfaDefault#rsa_token}
    */
    readonly rsaToken?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#security_question PolicyMfaDefault#security_question}
    */
    readonly securityQuestion?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#symantec_vip PolicyMfaDefault#symantec_vip}
    */
    readonly symantecVip?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#webauthn PolicyMfaDefault#webauthn}
    */
    readonly webauthn?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default#yubikey_token PolicyMfaDefault#yubikey_token}
    */
    readonly yubikeyToken?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default okta_policy_mfa_default}
*/
export declare class PolicyMfaDefault extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_policy_mfa_default";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default okta_policy_mfa_default} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PolicyMfaDefaultConfig = {}
    */
    constructor(scope: Construct, id: string, config?: PolicyMfaDefaultConfig);
    get defaultIncludedGroupId(): string;
    get description(): string;
    private _duo?;
    get duo(): {
        [key: string]: string;
    };
    set duo(value: {
        [key: string]: string;
    });
    resetDuo(): void;
    get duoInput(): {
        [key: string]: string;
    } | undefined;
    private _externalIdp?;
    get externalIdp(): {
        [key: string]: string;
    };
    set externalIdp(value: {
        [key: string]: string;
    });
    resetExternalIdp(): void;
    get externalIdpInput(): {
        [key: string]: string;
    } | undefined;
    private _fidoU2F?;
    get fidoU2F(): {
        [key: string]: string;
    };
    set fidoU2F(value: {
        [key: string]: string;
    });
    resetFidoU2F(): void;
    get fidoU2FInput(): {
        [key: string]: string;
    } | undefined;
    private _fidoWebauthn?;
    get fidoWebauthn(): {
        [key: string]: string;
    };
    set fidoWebauthn(value: {
        [key: string]: string;
    });
    resetFidoWebauthn(): void;
    get fidoWebauthnInput(): {
        [key: string]: string;
    } | undefined;
    private _googleOtp?;
    get googleOtp(): {
        [key: string]: string;
    };
    set googleOtp(value: {
        [key: string]: string;
    });
    resetGoogleOtp(): void;
    get googleOtpInput(): {
        [key: string]: string;
    } | undefined;
    private _hotp?;
    get hotp(): {
        [key: string]: string;
    };
    set hotp(value: {
        [key: string]: string;
    });
    resetHotp(): void;
    get hotpInput(): {
        [key: string]: string;
    } | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isOie?;
    get isOie(): boolean | cdktf.IResolvable;
    set isOie(value: boolean | cdktf.IResolvable);
    resetIsOie(): void;
    get isOieInput(): boolean | cdktf.IResolvable | undefined;
    get name(): string;
    private _oktaCall?;
    get oktaCall(): {
        [key: string]: string;
    };
    set oktaCall(value: {
        [key: string]: string;
    });
    resetOktaCall(): void;
    get oktaCallInput(): {
        [key: string]: string;
    } | undefined;
    private _oktaEmail?;
    get oktaEmail(): {
        [key: string]: string;
    };
    set oktaEmail(value: {
        [key: string]: string;
    });
    resetOktaEmail(): void;
    get oktaEmailInput(): {
        [key: string]: string;
    } | undefined;
    private _oktaOtp?;
    get oktaOtp(): {
        [key: string]: string;
    };
    set oktaOtp(value: {
        [key: string]: string;
    });
    resetOktaOtp(): void;
    get oktaOtpInput(): {
        [key: string]: string;
    } | undefined;
    private _oktaPassword?;
    get oktaPassword(): {
        [key: string]: string;
    };
    set oktaPassword(value: {
        [key: string]: string;
    });
    resetOktaPassword(): void;
    get oktaPasswordInput(): {
        [key: string]: string;
    } | undefined;
    private _oktaPush?;
    get oktaPush(): {
        [key: string]: string;
    };
    set oktaPush(value: {
        [key: string]: string;
    });
    resetOktaPush(): void;
    get oktaPushInput(): {
        [key: string]: string;
    } | undefined;
    private _oktaQuestion?;
    get oktaQuestion(): {
        [key: string]: string;
    };
    set oktaQuestion(value: {
        [key: string]: string;
    });
    resetOktaQuestion(): void;
    get oktaQuestionInput(): {
        [key: string]: string;
    } | undefined;
    private _oktaSms?;
    get oktaSms(): {
        [key: string]: string;
    };
    set oktaSms(value: {
        [key: string]: string;
    });
    resetOktaSms(): void;
    get oktaSmsInput(): {
        [key: string]: string;
    } | undefined;
    private _oktaVerify?;
    get oktaVerify(): {
        [key: string]: string;
    };
    set oktaVerify(value: {
        [key: string]: string;
    });
    resetOktaVerify(): void;
    get oktaVerifyInput(): {
        [key: string]: string;
    } | undefined;
    private _onpremMfa?;
    get onpremMfa(): {
        [key: string]: string;
    };
    set onpremMfa(value: {
        [key: string]: string;
    });
    resetOnpremMfa(): void;
    get onpremMfaInput(): {
        [key: string]: string;
    } | undefined;
    private _phoneNumber?;
    get phoneNumber(): {
        [key: string]: string;
    };
    set phoneNumber(value: {
        [key: string]: string;
    });
    resetPhoneNumber(): void;
    get phoneNumberInput(): {
        [key: string]: string;
    } | undefined;
    get priority(): number;
    private _rsaToken?;
    get rsaToken(): {
        [key: string]: string;
    };
    set rsaToken(value: {
        [key: string]: string;
    });
    resetRsaToken(): void;
    get rsaTokenInput(): {
        [key: string]: string;
    } | undefined;
    private _securityQuestion?;
    get securityQuestion(): {
        [key: string]: string;
    };
    set securityQuestion(value: {
        [key: string]: string;
    });
    resetSecurityQuestion(): void;
    get securityQuestionInput(): {
        [key: string]: string;
    } | undefined;
    get status(): string;
    private _symantecVip?;
    get symantecVip(): {
        [key: string]: string;
    };
    set symantecVip(value: {
        [key: string]: string;
    });
    resetSymantecVip(): void;
    get symantecVipInput(): {
        [key: string]: string;
    } | undefined;
    private _webauthn?;
    get webauthn(): {
        [key: string]: string;
    };
    set webauthn(value: {
        [key: string]: string;
    });
    resetWebauthn(): void;
    get webauthnInput(): {
        [key: string]: string;
    } | undefined;
    private _yubikeyToken?;
    get yubikeyToken(): {
        [key: string]: string;
    };
    set yubikeyToken(value: {
        [key: string]: string;
    });
    resetYubikeyToken(): void;
    get yubikeyTokenInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
