"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyMfaDefault = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default okta_policy_mfa_default}
*/
class PolicyMfaDefault extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default okta_policy_mfa_default} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PolicyMfaDefaultConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'okta_policy_mfa_default',
            terraformGeneratorMetadata: {
                providerName: 'okta',
                providerVersion: '3.35.0',
                providerVersionConstraint: '~> 3.20'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._duo = config.duo;
        this._externalIdp = config.externalIdp;
        this._fidoU2F = config.fidoU2F;
        this._fidoWebauthn = config.fidoWebauthn;
        this._googleOtp = config.googleOtp;
        this._hotp = config.hotp;
        this._id = config.id;
        this._isOie = config.isOie;
        this._oktaCall = config.oktaCall;
        this._oktaEmail = config.oktaEmail;
        this._oktaOtp = config.oktaOtp;
        this._oktaPassword = config.oktaPassword;
        this._oktaPush = config.oktaPush;
        this._oktaQuestion = config.oktaQuestion;
        this._oktaSms = config.oktaSms;
        this._oktaVerify = config.oktaVerify;
        this._onpremMfa = config.onpremMfa;
        this._phoneNumber = config.phoneNumber;
        this._rsaToken = config.rsaToken;
        this._securityQuestion = config.securityQuestion;
        this._symantecVip = config.symantecVip;
        this._webauthn = config.webauthn;
        this._yubikeyToken = config.yubikeyToken;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // default_included_group_id - computed: true, optional: false, required: false
    get defaultIncludedGroupId() {
        return this.getStringAttribute('default_included_group_id');
    }
    // description - computed: true, optional: false, required: false
    get description() {
        return this.getStringAttribute('description');
    }
    get duo() {
        return this.getStringMapAttribute('duo');
    }
    set duo(value) {
        this._duo = value;
    }
    resetDuo() {
        this._duo = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get duoInput() {
        return this._duo;
    }
    get externalIdp() {
        return this.getStringMapAttribute('external_idp');
    }
    set externalIdp(value) {
        this._externalIdp = value;
    }
    resetExternalIdp() {
        this._externalIdp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalIdpInput() {
        return this._externalIdp;
    }
    get fidoU2F() {
        return this.getStringMapAttribute('fido_u2f');
    }
    set fidoU2F(value) {
        this._fidoU2F = value;
    }
    resetFidoU2F() {
        this._fidoU2F = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fidoU2FInput() {
        return this._fidoU2F;
    }
    get fidoWebauthn() {
        return this.getStringMapAttribute('fido_webauthn');
    }
    set fidoWebauthn(value) {
        this._fidoWebauthn = value;
    }
    resetFidoWebauthn() {
        this._fidoWebauthn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fidoWebauthnInput() {
        return this._fidoWebauthn;
    }
    get googleOtp() {
        return this.getStringMapAttribute('google_otp');
    }
    set googleOtp(value) {
        this._googleOtp = value;
    }
    resetGoogleOtp() {
        this._googleOtp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get googleOtpInput() {
        return this._googleOtp;
    }
    get hotp() {
        return this.getStringMapAttribute('hotp');
    }
    set hotp(value) {
        this._hotp = value;
    }
    resetHotp() {
        this._hotp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hotpInput() {
        return this._hotp;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get isOie() {
        return this.getBooleanAttribute('is_oie');
    }
    set isOie(value) {
        this._isOie = value;
    }
    resetIsOie() {
        this._isOie = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get isOieInput() {
        return this._isOie;
    }
    // name - computed: true, optional: false, required: false
    get name() {
        return this.getStringAttribute('name');
    }
    get oktaCall() {
        return this.getStringMapAttribute('okta_call');
    }
    set oktaCall(value) {
        this._oktaCall = value;
    }
    resetOktaCall() {
        this._oktaCall = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oktaCallInput() {
        return this._oktaCall;
    }
    get oktaEmail() {
        return this.getStringMapAttribute('okta_email');
    }
    set oktaEmail(value) {
        this._oktaEmail = value;
    }
    resetOktaEmail() {
        this._oktaEmail = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oktaEmailInput() {
        return this._oktaEmail;
    }
    get oktaOtp() {
        return this.getStringMapAttribute('okta_otp');
    }
    set oktaOtp(value) {
        this._oktaOtp = value;
    }
    resetOktaOtp() {
        this._oktaOtp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oktaOtpInput() {
        return this._oktaOtp;
    }
    get oktaPassword() {
        return this.getStringMapAttribute('okta_password');
    }
    set oktaPassword(value) {
        this._oktaPassword = value;
    }
    resetOktaPassword() {
        this._oktaPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oktaPasswordInput() {
        return this._oktaPassword;
    }
    get oktaPush() {
        return this.getStringMapAttribute('okta_push');
    }
    set oktaPush(value) {
        this._oktaPush = value;
    }
    resetOktaPush() {
        this._oktaPush = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oktaPushInput() {
        return this._oktaPush;
    }
    get oktaQuestion() {
        return this.getStringMapAttribute('okta_question');
    }
    set oktaQuestion(value) {
        this._oktaQuestion = value;
    }
    resetOktaQuestion() {
        this._oktaQuestion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oktaQuestionInput() {
        return this._oktaQuestion;
    }
    get oktaSms() {
        return this.getStringMapAttribute('okta_sms');
    }
    set oktaSms(value) {
        this._oktaSms = value;
    }
    resetOktaSms() {
        this._oktaSms = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oktaSmsInput() {
        return this._oktaSms;
    }
    get oktaVerify() {
        return this.getStringMapAttribute('okta_verify');
    }
    set oktaVerify(value) {
        this._oktaVerify = value;
    }
    resetOktaVerify() {
        this._oktaVerify = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oktaVerifyInput() {
        return this._oktaVerify;
    }
    get onpremMfa() {
        return this.getStringMapAttribute('onprem_mfa');
    }
    set onpremMfa(value) {
        this._onpremMfa = value;
    }
    resetOnpremMfa() {
        this._onpremMfa = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onpremMfaInput() {
        return this._onpremMfa;
    }
    get phoneNumber() {
        return this.getStringMapAttribute('phone_number');
    }
    set phoneNumber(value) {
        this._phoneNumber = value;
    }
    resetPhoneNumber() {
        this._phoneNumber = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get phoneNumberInput() {
        return this._phoneNumber;
    }
    // priority - computed: true, optional: false, required: false
    get priority() {
        return this.getNumberAttribute('priority');
    }
    get rsaToken() {
        return this.getStringMapAttribute('rsa_token');
    }
    set rsaToken(value) {
        this._rsaToken = value;
    }
    resetRsaToken() {
        this._rsaToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rsaTokenInput() {
        return this._rsaToken;
    }
    get securityQuestion() {
        return this.getStringMapAttribute('security_question');
    }
    set securityQuestion(value) {
        this._securityQuestion = value;
    }
    resetSecurityQuestion() {
        this._securityQuestion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get securityQuestionInput() {
        return this._securityQuestion;
    }
    // status - computed: true, optional: false, required: false
    get status() {
        return this.getStringAttribute('status');
    }
    get symantecVip() {
        return this.getStringMapAttribute('symantec_vip');
    }
    set symantecVip(value) {
        this._symantecVip = value;
    }
    resetSymantecVip() {
        this._symantecVip = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get symantecVipInput() {
        return this._symantecVip;
    }
    get webauthn() {
        return this.getStringMapAttribute('webauthn');
    }
    set webauthn(value) {
        this._webauthn = value;
    }
    resetWebauthn() {
        this._webauthn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get webauthnInput() {
        return this._webauthn;
    }
    get yubikeyToken() {
        return this.getStringMapAttribute('yubikey_token');
    }
    set yubikeyToken(value) {
        this._yubikeyToken = value;
    }
    resetYubikeyToken() {
        this._yubikeyToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get yubikeyTokenInput() {
        return this._yubikeyToken;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            duo: cdktf.hashMapper(cdktf.stringToTerraform)(this._duo),
            external_idp: cdktf.hashMapper(cdktf.stringToTerraform)(this._externalIdp),
            fido_u2f: cdktf.hashMapper(cdktf.stringToTerraform)(this._fidoU2F),
            fido_webauthn: cdktf.hashMapper(cdktf.stringToTerraform)(this._fidoWebauthn),
            google_otp: cdktf.hashMapper(cdktf.stringToTerraform)(this._googleOtp),
            hotp: cdktf.hashMapper(cdktf.stringToTerraform)(this._hotp),
            id: cdktf.stringToTerraform(this._id),
            is_oie: cdktf.booleanToTerraform(this._isOie),
            okta_call: cdktf.hashMapper(cdktf.stringToTerraform)(this._oktaCall),
            okta_email: cdktf.hashMapper(cdktf.stringToTerraform)(this._oktaEmail),
            okta_otp: cdktf.hashMapper(cdktf.stringToTerraform)(this._oktaOtp),
            okta_password: cdktf.hashMapper(cdktf.stringToTerraform)(this._oktaPassword),
            okta_push: cdktf.hashMapper(cdktf.stringToTerraform)(this._oktaPush),
            okta_question: cdktf.hashMapper(cdktf.stringToTerraform)(this._oktaQuestion),
            okta_sms: cdktf.hashMapper(cdktf.stringToTerraform)(this._oktaSms),
            okta_verify: cdktf.hashMapper(cdktf.stringToTerraform)(this._oktaVerify),
            onprem_mfa: cdktf.hashMapper(cdktf.stringToTerraform)(this._onpremMfa),
            phone_number: cdktf.hashMapper(cdktf.stringToTerraform)(this._phoneNumber),
            rsa_token: cdktf.hashMapper(cdktf.stringToTerraform)(this._rsaToken),
            security_question: cdktf.hashMapper(cdktf.stringToTerraform)(this._securityQuestion),
            symantec_vip: cdktf.hashMapper(cdktf.stringToTerraform)(this._symantecVip),
            webauthn: cdktf.hashMapper(cdktf.stringToTerraform)(this._webauthn),
            yubikey_token: cdktf.hashMapper(cdktf.stringToTerraform)(this._yubikeyToken),
        };
    }
}
exports.PolicyMfaDefault = PolicyMfaDefault;
_a = JSII_RTTI_SYMBOL_1;
PolicyMfaDefault[_a] = { fqn: "@cdktf/provider-okta.PolicyMfaDefault", version: "2.0.46" };
// =================
// STATIC PROPERTIES
// =================
PolicyMfaDefault.tfResourceType = "okta_policy_mfa_default";
//# sourceMappingURL=data:application/json;base64,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