import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PolicyPasswordDefaultConfig extends cdktf.TerraformMetaArguments {
    /**
    * Enable or disable voice call recovery: ACTIVE or INACTIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#call_recovery PolicyPasswordDefault#call_recovery}
    */
    readonly callRecovery?: string;
    /**
    * Enable or disable email password recovery: ACTIVE or INACTIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#email_recovery PolicyPasswordDefault#email_recovery}
    */
    readonly emailRecovery?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#id PolicyPasswordDefault#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Number of minutes before a locked account is unlocked: 0 = no limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#password_auto_unlock_minutes PolicyPasswordDefault#password_auto_unlock_minutes}
    */
    readonly passwordAutoUnlockMinutes?: number;
    /**
    * Check Passwords Against Common Password Dictionary.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#password_dictionary_lookup PolicyPasswordDefault#password_dictionary_lookup}
    */
    readonly passwordDictionaryLookup?: boolean | cdktf.IResolvable;
    /**
    * User firstName attribute must be excluded from the password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#password_exclude_first_name PolicyPasswordDefault#password_exclude_first_name}
    */
    readonly passwordExcludeFirstName?: boolean | cdktf.IResolvable;
    /**
    * User lastName attribute must be excluded from the password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#password_exclude_last_name PolicyPasswordDefault#password_exclude_last_name}
    */
    readonly passwordExcludeLastName?: boolean | cdktf.IResolvable;
    /**
    * If the user name must be excluded from the password.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#password_exclude_username PolicyPasswordDefault#password_exclude_username}
    */
    readonly passwordExcludeUsername?: boolean | cdktf.IResolvable;
    /**
    * Length in days a user will be warned before password expiry: 0 = no warning.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#password_expire_warn_days PolicyPasswordDefault#password_expire_warn_days}
    */
    readonly passwordExpireWarnDays?: number;
    /**
    * Number of distinct passwords that must be created before they can be reused: 0 = none.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#password_history_count PolicyPasswordDefault#password_history_count}
    */
    readonly passwordHistoryCount?: number;
    /**
    * Notification channels to use to notify a user when their account has been locked.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#password_lockout_notification_channels PolicyPasswordDefault#password_lockout_notification_channels}
    */
    readonly passwordLockoutNotificationChannels?: string[];
    /**
    * Length in days a password is valid before expiry: 0 = no limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#password_max_age_days PolicyPasswordDefault#password_max_age_days}
    */
    readonly passwordMaxAgeDays?: number;
    /**
    * Number of unsuccessful login attempts allowed before lockout: 0 = no limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#password_max_lockout_attempts PolicyPasswordDefault#password_max_lockout_attempts}
    */
    readonly passwordMaxLockoutAttempts?: number;
    /**
    * Minimum time interval in minutes between password changes: 0 = no limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#password_min_age_minutes PolicyPasswordDefault#password_min_age_minutes}
    */
    readonly passwordMinAgeMinutes?: number;
    /**
    * Minimum password length.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#password_min_length PolicyPasswordDefault#password_min_length}
    */
    readonly passwordMinLength?: number;
    /**
    * If a password must contain at least one lower case letter: 0 = no, 1 = yes. Default = 1
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#password_min_lowercase PolicyPasswordDefault#password_min_lowercase}
    */
    readonly passwordMinLowercase?: number;
    /**
    * If a password must contain at least one number: 0 = no, 1 = yes. Default = 1
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#password_min_number PolicyPasswordDefault#password_min_number}
    */
    readonly passwordMinNumber?: number;
    /**
    * If a password must contain at least one symbol (!@#$%^&*): 0 = no, 1 = yes. Default = 1
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#password_min_symbol PolicyPasswordDefault#password_min_symbol}
    */
    readonly passwordMinSymbol?: number;
    /**
    * If a password must contain at least one upper case letter: 0 = no, 1 = yes. Default = 1
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#password_min_uppercase PolicyPasswordDefault#password_min_uppercase}
    */
    readonly passwordMinUppercase?: number;
    /**
    * If a user should be informed when their account is locked.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#password_show_lockout_failures PolicyPasswordDefault#password_show_lockout_failures}
    */
    readonly passwordShowLockoutFailures?: boolean | cdktf.IResolvable;
    /**
    * Min length of the password recovery question answer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#question_min_length PolicyPasswordDefault#question_min_length}
    */
    readonly questionMinLength?: number;
    /**
    * Enable or disable security question password recovery: ACTIVE or INACTIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#question_recovery PolicyPasswordDefault#question_recovery}
    */
    readonly questionRecovery?: string;
    /**
    * Lifetime in minutes of the recovery email token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#recovery_email_token PolicyPasswordDefault#recovery_email_token}
    */
    readonly recoveryEmailToken?: number;
    /**
    * When an Active Directory user is locked out of Okta, the Okta unlock operation should also attempt to unlock the user's Windows account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#skip_unlock PolicyPasswordDefault#skip_unlock}
    */
    readonly skipUnlock?: boolean | cdktf.IResolvable;
    /**
    * Enable or disable SMS password recovery: ACTIVE or INACTIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default#sms_recovery PolicyPasswordDefault#sms_recovery}
    */
    readonly smsRecovery?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default okta_policy_password_default}
*/
export declare class PolicyPasswordDefault extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_policy_password_default";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default okta_policy_password_default} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PolicyPasswordDefaultConfig = {}
    */
    constructor(scope: Construct, id: string, config?: PolicyPasswordDefaultConfig);
    private _callRecovery?;
    get callRecovery(): string;
    set callRecovery(value: string);
    resetCallRecovery(): void;
    get callRecoveryInput(): string | undefined;
    get defaultAuthProvider(): string;
    get defaultIncludedGroupId(): string;
    get description(): string;
    private _emailRecovery?;
    get emailRecovery(): string;
    set emailRecovery(value: string);
    resetEmailRecovery(): void;
    get emailRecoveryInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _passwordAutoUnlockMinutes?;
    get passwordAutoUnlockMinutes(): number;
    set passwordAutoUnlockMinutes(value: number);
    resetPasswordAutoUnlockMinutes(): void;
    get passwordAutoUnlockMinutesInput(): number | undefined;
    private _passwordDictionaryLookup?;
    get passwordDictionaryLookup(): boolean | cdktf.IResolvable;
    set passwordDictionaryLookup(value: boolean | cdktf.IResolvable);
    resetPasswordDictionaryLookup(): void;
    get passwordDictionaryLookupInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordExcludeFirstName?;
    get passwordExcludeFirstName(): boolean | cdktf.IResolvable;
    set passwordExcludeFirstName(value: boolean | cdktf.IResolvable);
    resetPasswordExcludeFirstName(): void;
    get passwordExcludeFirstNameInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordExcludeLastName?;
    get passwordExcludeLastName(): boolean | cdktf.IResolvable;
    set passwordExcludeLastName(value: boolean | cdktf.IResolvable);
    resetPasswordExcludeLastName(): void;
    get passwordExcludeLastNameInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordExcludeUsername?;
    get passwordExcludeUsername(): boolean | cdktf.IResolvable;
    set passwordExcludeUsername(value: boolean | cdktf.IResolvable);
    resetPasswordExcludeUsername(): void;
    get passwordExcludeUsernameInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordExpireWarnDays?;
    get passwordExpireWarnDays(): number;
    set passwordExpireWarnDays(value: number);
    resetPasswordExpireWarnDays(): void;
    get passwordExpireWarnDaysInput(): number | undefined;
    private _passwordHistoryCount?;
    get passwordHistoryCount(): number;
    set passwordHistoryCount(value: number);
    resetPasswordHistoryCount(): void;
    get passwordHistoryCountInput(): number | undefined;
    private _passwordLockoutNotificationChannels?;
    get passwordLockoutNotificationChannels(): string[];
    set passwordLockoutNotificationChannels(value: string[]);
    resetPasswordLockoutNotificationChannels(): void;
    get passwordLockoutNotificationChannelsInput(): string[] | undefined;
    private _passwordMaxAgeDays?;
    get passwordMaxAgeDays(): number;
    set passwordMaxAgeDays(value: number);
    resetPasswordMaxAgeDays(): void;
    get passwordMaxAgeDaysInput(): number | undefined;
    private _passwordMaxLockoutAttempts?;
    get passwordMaxLockoutAttempts(): number;
    set passwordMaxLockoutAttempts(value: number);
    resetPasswordMaxLockoutAttempts(): void;
    get passwordMaxLockoutAttemptsInput(): number | undefined;
    private _passwordMinAgeMinutes?;
    get passwordMinAgeMinutes(): number;
    set passwordMinAgeMinutes(value: number);
    resetPasswordMinAgeMinutes(): void;
    get passwordMinAgeMinutesInput(): number | undefined;
    private _passwordMinLength?;
    get passwordMinLength(): number;
    set passwordMinLength(value: number);
    resetPasswordMinLength(): void;
    get passwordMinLengthInput(): number | undefined;
    private _passwordMinLowercase?;
    get passwordMinLowercase(): number;
    set passwordMinLowercase(value: number);
    resetPasswordMinLowercase(): void;
    get passwordMinLowercaseInput(): number | undefined;
    private _passwordMinNumber?;
    get passwordMinNumber(): number;
    set passwordMinNumber(value: number);
    resetPasswordMinNumber(): void;
    get passwordMinNumberInput(): number | undefined;
    private _passwordMinSymbol?;
    get passwordMinSymbol(): number;
    set passwordMinSymbol(value: number);
    resetPasswordMinSymbol(): void;
    get passwordMinSymbolInput(): number | undefined;
    private _passwordMinUppercase?;
    get passwordMinUppercase(): number;
    set passwordMinUppercase(value: number);
    resetPasswordMinUppercase(): void;
    get passwordMinUppercaseInput(): number | undefined;
    private _passwordShowLockoutFailures?;
    get passwordShowLockoutFailures(): boolean | cdktf.IResolvable;
    set passwordShowLockoutFailures(value: boolean | cdktf.IResolvable);
    resetPasswordShowLockoutFailures(): void;
    get passwordShowLockoutFailuresInput(): boolean | cdktf.IResolvable | undefined;
    get priority(): number;
    private _questionMinLength?;
    get questionMinLength(): number;
    set questionMinLength(value: number);
    resetQuestionMinLength(): void;
    get questionMinLengthInput(): number | undefined;
    private _questionRecovery?;
    get questionRecovery(): string;
    set questionRecovery(value: string);
    resetQuestionRecovery(): void;
    get questionRecoveryInput(): string | undefined;
    private _recoveryEmailToken?;
    get recoveryEmailToken(): number;
    set recoveryEmailToken(value: number);
    resetRecoveryEmailToken(): void;
    get recoveryEmailTokenInput(): number | undefined;
    private _skipUnlock?;
    get skipUnlock(): boolean | cdktf.IResolvable;
    set skipUnlock(value: boolean | cdktf.IResolvable);
    resetSkipUnlock(): void;
    get skipUnlockInput(): boolean | cdktf.IResolvable | undefined;
    private _smsRecovery?;
    get smsRecovery(): string;
    set smsRecovery(value: string);
    resetSmsRecovery(): void;
    get smsRecoveryInput(): string | undefined;
    get status(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
