"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyPasswordDefault = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default okta_policy_password_default}
*/
class PolicyPasswordDefault extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default okta_policy_password_default} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PolicyPasswordDefaultConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'okta_policy_password_default',
            terraformGeneratorMetadata: {
                providerName: 'okta',
                providerVersion: '3.35.0',
                providerVersionConstraint: '~> 3.20'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._callRecovery = config.callRecovery;
        this._emailRecovery = config.emailRecovery;
        this._id = config.id;
        this._passwordAutoUnlockMinutes = config.passwordAutoUnlockMinutes;
        this._passwordDictionaryLookup = config.passwordDictionaryLookup;
        this._passwordExcludeFirstName = config.passwordExcludeFirstName;
        this._passwordExcludeLastName = config.passwordExcludeLastName;
        this._passwordExcludeUsername = config.passwordExcludeUsername;
        this._passwordExpireWarnDays = config.passwordExpireWarnDays;
        this._passwordHistoryCount = config.passwordHistoryCount;
        this._passwordLockoutNotificationChannels = config.passwordLockoutNotificationChannels;
        this._passwordMaxAgeDays = config.passwordMaxAgeDays;
        this._passwordMaxLockoutAttempts = config.passwordMaxLockoutAttempts;
        this._passwordMinAgeMinutes = config.passwordMinAgeMinutes;
        this._passwordMinLength = config.passwordMinLength;
        this._passwordMinLowercase = config.passwordMinLowercase;
        this._passwordMinNumber = config.passwordMinNumber;
        this._passwordMinSymbol = config.passwordMinSymbol;
        this._passwordMinUppercase = config.passwordMinUppercase;
        this._passwordShowLockoutFailures = config.passwordShowLockoutFailures;
        this._questionMinLength = config.questionMinLength;
        this._questionRecovery = config.questionRecovery;
        this._recoveryEmailToken = config.recoveryEmailToken;
        this._skipUnlock = config.skipUnlock;
        this._smsRecovery = config.smsRecovery;
    }
    get callRecovery() {
        return this.getStringAttribute('call_recovery');
    }
    set callRecovery(value) {
        this._callRecovery = value;
    }
    resetCallRecovery() {
        this._callRecovery = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get callRecoveryInput() {
        return this._callRecovery;
    }
    // default_auth_provider - computed: true, optional: false, required: false
    get defaultAuthProvider() {
        return this.getStringAttribute('default_auth_provider');
    }
    // default_included_group_id - computed: true, optional: false, required: false
    get defaultIncludedGroupId() {
        return this.getStringAttribute('default_included_group_id');
    }
    // description - computed: true, optional: false, required: false
    get description() {
        return this.getStringAttribute('description');
    }
    get emailRecovery() {
        return this.getStringAttribute('email_recovery');
    }
    set emailRecovery(value) {
        this._emailRecovery = value;
    }
    resetEmailRecovery() {
        this._emailRecovery = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emailRecoveryInput() {
        return this._emailRecovery;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    // name - computed: true, optional: false, required: false
    get name() {
        return this.getStringAttribute('name');
    }
    get passwordAutoUnlockMinutes() {
        return this.getNumberAttribute('password_auto_unlock_minutes');
    }
    set passwordAutoUnlockMinutes(value) {
        this._passwordAutoUnlockMinutes = value;
    }
    resetPasswordAutoUnlockMinutes() {
        this._passwordAutoUnlockMinutes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordAutoUnlockMinutesInput() {
        return this._passwordAutoUnlockMinutes;
    }
    get passwordDictionaryLookup() {
        return this.getBooleanAttribute('password_dictionary_lookup');
    }
    set passwordDictionaryLookup(value) {
        this._passwordDictionaryLookup = value;
    }
    resetPasswordDictionaryLookup() {
        this._passwordDictionaryLookup = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordDictionaryLookupInput() {
        return this._passwordDictionaryLookup;
    }
    get passwordExcludeFirstName() {
        return this.getBooleanAttribute('password_exclude_first_name');
    }
    set passwordExcludeFirstName(value) {
        this._passwordExcludeFirstName = value;
    }
    resetPasswordExcludeFirstName() {
        this._passwordExcludeFirstName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordExcludeFirstNameInput() {
        return this._passwordExcludeFirstName;
    }
    get passwordExcludeLastName() {
        return this.getBooleanAttribute('password_exclude_last_name');
    }
    set passwordExcludeLastName(value) {
        this._passwordExcludeLastName = value;
    }
    resetPasswordExcludeLastName() {
        this._passwordExcludeLastName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordExcludeLastNameInput() {
        return this._passwordExcludeLastName;
    }
    get passwordExcludeUsername() {
        return this.getBooleanAttribute('password_exclude_username');
    }
    set passwordExcludeUsername(value) {
        this._passwordExcludeUsername = value;
    }
    resetPasswordExcludeUsername() {
        this._passwordExcludeUsername = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordExcludeUsernameInput() {
        return this._passwordExcludeUsername;
    }
    get passwordExpireWarnDays() {
        return this.getNumberAttribute('password_expire_warn_days');
    }
    set passwordExpireWarnDays(value) {
        this._passwordExpireWarnDays = value;
    }
    resetPasswordExpireWarnDays() {
        this._passwordExpireWarnDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordExpireWarnDaysInput() {
        return this._passwordExpireWarnDays;
    }
    get passwordHistoryCount() {
        return this.getNumberAttribute('password_history_count');
    }
    set passwordHistoryCount(value) {
        this._passwordHistoryCount = value;
    }
    resetPasswordHistoryCount() {
        this._passwordHistoryCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordHistoryCountInput() {
        return this._passwordHistoryCount;
    }
    get passwordLockoutNotificationChannels() {
        return cdktf.Fn.tolist(this.getListAttribute('password_lockout_notification_channels'));
    }
    set passwordLockoutNotificationChannels(value) {
        this._passwordLockoutNotificationChannels = value;
    }
    resetPasswordLockoutNotificationChannels() {
        this._passwordLockoutNotificationChannels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordLockoutNotificationChannelsInput() {
        return this._passwordLockoutNotificationChannels;
    }
    get passwordMaxAgeDays() {
        return this.getNumberAttribute('password_max_age_days');
    }
    set passwordMaxAgeDays(value) {
        this._passwordMaxAgeDays = value;
    }
    resetPasswordMaxAgeDays() {
        this._passwordMaxAgeDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordMaxAgeDaysInput() {
        return this._passwordMaxAgeDays;
    }
    get passwordMaxLockoutAttempts() {
        return this.getNumberAttribute('password_max_lockout_attempts');
    }
    set passwordMaxLockoutAttempts(value) {
        this._passwordMaxLockoutAttempts = value;
    }
    resetPasswordMaxLockoutAttempts() {
        this._passwordMaxLockoutAttempts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordMaxLockoutAttemptsInput() {
        return this._passwordMaxLockoutAttempts;
    }
    get passwordMinAgeMinutes() {
        return this.getNumberAttribute('password_min_age_minutes');
    }
    set passwordMinAgeMinutes(value) {
        this._passwordMinAgeMinutes = value;
    }
    resetPasswordMinAgeMinutes() {
        this._passwordMinAgeMinutes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordMinAgeMinutesInput() {
        return this._passwordMinAgeMinutes;
    }
    get passwordMinLength() {
        return this.getNumberAttribute('password_min_length');
    }
    set passwordMinLength(value) {
        this._passwordMinLength = value;
    }
    resetPasswordMinLength() {
        this._passwordMinLength = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordMinLengthInput() {
        return this._passwordMinLength;
    }
    get passwordMinLowercase() {
        return this.getNumberAttribute('password_min_lowercase');
    }
    set passwordMinLowercase(value) {
        this._passwordMinLowercase = value;
    }
    resetPasswordMinLowercase() {
        this._passwordMinLowercase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordMinLowercaseInput() {
        return this._passwordMinLowercase;
    }
    get passwordMinNumber() {
        return this.getNumberAttribute('password_min_number');
    }
    set passwordMinNumber(value) {
        this._passwordMinNumber = value;
    }
    resetPasswordMinNumber() {
        this._passwordMinNumber = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordMinNumberInput() {
        return this._passwordMinNumber;
    }
    get passwordMinSymbol() {
        return this.getNumberAttribute('password_min_symbol');
    }
    set passwordMinSymbol(value) {
        this._passwordMinSymbol = value;
    }
    resetPasswordMinSymbol() {
        this._passwordMinSymbol = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordMinSymbolInput() {
        return this._passwordMinSymbol;
    }
    get passwordMinUppercase() {
        return this.getNumberAttribute('password_min_uppercase');
    }
    set passwordMinUppercase(value) {
        this._passwordMinUppercase = value;
    }
    resetPasswordMinUppercase() {
        this._passwordMinUppercase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordMinUppercaseInput() {
        return this._passwordMinUppercase;
    }
    get passwordShowLockoutFailures() {
        return this.getBooleanAttribute('password_show_lockout_failures');
    }
    set passwordShowLockoutFailures(value) {
        this._passwordShowLockoutFailures = value;
    }
    resetPasswordShowLockoutFailures() {
        this._passwordShowLockoutFailures = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordShowLockoutFailuresInput() {
        return this._passwordShowLockoutFailures;
    }
    // priority - computed: true, optional: false, required: false
    get priority() {
        return this.getNumberAttribute('priority');
    }
    get questionMinLength() {
        return this.getNumberAttribute('question_min_length');
    }
    set questionMinLength(value) {
        this._questionMinLength = value;
    }
    resetQuestionMinLength() {
        this._questionMinLength = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get questionMinLengthInput() {
        return this._questionMinLength;
    }
    get questionRecovery() {
        return this.getStringAttribute('question_recovery');
    }
    set questionRecovery(value) {
        this._questionRecovery = value;
    }
    resetQuestionRecovery() {
        this._questionRecovery = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get questionRecoveryInput() {
        return this._questionRecovery;
    }
    get recoveryEmailToken() {
        return this.getNumberAttribute('recovery_email_token');
    }
    set recoveryEmailToken(value) {
        this._recoveryEmailToken = value;
    }
    resetRecoveryEmailToken() {
        this._recoveryEmailToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get recoveryEmailTokenInput() {
        return this._recoveryEmailToken;
    }
    get skipUnlock() {
        return this.getBooleanAttribute('skip_unlock');
    }
    set skipUnlock(value) {
        this._skipUnlock = value;
    }
    resetSkipUnlock() {
        this._skipUnlock = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipUnlockInput() {
        return this._skipUnlock;
    }
    get smsRecovery() {
        return this.getStringAttribute('sms_recovery');
    }
    set smsRecovery(value) {
        this._smsRecovery = value;
    }
    resetSmsRecovery() {
        this._smsRecovery = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get smsRecoveryInput() {
        return this._smsRecovery;
    }
    // status - computed: true, optional: false, required: false
    get status() {
        return this.getStringAttribute('status');
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            call_recovery: cdktf.stringToTerraform(this._callRecovery),
            email_recovery: cdktf.stringToTerraform(this._emailRecovery),
            id: cdktf.stringToTerraform(this._id),
            password_auto_unlock_minutes: cdktf.numberToTerraform(this._passwordAutoUnlockMinutes),
            password_dictionary_lookup: cdktf.booleanToTerraform(this._passwordDictionaryLookup),
            password_exclude_first_name: cdktf.booleanToTerraform(this._passwordExcludeFirstName),
            password_exclude_last_name: cdktf.booleanToTerraform(this._passwordExcludeLastName),
            password_exclude_username: cdktf.booleanToTerraform(this._passwordExcludeUsername),
            password_expire_warn_days: cdktf.numberToTerraform(this._passwordExpireWarnDays),
            password_history_count: cdktf.numberToTerraform(this._passwordHistoryCount),
            password_lockout_notification_channels: cdktf.listMapper(cdktf.stringToTerraform, false)(this._passwordLockoutNotificationChannels),
            password_max_age_days: cdktf.numberToTerraform(this._passwordMaxAgeDays),
            password_max_lockout_attempts: cdktf.numberToTerraform(this._passwordMaxLockoutAttempts),
            password_min_age_minutes: cdktf.numberToTerraform(this._passwordMinAgeMinutes),
            password_min_length: cdktf.numberToTerraform(this._passwordMinLength),
            password_min_lowercase: cdktf.numberToTerraform(this._passwordMinLowercase),
            password_min_number: cdktf.numberToTerraform(this._passwordMinNumber),
            password_min_symbol: cdktf.numberToTerraform(this._passwordMinSymbol),
            password_min_uppercase: cdktf.numberToTerraform(this._passwordMinUppercase),
            password_show_lockout_failures: cdktf.booleanToTerraform(this._passwordShowLockoutFailures),
            question_min_length: cdktf.numberToTerraform(this._questionMinLength),
            question_recovery: cdktf.stringToTerraform(this._questionRecovery),
            recovery_email_token: cdktf.numberToTerraform(this._recoveryEmailToken),
            skip_unlock: cdktf.booleanToTerraform(this._skipUnlock),
            sms_recovery: cdktf.stringToTerraform(this._smsRecovery),
        };
    }
}
exports.PolicyPasswordDefault = PolicyPasswordDefault;
_a = JSII_RTTI_SYMBOL_1;
PolicyPasswordDefault[_a] = { fqn: "@cdktf/provider-okta.PolicyPasswordDefault", version: "2.0.46" };
// =================
// STATIC PROPERTIES
// =================
PolicyPasswordDefault.tfResourceType = "okta_policy_password_default";
//# sourceMappingURL=data:application/json;base64,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