import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PolicyPasswordConfig extends cdktf.TerraformMetaArguments {
    /**
    * Authentication Provider: OKTA, ACTIVE_DIRECTORY or LDAP
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#auth_provider PolicyPassword#auth_provider}
    */
    readonly authProvider?: string;
    /**
    * Enable or disable voice call recovery: ACTIVE or INACTIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#call_recovery PolicyPassword#call_recovery}
    */
    readonly callRecovery?: string;
    /**
    * Policy Description
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#description PolicyPassword#description}
    */
    readonly description?: string;
    /**
    * Enable or disable email password recovery: ACTIVE or INACTIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#email_recovery PolicyPassword#email_recovery}
    */
    readonly emailRecovery?: string;
    /**
    * List of Group IDs to Include
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#groups_included PolicyPassword#groups_included}
    */
    readonly groupsIncluded?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#id PolicyPassword#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Policy Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#name PolicyPassword#name}
    */
    readonly name: string;
    /**
    * Number of minutes before a locked account is unlocked: 0 = no limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#password_auto_unlock_minutes PolicyPassword#password_auto_unlock_minutes}
    */
    readonly passwordAutoUnlockMinutes?: number;
    /**
    * Check Passwords Against Common Password Dictionary.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#password_dictionary_lookup PolicyPassword#password_dictionary_lookup}
    */
    readonly passwordDictionaryLookup?: boolean | cdktf.IResolvable;
    /**
    * User firstName attribute must be excluded from the password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#password_exclude_first_name PolicyPassword#password_exclude_first_name}
    */
    readonly passwordExcludeFirstName?: boolean | cdktf.IResolvable;
    /**
    * User lastName attribute must be excluded from the password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#password_exclude_last_name PolicyPassword#password_exclude_last_name}
    */
    readonly passwordExcludeLastName?: boolean | cdktf.IResolvable;
    /**
    * If the user name must be excluded from the password.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#password_exclude_username PolicyPassword#password_exclude_username}
    */
    readonly passwordExcludeUsername?: boolean | cdktf.IResolvable;
    /**
    * Length in days a user will be warned before password expiry: 0 = no warning.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#password_expire_warn_days PolicyPassword#password_expire_warn_days}
    */
    readonly passwordExpireWarnDays?: number;
    /**
    * Number of distinct passwords that must be created before they can be reused: 0 = none.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#password_history_count PolicyPassword#password_history_count}
    */
    readonly passwordHistoryCount?: number;
    /**
    * Notification channels to use to notify a user when their account has been locked.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#password_lockout_notification_channels PolicyPassword#password_lockout_notification_channels}
    */
    readonly passwordLockoutNotificationChannels?: string[];
    /**
    * Length in days a password is valid before expiry: 0 = no limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#password_max_age_days PolicyPassword#password_max_age_days}
    */
    readonly passwordMaxAgeDays?: number;
    /**
    * Number of unsuccessful login attempts allowed before lockout: 0 = no limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#password_max_lockout_attempts PolicyPassword#password_max_lockout_attempts}
    */
    readonly passwordMaxLockoutAttempts?: number;
    /**
    * Minimum time interval in minutes between password changes: 0 = no limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#password_min_age_minutes PolicyPassword#password_min_age_minutes}
    */
    readonly passwordMinAgeMinutes?: number;
    /**
    * Minimum password length.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#password_min_length PolicyPassword#password_min_length}
    */
    readonly passwordMinLength?: number;
    /**
    * If a password must contain at least one lower case letter: 0 = no, 1 = yes. Default = 1
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#password_min_lowercase PolicyPassword#password_min_lowercase}
    */
    readonly passwordMinLowercase?: number;
    /**
    * If a password must contain at least one number: 0 = no, 1 = yes. Default = 1
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#password_min_number PolicyPassword#password_min_number}
    */
    readonly passwordMinNumber?: number;
    /**
    * If a password must contain at least one symbol (!@#$%^&*): 0 = no, 1 = yes. Default = 1
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#password_min_symbol PolicyPassword#password_min_symbol}
    */
    readonly passwordMinSymbol?: number;
    /**
    * If a password must contain at least one upper case letter: 0 = no, 1 = yes. Default = 1
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#password_min_uppercase PolicyPassword#password_min_uppercase}
    */
    readonly passwordMinUppercase?: number;
    /**
    * If a user should be informed when their account is locked.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#password_show_lockout_failures PolicyPassword#password_show_lockout_failures}
    */
    readonly passwordShowLockoutFailures?: boolean | cdktf.IResolvable;
    /**
    * Policy Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#priority PolicyPassword#priority}
    */
    readonly priority?: number;
    /**
    * Min length of the password recovery question answer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#question_min_length PolicyPassword#question_min_length}
    */
    readonly questionMinLength?: number;
    /**
    * Enable or disable security question password recovery: ACTIVE or INACTIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#question_recovery PolicyPassword#question_recovery}
    */
    readonly questionRecovery?: string;
    /**
    * Lifetime in minutes of the recovery email token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#recovery_email_token PolicyPassword#recovery_email_token}
    */
    readonly recoveryEmailToken?: number;
    /**
    * When an Active Directory user is locked out of Okta, the Okta unlock operation should also attempt to unlock the user's Windows account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#skip_unlock PolicyPassword#skip_unlock}
    */
    readonly skipUnlock?: boolean | cdktf.IResolvable;
    /**
    * Enable or disable SMS password recovery: ACTIVE or INACTIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#sms_recovery PolicyPassword#sms_recovery}
    */
    readonly smsRecovery?: string;
    /**
    * Policy Status: ACTIVE or INACTIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password#status PolicyPassword#status}
    */
    readonly status?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/policy_password okta_policy_password}
*/
export declare class PolicyPassword extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_policy_password";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/policy_password okta_policy_password} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PolicyPasswordConfig
    */
    constructor(scope: Construct, id: string, config: PolicyPasswordConfig);
    private _authProvider?;
    get authProvider(): string;
    set authProvider(value: string);
    resetAuthProvider(): void;
    get authProviderInput(): string | undefined;
    private _callRecovery?;
    get callRecovery(): string;
    set callRecovery(value: string);
    resetCallRecovery(): void;
    get callRecoveryInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _emailRecovery?;
    get emailRecovery(): string;
    set emailRecovery(value: string);
    resetEmailRecovery(): void;
    get emailRecoveryInput(): string | undefined;
    private _groupsIncluded?;
    get groupsIncluded(): string[];
    set groupsIncluded(value: string[]);
    resetGroupsIncluded(): void;
    get groupsIncludedInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _passwordAutoUnlockMinutes?;
    get passwordAutoUnlockMinutes(): number;
    set passwordAutoUnlockMinutes(value: number);
    resetPasswordAutoUnlockMinutes(): void;
    get passwordAutoUnlockMinutesInput(): number | undefined;
    private _passwordDictionaryLookup?;
    get passwordDictionaryLookup(): boolean | cdktf.IResolvable;
    set passwordDictionaryLookup(value: boolean | cdktf.IResolvable);
    resetPasswordDictionaryLookup(): void;
    get passwordDictionaryLookupInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordExcludeFirstName?;
    get passwordExcludeFirstName(): boolean | cdktf.IResolvable;
    set passwordExcludeFirstName(value: boolean | cdktf.IResolvable);
    resetPasswordExcludeFirstName(): void;
    get passwordExcludeFirstNameInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordExcludeLastName?;
    get passwordExcludeLastName(): boolean | cdktf.IResolvable;
    set passwordExcludeLastName(value: boolean | cdktf.IResolvable);
    resetPasswordExcludeLastName(): void;
    get passwordExcludeLastNameInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordExcludeUsername?;
    get passwordExcludeUsername(): boolean | cdktf.IResolvable;
    set passwordExcludeUsername(value: boolean | cdktf.IResolvable);
    resetPasswordExcludeUsername(): void;
    get passwordExcludeUsernameInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordExpireWarnDays?;
    get passwordExpireWarnDays(): number;
    set passwordExpireWarnDays(value: number);
    resetPasswordExpireWarnDays(): void;
    get passwordExpireWarnDaysInput(): number | undefined;
    private _passwordHistoryCount?;
    get passwordHistoryCount(): number;
    set passwordHistoryCount(value: number);
    resetPasswordHistoryCount(): void;
    get passwordHistoryCountInput(): number | undefined;
    private _passwordLockoutNotificationChannels?;
    get passwordLockoutNotificationChannels(): string[];
    set passwordLockoutNotificationChannels(value: string[]);
    resetPasswordLockoutNotificationChannels(): void;
    get passwordLockoutNotificationChannelsInput(): string[] | undefined;
    private _passwordMaxAgeDays?;
    get passwordMaxAgeDays(): number;
    set passwordMaxAgeDays(value: number);
    resetPasswordMaxAgeDays(): void;
    get passwordMaxAgeDaysInput(): number | undefined;
    private _passwordMaxLockoutAttempts?;
    get passwordMaxLockoutAttempts(): number;
    set passwordMaxLockoutAttempts(value: number);
    resetPasswordMaxLockoutAttempts(): void;
    get passwordMaxLockoutAttemptsInput(): number | undefined;
    private _passwordMinAgeMinutes?;
    get passwordMinAgeMinutes(): number;
    set passwordMinAgeMinutes(value: number);
    resetPasswordMinAgeMinutes(): void;
    get passwordMinAgeMinutesInput(): number | undefined;
    private _passwordMinLength?;
    get passwordMinLength(): number;
    set passwordMinLength(value: number);
    resetPasswordMinLength(): void;
    get passwordMinLengthInput(): number | undefined;
    private _passwordMinLowercase?;
    get passwordMinLowercase(): number;
    set passwordMinLowercase(value: number);
    resetPasswordMinLowercase(): void;
    get passwordMinLowercaseInput(): number | undefined;
    private _passwordMinNumber?;
    get passwordMinNumber(): number;
    set passwordMinNumber(value: number);
    resetPasswordMinNumber(): void;
    get passwordMinNumberInput(): number | undefined;
    private _passwordMinSymbol?;
    get passwordMinSymbol(): number;
    set passwordMinSymbol(value: number);
    resetPasswordMinSymbol(): void;
    get passwordMinSymbolInput(): number | undefined;
    private _passwordMinUppercase?;
    get passwordMinUppercase(): number;
    set passwordMinUppercase(value: number);
    resetPasswordMinUppercase(): void;
    get passwordMinUppercaseInput(): number | undefined;
    private _passwordShowLockoutFailures?;
    get passwordShowLockoutFailures(): boolean | cdktf.IResolvable;
    set passwordShowLockoutFailures(value: boolean | cdktf.IResolvable);
    resetPasswordShowLockoutFailures(): void;
    get passwordShowLockoutFailuresInput(): boolean | cdktf.IResolvable | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _questionMinLength?;
    get questionMinLength(): number;
    set questionMinLength(value: number);
    resetQuestionMinLength(): void;
    get questionMinLengthInput(): number | undefined;
    private _questionRecovery?;
    get questionRecovery(): string;
    set questionRecovery(value: string);
    resetQuestionRecovery(): void;
    get questionRecoveryInput(): string | undefined;
    private _recoveryEmailToken?;
    get recoveryEmailToken(): number;
    set recoveryEmailToken(value: number);
    resetRecoveryEmailToken(): void;
    get recoveryEmailTokenInput(): number | undefined;
    private _skipUnlock?;
    get skipUnlock(): boolean | cdktf.IResolvable;
    set skipUnlock(value: boolean | cdktf.IResolvable);
    resetSkipUnlock(): void;
    get skipUnlockInput(): boolean | cdktf.IResolvable | undefined;
    private _smsRecovery?;
    get smsRecovery(): string;
    set smsRecovery(value: string);
    resetSmsRecovery(): void;
    get smsRecoveryInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
