"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyPassword = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/policy_password okta_policy_password}
*/
class PolicyPassword extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/policy_password okta_policy_password} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PolicyPasswordConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'okta_policy_password',
            terraformGeneratorMetadata: {
                providerName: 'okta',
                providerVersion: '3.35.0',
                providerVersionConstraint: '~> 3.20'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._authProvider = config.authProvider;
        this._callRecovery = config.callRecovery;
        this._description = config.description;
        this._emailRecovery = config.emailRecovery;
        this._groupsIncluded = config.groupsIncluded;
        this._id = config.id;
        this._name = config.name;
        this._passwordAutoUnlockMinutes = config.passwordAutoUnlockMinutes;
        this._passwordDictionaryLookup = config.passwordDictionaryLookup;
        this._passwordExcludeFirstName = config.passwordExcludeFirstName;
        this._passwordExcludeLastName = config.passwordExcludeLastName;
        this._passwordExcludeUsername = config.passwordExcludeUsername;
        this._passwordExpireWarnDays = config.passwordExpireWarnDays;
        this._passwordHistoryCount = config.passwordHistoryCount;
        this._passwordLockoutNotificationChannels = config.passwordLockoutNotificationChannels;
        this._passwordMaxAgeDays = config.passwordMaxAgeDays;
        this._passwordMaxLockoutAttempts = config.passwordMaxLockoutAttempts;
        this._passwordMinAgeMinutes = config.passwordMinAgeMinutes;
        this._passwordMinLength = config.passwordMinLength;
        this._passwordMinLowercase = config.passwordMinLowercase;
        this._passwordMinNumber = config.passwordMinNumber;
        this._passwordMinSymbol = config.passwordMinSymbol;
        this._passwordMinUppercase = config.passwordMinUppercase;
        this._passwordShowLockoutFailures = config.passwordShowLockoutFailures;
        this._priority = config.priority;
        this._questionMinLength = config.questionMinLength;
        this._questionRecovery = config.questionRecovery;
        this._recoveryEmailToken = config.recoveryEmailToken;
        this._skipUnlock = config.skipUnlock;
        this._smsRecovery = config.smsRecovery;
        this._status = config.status;
    }
    get authProvider() {
        return this.getStringAttribute('auth_provider');
    }
    set authProvider(value) {
        this._authProvider = value;
    }
    resetAuthProvider() {
        this._authProvider = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authProviderInput() {
        return this._authProvider;
    }
    get callRecovery() {
        return this.getStringAttribute('call_recovery');
    }
    set callRecovery(value) {
        this._callRecovery = value;
    }
    resetCallRecovery() {
        this._callRecovery = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get callRecoveryInput() {
        return this._callRecovery;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get emailRecovery() {
        return this.getStringAttribute('email_recovery');
    }
    set emailRecovery(value) {
        this._emailRecovery = value;
    }
    resetEmailRecovery() {
        this._emailRecovery = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emailRecoveryInput() {
        return this._emailRecovery;
    }
    get groupsIncluded() {
        return cdktf.Fn.tolist(this.getListAttribute('groups_included'));
    }
    set groupsIncluded(value) {
        this._groupsIncluded = value;
    }
    resetGroupsIncluded() {
        this._groupsIncluded = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupsIncludedInput() {
        return this._groupsIncluded;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get passwordAutoUnlockMinutes() {
        return this.getNumberAttribute('password_auto_unlock_minutes');
    }
    set passwordAutoUnlockMinutes(value) {
        this._passwordAutoUnlockMinutes = value;
    }
    resetPasswordAutoUnlockMinutes() {
        this._passwordAutoUnlockMinutes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordAutoUnlockMinutesInput() {
        return this._passwordAutoUnlockMinutes;
    }
    get passwordDictionaryLookup() {
        return this.getBooleanAttribute('password_dictionary_lookup');
    }
    set passwordDictionaryLookup(value) {
        this._passwordDictionaryLookup = value;
    }
    resetPasswordDictionaryLookup() {
        this._passwordDictionaryLookup = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordDictionaryLookupInput() {
        return this._passwordDictionaryLookup;
    }
    get passwordExcludeFirstName() {
        return this.getBooleanAttribute('password_exclude_first_name');
    }
    set passwordExcludeFirstName(value) {
        this._passwordExcludeFirstName = value;
    }
    resetPasswordExcludeFirstName() {
        this._passwordExcludeFirstName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordExcludeFirstNameInput() {
        return this._passwordExcludeFirstName;
    }
    get passwordExcludeLastName() {
        return this.getBooleanAttribute('password_exclude_last_name');
    }
    set passwordExcludeLastName(value) {
        this._passwordExcludeLastName = value;
    }
    resetPasswordExcludeLastName() {
        this._passwordExcludeLastName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordExcludeLastNameInput() {
        return this._passwordExcludeLastName;
    }
    get passwordExcludeUsername() {
        return this.getBooleanAttribute('password_exclude_username');
    }
    set passwordExcludeUsername(value) {
        this._passwordExcludeUsername = value;
    }
    resetPasswordExcludeUsername() {
        this._passwordExcludeUsername = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordExcludeUsernameInput() {
        return this._passwordExcludeUsername;
    }
    get passwordExpireWarnDays() {
        return this.getNumberAttribute('password_expire_warn_days');
    }
    set passwordExpireWarnDays(value) {
        this._passwordExpireWarnDays = value;
    }
    resetPasswordExpireWarnDays() {
        this._passwordExpireWarnDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordExpireWarnDaysInput() {
        return this._passwordExpireWarnDays;
    }
    get passwordHistoryCount() {
        return this.getNumberAttribute('password_history_count');
    }
    set passwordHistoryCount(value) {
        this._passwordHistoryCount = value;
    }
    resetPasswordHistoryCount() {
        this._passwordHistoryCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordHistoryCountInput() {
        return this._passwordHistoryCount;
    }
    get passwordLockoutNotificationChannels() {
        return cdktf.Fn.tolist(this.getListAttribute('password_lockout_notification_channels'));
    }
    set passwordLockoutNotificationChannels(value) {
        this._passwordLockoutNotificationChannels = value;
    }
    resetPasswordLockoutNotificationChannels() {
        this._passwordLockoutNotificationChannels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordLockoutNotificationChannelsInput() {
        return this._passwordLockoutNotificationChannels;
    }
    get passwordMaxAgeDays() {
        return this.getNumberAttribute('password_max_age_days');
    }
    set passwordMaxAgeDays(value) {
        this._passwordMaxAgeDays = value;
    }
    resetPasswordMaxAgeDays() {
        this._passwordMaxAgeDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordMaxAgeDaysInput() {
        return this._passwordMaxAgeDays;
    }
    get passwordMaxLockoutAttempts() {
        return this.getNumberAttribute('password_max_lockout_attempts');
    }
    set passwordMaxLockoutAttempts(value) {
        this._passwordMaxLockoutAttempts = value;
    }
    resetPasswordMaxLockoutAttempts() {
        this._passwordMaxLockoutAttempts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordMaxLockoutAttemptsInput() {
        return this._passwordMaxLockoutAttempts;
    }
    get passwordMinAgeMinutes() {
        return this.getNumberAttribute('password_min_age_minutes');
    }
    set passwordMinAgeMinutes(value) {
        this._passwordMinAgeMinutes = value;
    }
    resetPasswordMinAgeMinutes() {
        this._passwordMinAgeMinutes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordMinAgeMinutesInput() {
        return this._passwordMinAgeMinutes;
    }
    get passwordMinLength() {
        return this.getNumberAttribute('password_min_length');
    }
    set passwordMinLength(value) {
        this._passwordMinLength = value;
    }
    resetPasswordMinLength() {
        this._passwordMinLength = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordMinLengthInput() {
        return this._passwordMinLength;
    }
    get passwordMinLowercase() {
        return this.getNumberAttribute('password_min_lowercase');
    }
    set passwordMinLowercase(value) {
        this._passwordMinLowercase = value;
    }
    resetPasswordMinLowercase() {
        this._passwordMinLowercase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordMinLowercaseInput() {
        return this._passwordMinLowercase;
    }
    get passwordMinNumber() {
        return this.getNumberAttribute('password_min_number');
    }
    set passwordMinNumber(value) {
        this._passwordMinNumber = value;
    }
    resetPasswordMinNumber() {
        this._passwordMinNumber = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordMinNumberInput() {
        return this._passwordMinNumber;
    }
    get passwordMinSymbol() {
        return this.getNumberAttribute('password_min_symbol');
    }
    set passwordMinSymbol(value) {
        this._passwordMinSymbol = value;
    }
    resetPasswordMinSymbol() {
        this._passwordMinSymbol = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordMinSymbolInput() {
        return this._passwordMinSymbol;
    }
    get passwordMinUppercase() {
        return this.getNumberAttribute('password_min_uppercase');
    }
    set passwordMinUppercase(value) {
        this._passwordMinUppercase = value;
    }
    resetPasswordMinUppercase() {
        this._passwordMinUppercase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordMinUppercaseInput() {
        return this._passwordMinUppercase;
    }
    get passwordShowLockoutFailures() {
        return this.getBooleanAttribute('password_show_lockout_failures');
    }
    set passwordShowLockoutFailures(value) {
        this._passwordShowLockoutFailures = value;
    }
    resetPasswordShowLockoutFailures() {
        this._passwordShowLockoutFailures = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordShowLockoutFailuresInput() {
        return this._passwordShowLockoutFailures;
    }
    get priority() {
        return this.getNumberAttribute('priority');
    }
    set priority(value) {
        this._priority = value;
    }
    resetPriority() {
        this._priority = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get priorityInput() {
        return this._priority;
    }
    get questionMinLength() {
        return this.getNumberAttribute('question_min_length');
    }
    set questionMinLength(value) {
        this._questionMinLength = value;
    }
    resetQuestionMinLength() {
        this._questionMinLength = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get questionMinLengthInput() {
        return this._questionMinLength;
    }
    get questionRecovery() {
        return this.getStringAttribute('question_recovery');
    }
    set questionRecovery(value) {
        this._questionRecovery = value;
    }
    resetQuestionRecovery() {
        this._questionRecovery = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get questionRecoveryInput() {
        return this._questionRecovery;
    }
    get recoveryEmailToken() {
        return this.getNumberAttribute('recovery_email_token');
    }
    set recoveryEmailToken(value) {
        this._recoveryEmailToken = value;
    }
    resetRecoveryEmailToken() {
        this._recoveryEmailToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get recoveryEmailTokenInput() {
        return this._recoveryEmailToken;
    }
    get skipUnlock() {
        return this.getBooleanAttribute('skip_unlock');
    }
    set skipUnlock(value) {
        this._skipUnlock = value;
    }
    resetSkipUnlock() {
        this._skipUnlock = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipUnlockInput() {
        return this._skipUnlock;
    }
    get smsRecovery() {
        return this.getStringAttribute('sms_recovery');
    }
    set smsRecovery(value) {
        this._smsRecovery = value;
    }
    resetSmsRecovery() {
        this._smsRecovery = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get smsRecoveryInput() {
        return this._smsRecovery;
    }
    get status() {
        return this.getStringAttribute('status');
    }
    set status(value) {
        this._status = value;
    }
    resetStatus() {
        this._status = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get statusInput() {
        return this._status;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            auth_provider: cdktf.stringToTerraform(this._authProvider),
            call_recovery: cdktf.stringToTerraform(this._callRecovery),
            description: cdktf.stringToTerraform(this._description),
            email_recovery: cdktf.stringToTerraform(this._emailRecovery),
            groups_included: cdktf.listMapper(cdktf.stringToTerraform, false)(this._groupsIncluded),
            id: cdktf.stringToTerraform(this._id),
            name: cdktf.stringToTerraform(this._name),
            password_auto_unlock_minutes: cdktf.numberToTerraform(this._passwordAutoUnlockMinutes),
            password_dictionary_lookup: cdktf.booleanToTerraform(this._passwordDictionaryLookup),
            password_exclude_first_name: cdktf.booleanToTerraform(this._passwordExcludeFirstName),
            password_exclude_last_name: cdktf.booleanToTerraform(this._passwordExcludeLastName),
            password_exclude_username: cdktf.booleanToTerraform(this._passwordExcludeUsername),
            password_expire_warn_days: cdktf.numberToTerraform(this._passwordExpireWarnDays),
            password_history_count: cdktf.numberToTerraform(this._passwordHistoryCount),
            password_lockout_notification_channels: cdktf.listMapper(cdktf.stringToTerraform, false)(this._passwordLockoutNotificationChannels),
            password_max_age_days: cdktf.numberToTerraform(this._passwordMaxAgeDays),
            password_max_lockout_attempts: cdktf.numberToTerraform(this._passwordMaxLockoutAttempts),
            password_min_age_minutes: cdktf.numberToTerraform(this._passwordMinAgeMinutes),
            password_min_length: cdktf.numberToTerraform(this._passwordMinLength),
            password_min_lowercase: cdktf.numberToTerraform(this._passwordMinLowercase),
            password_min_number: cdktf.numberToTerraform(this._passwordMinNumber),
            password_min_symbol: cdktf.numberToTerraform(this._passwordMinSymbol),
            password_min_uppercase: cdktf.numberToTerraform(this._passwordMinUppercase),
            password_show_lockout_failures: cdktf.booleanToTerraform(this._passwordShowLockoutFailures),
            priority: cdktf.numberToTerraform(this._priority),
            question_min_length: cdktf.numberToTerraform(this._questionMinLength),
            question_recovery: cdktf.stringToTerraform(this._questionRecovery),
            recovery_email_token: cdktf.numberToTerraform(this._recoveryEmailToken),
            skip_unlock: cdktf.booleanToTerraform(this._skipUnlock),
            sms_recovery: cdktf.stringToTerraform(this._smsRecovery),
            status: cdktf.stringToTerraform(this._status),
        };
    }
}
exports.PolicyPassword = PolicyPassword;
_a = JSII_RTTI_SYMBOL_1;
PolicyPassword[_a] = { fqn: "@cdktf/provider-okta.PolicyPassword", version: "2.0.46" };
// =================
// STATIC PROPERTIES
// =================
PolicyPassword.tfResourceType = "okta_policy_password";
//# sourceMappingURL=data:application/json;base64,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