import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PolicyProfileEnrollmentAppsConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of app IDs to be added to this policy
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_profile_enrollment_apps#apps PolicyProfileEnrollmentApps#apps}
    */
    readonly apps?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_profile_enrollment_apps#id PolicyProfileEnrollmentApps#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ID of the enrollment policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_profile_enrollment_apps#policy_id PolicyProfileEnrollmentApps#policy_id}
    */
    readonly policyId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/policy_profile_enrollment_apps okta_policy_profile_enrollment_apps}
*/
export declare class PolicyProfileEnrollmentApps extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_policy_profile_enrollment_apps";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/policy_profile_enrollment_apps okta_policy_profile_enrollment_apps} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PolicyProfileEnrollmentAppsConfig
    */
    constructor(scope: Construct, id: string, config: PolicyProfileEnrollmentAppsConfig);
    private _apps?;
    get apps(): string[];
    set apps(value: string[]);
    resetApps(): void;
    get appsInput(): string[] | undefined;
    get defaultPolicyId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    get policyIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
