import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PolicyRuleIdpDiscoveryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#id PolicyRuleIdpDiscovery#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#idp_id PolicyRuleIdpDiscovery#idp_id}
    */
    readonly idpId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#idp_type PolicyRuleIdpDiscovery#idp_type}
    */
    readonly idpType?: string;
    /**
    * Policy Rule Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#name PolicyRuleIdpDiscovery#name}
    */
    readonly name: string;
    /**
    * Network selection mode: ANYWHERE, ZONE, ON_NETWORK, or OFF_NETWORK.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#network_connection PolicyRuleIdpDiscovery#network_connection}
    */
    readonly networkConnection?: string;
    /**
    * The zones to exclude
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#network_excludes PolicyRuleIdpDiscovery#network_excludes}
    */
    readonly networkExcludes?: string[];
    /**
    * The zones to include
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#network_includes PolicyRuleIdpDiscovery#network_includes}
    */
    readonly networkIncludes?: string[];
    /**
    * Policy ID of the Rule
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#policy_id PolicyRuleIdpDiscovery#policy_id}
    */
    readonly policyId?: string;
    /**
    * Policy ID of the Rule
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#policyid PolicyRuleIdpDiscovery#policyid}
    */
    readonly policyid?: string;
    /**
    * Policy Rule Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#priority PolicyRuleIdpDiscovery#priority}
    */
    readonly priority?: number;
    /**
    * Policy Rule Status: ACTIVE or INACTIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#status PolicyRuleIdpDiscovery#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#user_identifier_attribute PolicyRuleIdpDiscovery#user_identifier_attribute}
    */
    readonly userIdentifierAttribute?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#user_identifier_type PolicyRuleIdpDiscovery#user_identifier_type}
    */
    readonly userIdentifierType?: string;
    /**
    * app_exclude block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#app_exclude PolicyRuleIdpDiscovery#app_exclude}
    */
    readonly appExclude?: PolicyRuleIdpDiscoveryAppExclude[] | cdktf.IResolvable;
    /**
    * app_include block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#app_include PolicyRuleIdpDiscovery#app_include}
    */
    readonly appInclude?: PolicyRuleIdpDiscoveryAppInclude[] | cdktf.IResolvable;
    /**
    * platform_include block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#platform_include PolicyRuleIdpDiscovery#platform_include}
    */
    readonly platformInclude?: PolicyRuleIdpDiscoveryPlatformInclude[] | cdktf.IResolvable;
    /**
    * user_identifier_patterns block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#user_identifier_patterns PolicyRuleIdpDiscovery#user_identifier_patterns}
    */
    readonly userIdentifierPatterns?: PolicyRuleIdpDiscoveryUserIdentifierPatterns[] | cdktf.IResolvable;
}
export interface PolicyRuleIdpDiscoveryAppExclude {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#id PolicyRuleIdpDiscovery#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#name PolicyRuleIdpDiscovery#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#type PolicyRuleIdpDiscovery#type}
    */
    readonly type: string;
}
export declare function policyRuleIdpDiscoveryAppExcludeToTerraform(struct?: PolicyRuleIdpDiscoveryAppExclude | cdktf.IResolvable): any;
export declare class PolicyRuleIdpDiscoveryAppExcludeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PolicyRuleIdpDiscoveryAppExclude | cdktf.IResolvable | undefined;
    set internalValue(value: PolicyRuleIdpDiscoveryAppExclude | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class PolicyRuleIdpDiscoveryAppExcludeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PolicyRuleIdpDiscoveryAppExclude[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PolicyRuleIdpDiscoveryAppExcludeOutputReference;
}
export interface PolicyRuleIdpDiscoveryAppInclude {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#id PolicyRuleIdpDiscovery#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#name PolicyRuleIdpDiscovery#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#type PolicyRuleIdpDiscovery#type}
    */
    readonly type: string;
}
export declare function policyRuleIdpDiscoveryAppIncludeToTerraform(struct?: PolicyRuleIdpDiscoveryAppInclude | cdktf.IResolvable): any;
export declare class PolicyRuleIdpDiscoveryAppIncludeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PolicyRuleIdpDiscoveryAppInclude | cdktf.IResolvable | undefined;
    set internalValue(value: PolicyRuleIdpDiscoveryAppInclude | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class PolicyRuleIdpDiscoveryAppIncludeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PolicyRuleIdpDiscoveryAppInclude[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PolicyRuleIdpDiscoveryAppIncludeOutputReference;
}
export interface PolicyRuleIdpDiscoveryPlatformInclude {
    /**
    * Only available with OTHER OS type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#os_expression PolicyRuleIdpDiscovery#os_expression}
    */
    readonly osExpression?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#os_type PolicyRuleIdpDiscovery#os_type}
    */
    readonly osType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#type PolicyRuleIdpDiscovery#type}
    */
    readonly type?: string;
}
export declare function policyRuleIdpDiscoveryPlatformIncludeToTerraform(struct?: PolicyRuleIdpDiscoveryPlatformInclude | cdktf.IResolvable): any;
export declare class PolicyRuleIdpDiscoveryPlatformIncludeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PolicyRuleIdpDiscoveryPlatformInclude | cdktf.IResolvable | undefined;
    set internalValue(value: PolicyRuleIdpDiscoveryPlatformInclude | cdktf.IResolvable | undefined);
    private _osExpression?;
    get osExpression(): string;
    set osExpression(value: string);
    resetOsExpression(): void;
    get osExpressionInput(): string | undefined;
    private _osType?;
    get osType(): string;
    set osType(value: string);
    resetOsType(): void;
    get osTypeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class PolicyRuleIdpDiscoveryPlatformIncludeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PolicyRuleIdpDiscoveryPlatformInclude[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PolicyRuleIdpDiscoveryPlatformIncludeOutputReference;
}
export interface PolicyRuleIdpDiscoveryUserIdentifierPatterns {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#match_type PolicyRuleIdpDiscovery#match_type}
    */
    readonly matchType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery#value PolicyRuleIdpDiscovery#value}
    */
    readonly value?: string;
}
export declare function policyRuleIdpDiscoveryUserIdentifierPatternsToTerraform(struct?: PolicyRuleIdpDiscoveryUserIdentifierPatterns | cdktf.IResolvable): any;
export declare class PolicyRuleIdpDiscoveryUserIdentifierPatternsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PolicyRuleIdpDiscoveryUserIdentifierPatterns | cdktf.IResolvable | undefined;
    set internalValue(value: PolicyRuleIdpDiscoveryUserIdentifierPatterns | cdktf.IResolvable | undefined);
    private _matchType?;
    get matchType(): string;
    set matchType(value: string);
    resetMatchType(): void;
    get matchTypeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class PolicyRuleIdpDiscoveryUserIdentifierPatternsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PolicyRuleIdpDiscoveryUserIdentifierPatterns[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PolicyRuleIdpDiscoveryUserIdentifierPatternsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery okta_policy_rule_idp_discovery}
*/
export declare class PolicyRuleIdpDiscovery extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_policy_rule_idp_discovery";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery okta_policy_rule_idp_discovery} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PolicyRuleIdpDiscoveryConfig
    */
    constructor(scope: Construct, id: string, config: PolicyRuleIdpDiscoveryConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _idpId?;
    get idpId(): string;
    set idpId(value: string);
    resetIdpId(): void;
    get idpIdInput(): string | undefined;
    private _idpType?;
    get idpType(): string;
    set idpType(value: string);
    resetIdpType(): void;
    get idpTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkConnection?;
    get networkConnection(): string;
    set networkConnection(value: string);
    resetNetworkConnection(): void;
    get networkConnectionInput(): string | undefined;
    private _networkExcludes?;
    get networkExcludes(): string[];
    set networkExcludes(value: string[]);
    resetNetworkExcludes(): void;
    get networkExcludesInput(): string[] | undefined;
    private _networkIncludes?;
    get networkIncludes(): string[];
    set networkIncludes(value: string[]);
    resetNetworkIncludes(): void;
    get networkIncludesInput(): string[] | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    resetPolicyId(): void;
    get policyIdInput(): string | undefined;
    private _policyid?;
    get policyid(): string;
    set policyid(value: string);
    resetPolicyid(): void;
    get policyidInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _userIdentifierAttribute?;
    get userIdentifierAttribute(): string;
    set userIdentifierAttribute(value: string);
    resetUserIdentifierAttribute(): void;
    get userIdentifierAttributeInput(): string | undefined;
    private _userIdentifierType?;
    get userIdentifierType(): string;
    set userIdentifierType(value: string);
    resetUserIdentifierType(): void;
    get userIdentifierTypeInput(): string | undefined;
    private _appExclude;
    get appExclude(): PolicyRuleIdpDiscoveryAppExcludeList;
    putAppExclude(value: PolicyRuleIdpDiscoveryAppExclude[] | cdktf.IResolvable): void;
    resetAppExclude(): void;
    get appExcludeInput(): cdktf.IResolvable | PolicyRuleIdpDiscoveryAppExclude[] | undefined;
    private _appInclude;
    get appInclude(): PolicyRuleIdpDiscoveryAppIncludeList;
    putAppInclude(value: PolicyRuleIdpDiscoveryAppInclude[] | cdktf.IResolvable): void;
    resetAppInclude(): void;
    get appIncludeInput(): cdktf.IResolvable | PolicyRuleIdpDiscoveryAppInclude[] | undefined;
    private _platformInclude;
    get platformInclude(): PolicyRuleIdpDiscoveryPlatformIncludeList;
    putPlatformInclude(value: PolicyRuleIdpDiscoveryPlatformInclude[] | cdktf.IResolvable): void;
    resetPlatformInclude(): void;
    get platformIncludeInput(): cdktf.IResolvable | PolicyRuleIdpDiscoveryPlatformInclude[] | undefined;
    private _userIdentifierPatterns;
    get userIdentifierPatterns(): PolicyRuleIdpDiscoveryUserIdentifierPatternsList;
    putUserIdentifierPatterns(value: PolicyRuleIdpDiscoveryUserIdentifierPatterns[] | cdktf.IResolvable): void;
    resetUserIdentifierPatterns(): void;
    get userIdentifierPatternsInput(): cdktf.IResolvable | PolicyRuleIdpDiscoveryUserIdentifierPatterns[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
