import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PolicyRulePasswordConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_password#id PolicyRulePassword#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Policy Rule Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_password#name PolicyRulePassword#name}
    */
    readonly name: string;
    /**
    * Network selection mode: ANYWHERE, ZONE, ON_NETWORK, or OFF_NETWORK.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_password#network_connection PolicyRulePassword#network_connection}
    */
    readonly networkConnection?: string;
    /**
    * The zones to exclude
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_password#network_excludes PolicyRulePassword#network_excludes}
    */
    readonly networkExcludes?: string[];
    /**
    * The zones to include
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_password#network_includes PolicyRulePassword#network_includes}
    */
    readonly networkIncludes?: string[];
    /**
    * Allow or deny a user to change their password: ALLOW or DENY. Default = ALLOW
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_password#password_change PolicyRulePassword#password_change}
    */
    readonly passwordChange?: string;
    /**
    * Allow or deny a user to reset their password: ALLOW or DENY. Default = ALLOW
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_password#password_reset PolicyRulePassword#password_reset}
    */
    readonly passwordReset?: string;
    /**
    * Allow or deny a user to unlock. Default = DENY
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_password#password_unlock PolicyRulePassword#password_unlock}
    */
    readonly passwordUnlock?: string;
    /**
    * Policy ID of the Rule
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_password#policy_id PolicyRulePassword#policy_id}
    */
    readonly policyId?: string;
    /**
    * Policy ID of the Rule
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_password#policyid PolicyRulePassword#policyid}
    */
    readonly policyid?: string;
    /**
    * Policy Rule Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_password#priority PolicyRulePassword#priority}
    */
    readonly priority?: number;
    /**
    * Policy Rule Status: ACTIVE or INACTIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_password#status PolicyRulePassword#status}
    */
    readonly status?: string;
    /**
    * Set of User IDs to Exclude
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_password#users_excluded PolicyRulePassword#users_excluded}
    */
    readonly usersExcluded?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_password okta_policy_rule_password}
*/
export declare class PolicyRulePassword extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_policy_rule_password";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_password okta_policy_rule_password} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PolicyRulePasswordConfig
    */
    constructor(scope: Construct, id: string, config: PolicyRulePasswordConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkConnection?;
    get networkConnection(): string;
    set networkConnection(value: string);
    resetNetworkConnection(): void;
    get networkConnectionInput(): string | undefined;
    private _networkExcludes?;
    get networkExcludes(): string[];
    set networkExcludes(value: string[]);
    resetNetworkExcludes(): void;
    get networkExcludesInput(): string[] | undefined;
    private _networkIncludes?;
    get networkIncludes(): string[];
    set networkIncludes(value: string[]);
    resetNetworkIncludes(): void;
    get networkIncludesInput(): string[] | undefined;
    private _passwordChange?;
    get passwordChange(): string;
    set passwordChange(value: string);
    resetPasswordChange(): void;
    get passwordChangeInput(): string | undefined;
    private _passwordReset?;
    get passwordReset(): string;
    set passwordReset(value: string);
    resetPasswordReset(): void;
    get passwordResetInput(): string | undefined;
    private _passwordUnlock?;
    get passwordUnlock(): string;
    set passwordUnlock(value: string);
    resetPasswordUnlock(): void;
    get passwordUnlockInput(): string | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    resetPolicyId(): void;
    get policyIdInput(): string | undefined;
    private _policyid?;
    get policyid(): string;
    set policyid(value: string);
    resetPolicyid(): void;
    get policyidInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _usersExcluded?;
    get usersExcluded(): string[];
    set usersExcluded(value: string[]);
    resetUsersExcluded(): void;
    get usersExcludedInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
