import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PolicyRuleProfileEnrollmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Allow or deny access based on the rule conditions: ALLOW or DENY
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment#access PolicyRuleProfileEnrollment#access}
    */
    readonly access?: string;
    /**
    * Indicates whether email verification should occur before access is granted
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment#email_verification PolicyRuleProfileEnrollment#email_verification}
    */
    readonly emailVerification?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment#id PolicyRuleProfileEnrollment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ID of a Registration Inline Hook
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment#inline_hook_id PolicyRuleProfileEnrollment#inline_hook_id}
    */
    readonly inlineHookId?: string;
    /**
    * ID of the policy
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment#policy_id PolicyRuleProfileEnrollment#policy_id}
    */
    readonly policyId: string;
    /**
    * The ID of a Group that this User should be added to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment#target_group_id PolicyRuleProfileEnrollment#target_group_id}
    */
    readonly targetGroupId?: string;
    /**
    * Which action should be taken if this User is new
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment#unknown_user_action PolicyRuleProfileEnrollment#unknown_user_action}
    */
    readonly unknownUserAction: string;
    /**
    * profile_attributes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment#profile_attributes PolicyRuleProfileEnrollment#profile_attributes}
    */
    readonly profileAttributes?: PolicyRuleProfileEnrollmentProfileAttributes[] | cdktf.IResolvable;
}
export interface PolicyRuleProfileEnrollmentProfileAttributes {
    /**
    * A display-friendly label for this property
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment#label PolicyRuleProfileEnrollment#label}
    */
    readonly label: string;
    /**
    * The name of a User Profile property
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment#name PolicyRuleProfileEnrollment#name}
    */
    readonly name: string;
    /**
    * Indicates if this property is required for enrollment
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment#required PolicyRuleProfileEnrollment#required}
    */
    readonly required?: boolean | cdktf.IResolvable;
}
export declare function policyRuleProfileEnrollmentProfileAttributesToTerraform(struct?: PolicyRuleProfileEnrollmentProfileAttributes | cdktf.IResolvable): any;
export declare class PolicyRuleProfileEnrollmentProfileAttributesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PolicyRuleProfileEnrollmentProfileAttributes | cdktf.IResolvable | undefined;
    set internalValue(value: PolicyRuleProfileEnrollmentProfileAttributes | cdktf.IResolvable | undefined);
    private _label?;
    get label(): string;
    set label(value: string);
    get labelInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _required?;
    get required(): boolean | cdktf.IResolvable;
    set required(value: boolean | cdktf.IResolvable);
    resetRequired(): void;
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class PolicyRuleProfileEnrollmentProfileAttributesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PolicyRuleProfileEnrollmentProfileAttributes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PolicyRuleProfileEnrollmentProfileAttributesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment okta_policy_rule_profile_enrollment}
*/
export declare class PolicyRuleProfileEnrollment extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_policy_rule_profile_enrollment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment okta_policy_rule_profile_enrollment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PolicyRuleProfileEnrollmentConfig
    */
    constructor(scope: Construct, id: string, config: PolicyRuleProfileEnrollmentConfig);
    private _access?;
    get access(): string;
    set access(value: string);
    resetAccess(): void;
    get accessInput(): string | undefined;
    private _emailVerification?;
    get emailVerification(): boolean | cdktf.IResolvable;
    set emailVerification(value: boolean | cdktf.IResolvable);
    resetEmailVerification(): void;
    get emailVerificationInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inlineHookId?;
    get inlineHookId(): string;
    set inlineHookId(value: string);
    resetInlineHookId(): void;
    get inlineHookIdInput(): string | undefined;
    get name(): string;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    get policyIdInput(): string | undefined;
    get status(): string;
    private _targetGroupId?;
    get targetGroupId(): string;
    set targetGroupId(value: string);
    resetTargetGroupId(): void;
    get targetGroupIdInput(): string | undefined;
    private _unknownUserAction?;
    get unknownUserAction(): string;
    set unknownUserAction(value: string);
    get unknownUserActionInput(): string | undefined;
    private _profileAttributes;
    get profileAttributes(): PolicyRuleProfileEnrollmentProfileAttributesList;
    putProfileAttributes(value: PolicyRuleProfileEnrollmentProfileAttributes[] | cdktf.IResolvable): void;
    resetProfileAttributes(): void;
    get profileAttributesInput(): cdktf.IResolvable | PolicyRuleProfileEnrollmentProfileAttributes[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
