import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PolicyRuleSignonConfig extends cdktf.TerraformMetaArguments {
    /**
    * Allow or deny access based on the rule conditions: ALLOW, DENY or CHALLENGE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#access PolicyRuleSignon#access}
    */
    readonly access?: string;
    /**
    * Authentication entrypoint: ANY, RADIUS or LDAP_INTERFACE
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#authtype PolicyRuleSignon#authtype}
    */
    readonly authtype?: string;
    /**
    * List of behavior IDs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#behaviors PolicyRuleSignon#behaviors}
    */
    readonly behaviors?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#id PolicyRuleSignon#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Apply rule based on the IdP used: ANY, OKTA or SPECIFIC_IDP.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#identity_provider PolicyRuleSignon#identity_provider}
    */
    readonly identityProvider?: string;
    /**
    * When identity_provider is SPECIFIC_IDP then this is the list of IdP IDs to apply the rule on
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#identity_provider_ids PolicyRuleSignon#identity_provider_ids}
    */
    readonly identityProviderIds?: string[];
    /**
    * Elapsed time before the next MFA challenge
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#mfa_lifetime PolicyRuleSignon#mfa_lifetime}
    */
    readonly mfaLifetime?: number;
    /**
    * Prompt for MFA based on the device used, a factor session lifetime, or every sign-on attempt: DEVICE, SESSION or ALWAYS
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#mfa_prompt PolicyRuleSignon#mfa_prompt}
    */
    readonly mfaPrompt?: string;
    /**
    * Remember MFA device.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#mfa_remember_device PolicyRuleSignon#mfa_remember_device}
    */
    readonly mfaRememberDevice?: boolean | cdktf.IResolvable;
    /**
    * Require MFA.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#mfa_required PolicyRuleSignon#mfa_required}
    */
    readonly mfaRequired?: boolean | cdktf.IResolvable;
    /**
    * Policy Rule Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#name PolicyRuleSignon#name}
    */
    readonly name: string;
    /**
    * Network selection mode: ANYWHERE, ZONE, ON_NETWORK, or OFF_NETWORK.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#network_connection PolicyRuleSignon#network_connection}
    */
    readonly networkConnection?: string;
    /**
    * The zones to exclude
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#network_excludes PolicyRuleSignon#network_excludes}
    */
    readonly networkExcludes?: string[];
    /**
    * The zones to include
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#network_includes PolicyRuleSignon#network_includes}
    */
    readonly networkIncludes?: string[];
    /**
    * Policy ID of the Rule
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#policy_id PolicyRuleSignon#policy_id}
    */
    readonly policyId?: string;
    /**
    * Policy ID of the Rule
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#policyid PolicyRuleSignon#policyid}
    */
    readonly policyid?: string;
    /**
    * Primary factor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#primary_factor PolicyRuleSignon#primary_factor}
    */
    readonly primaryFactor?: string;
    /**
    * Policy Rule Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#priority PolicyRuleSignon#priority}
    */
    readonly priority?: number;
    /**
    * Risc level: ANY, LOW, MEDIUM or HIGH
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#risc_level PolicyRuleSignon#risc_level}
    */
    readonly riscLevel?: string;
    /**
    * Max minutes a session can be idle.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#session_idle PolicyRuleSignon#session_idle}
    */
    readonly sessionIdle?: number;
    /**
    * Max minutes a session is active: Disable = 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#session_lifetime PolicyRuleSignon#session_lifetime}
    */
    readonly sessionLifetime?: number;
    /**
    * Whether session cookies will last across browser sessions. Okta Administrators can never have persistent session cookies.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#session_persistent PolicyRuleSignon#session_persistent}
    */
    readonly sessionPersistent?: boolean | cdktf.IResolvable;
    /**
    * Policy Rule Status: ACTIVE or INACTIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#status PolicyRuleSignon#status}
    */
    readonly status?: string;
    /**
    * Set of User IDs to Exclude
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#users_excluded PolicyRuleSignon#users_excluded}
    */
    readonly usersExcluded?: string[];
    /**
    * factor_sequence block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#factor_sequence PolicyRuleSignon#factor_sequence}
    */
    readonly factorSequence?: PolicyRuleSignonFactorSequence[] | cdktf.IResolvable;
}
export interface PolicyRuleSignonFactorSequenceSecondaryCriteria {
    /**
    * Type of a Factor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#factor_type PolicyRuleSignon#factor_type}
    */
    readonly factorType: string;
    /**
    * Factor provider
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#provider PolicyRuleSignon#provider}
    */
    readonly provider: string;
}
export declare function policyRuleSignonFactorSequenceSecondaryCriteriaToTerraform(struct?: PolicyRuleSignonFactorSequenceSecondaryCriteria | cdktf.IResolvable): any;
export declare class PolicyRuleSignonFactorSequenceSecondaryCriteriaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PolicyRuleSignonFactorSequenceSecondaryCriteria | cdktf.IResolvable | undefined;
    set internalValue(value: PolicyRuleSignonFactorSequenceSecondaryCriteria | cdktf.IResolvable | undefined);
    private _factorType?;
    get factorType(): string;
    set factorType(value: string);
    get factorTypeInput(): string | undefined;
    private _provider?;
    get provider(): string;
    set provider(value: string);
    get providerInput(): string | undefined;
}
export declare class PolicyRuleSignonFactorSequenceSecondaryCriteriaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PolicyRuleSignonFactorSequenceSecondaryCriteria[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PolicyRuleSignonFactorSequenceSecondaryCriteriaOutputReference;
}
export interface PolicyRuleSignonFactorSequence {
    /**
    * Type of a Factor
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#primary_criteria_factor_type PolicyRuleSignon#primary_criteria_factor_type}
    */
    readonly primaryCriteriaFactorType: string;
    /**
    * Factor provider
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#primary_criteria_provider PolicyRuleSignon#primary_criteria_provider}
    */
    readonly primaryCriteriaProvider: string;
    /**
    * secondary_criteria block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon#secondary_criteria PolicyRuleSignon#secondary_criteria}
    */
    readonly secondaryCriteria?: PolicyRuleSignonFactorSequenceSecondaryCriteria[] | cdktf.IResolvable;
}
export declare function policyRuleSignonFactorSequenceToTerraform(struct?: PolicyRuleSignonFactorSequence | cdktf.IResolvable): any;
export declare class PolicyRuleSignonFactorSequenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PolicyRuleSignonFactorSequence | cdktf.IResolvable | undefined;
    set internalValue(value: PolicyRuleSignonFactorSequence | cdktf.IResolvable | undefined);
    private _primaryCriteriaFactorType?;
    get primaryCriteriaFactorType(): string;
    set primaryCriteriaFactorType(value: string);
    get primaryCriteriaFactorTypeInput(): string | undefined;
    private _primaryCriteriaProvider?;
    get primaryCriteriaProvider(): string;
    set primaryCriteriaProvider(value: string);
    get primaryCriteriaProviderInput(): string | undefined;
    private _secondaryCriteria;
    get secondaryCriteria(): PolicyRuleSignonFactorSequenceSecondaryCriteriaList;
    putSecondaryCriteria(value: PolicyRuleSignonFactorSequenceSecondaryCriteria[] | cdktf.IResolvable): void;
    resetSecondaryCriteria(): void;
    get secondaryCriteriaInput(): cdktf.IResolvable | PolicyRuleSignonFactorSequenceSecondaryCriteria[] | undefined;
}
export declare class PolicyRuleSignonFactorSequenceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PolicyRuleSignonFactorSequence[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PolicyRuleSignonFactorSequenceOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon okta_policy_rule_signon}
*/
export declare class PolicyRuleSignon extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_policy_rule_signon";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_signon okta_policy_rule_signon} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PolicyRuleSignonConfig
    */
    constructor(scope: Construct, id: string, config: PolicyRuleSignonConfig);
    private _access?;
    get access(): string;
    set access(value: string);
    resetAccess(): void;
    get accessInput(): string | undefined;
    private _authtype?;
    get authtype(): string;
    set authtype(value: string);
    resetAuthtype(): void;
    get authtypeInput(): string | undefined;
    private _behaviors?;
    get behaviors(): string[];
    set behaviors(value: string[]);
    resetBehaviors(): void;
    get behaviorsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identityProvider?;
    get identityProvider(): string;
    set identityProvider(value: string);
    resetIdentityProvider(): void;
    get identityProviderInput(): string | undefined;
    private _identityProviderIds?;
    get identityProviderIds(): string[];
    set identityProviderIds(value: string[]);
    resetIdentityProviderIds(): void;
    get identityProviderIdsInput(): string[] | undefined;
    private _mfaLifetime?;
    get mfaLifetime(): number;
    set mfaLifetime(value: number);
    resetMfaLifetime(): void;
    get mfaLifetimeInput(): number | undefined;
    private _mfaPrompt?;
    get mfaPrompt(): string;
    set mfaPrompt(value: string);
    resetMfaPrompt(): void;
    get mfaPromptInput(): string | undefined;
    private _mfaRememberDevice?;
    get mfaRememberDevice(): boolean | cdktf.IResolvable;
    set mfaRememberDevice(value: boolean | cdktf.IResolvable);
    resetMfaRememberDevice(): void;
    get mfaRememberDeviceInput(): boolean | cdktf.IResolvable | undefined;
    private _mfaRequired?;
    get mfaRequired(): boolean | cdktf.IResolvable;
    set mfaRequired(value: boolean | cdktf.IResolvable);
    resetMfaRequired(): void;
    get mfaRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkConnection?;
    get networkConnection(): string;
    set networkConnection(value: string);
    resetNetworkConnection(): void;
    get networkConnectionInput(): string | undefined;
    private _networkExcludes?;
    get networkExcludes(): string[];
    set networkExcludes(value: string[]);
    resetNetworkExcludes(): void;
    get networkExcludesInput(): string[] | undefined;
    private _networkIncludes?;
    get networkIncludes(): string[];
    set networkIncludes(value: string[]);
    resetNetworkIncludes(): void;
    get networkIncludesInput(): string[] | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    resetPolicyId(): void;
    get policyIdInput(): string | undefined;
    private _policyid?;
    get policyid(): string;
    set policyid(value: string);
    resetPolicyid(): void;
    get policyidInput(): string | undefined;
    private _primaryFactor?;
    get primaryFactor(): string;
    set primaryFactor(value: string);
    resetPrimaryFactor(): void;
    get primaryFactorInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _riscLevel?;
    get riscLevel(): string;
    set riscLevel(value: string);
    resetRiscLevel(): void;
    get riscLevelInput(): string | undefined;
    private _sessionIdle?;
    get sessionIdle(): number;
    set sessionIdle(value: number);
    resetSessionIdle(): void;
    get sessionIdleInput(): number | undefined;
    private _sessionLifetime?;
    get sessionLifetime(): number;
    set sessionLifetime(value: number);
    resetSessionLifetime(): void;
    get sessionLifetimeInput(): number | undefined;
    private _sessionPersistent?;
    get sessionPersistent(): boolean | cdktf.IResolvable;
    set sessionPersistent(value: boolean | cdktf.IResolvable);
    resetSessionPersistent(): void;
    get sessionPersistentInput(): boolean | cdktf.IResolvable | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _usersExcluded?;
    get usersExcluded(): string[];
    set usersExcluded(value: string[]);
    resetUsersExcluded(): void;
    get usersExcludedInput(): string[] | undefined;
    private _factorSequence;
    get factorSequence(): PolicyRuleSignonFactorSequenceList;
    putFactorSequence(value: PolicyRuleSignonFactorSequence[] | cdktf.IResolvable): void;
    resetFactorSequence(): void;
    get factorSequenceInput(): cdktf.IResolvable | PolicyRuleSignonFactorSequence[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
