import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProfileMappingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether apply the changes to all users with this profile after updating or creating the these mappings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/profile_mapping#always_apply ProfileMapping#always_apply}
    */
    readonly alwaysApply?: boolean | cdktf.IResolvable;
    /**
    * When turned on this flag will trigger the provider to delete mapping properties that are not defined in config. By default, we do not delete missing properties.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/profile_mapping#delete_when_absent ProfileMapping#delete_when_absent}
    */
    readonly deleteWhenAbsent?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/profile_mapping#id ProfileMapping#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The source id of the mapping to manage.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/profile_mapping#source_id ProfileMapping#source_id}
    */
    readonly sourceId: string;
    /**
    * The target id of the mapping to manage.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/profile_mapping#target_id ProfileMapping#target_id}
    */
    readonly targetId: string;
    /**
    * mappings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/profile_mapping#mappings ProfileMapping#mappings}
    */
    readonly mappings?: ProfileMappingMappings[] | cdktf.IResolvable;
}
export interface ProfileMappingMappings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/profile_mapping#expression ProfileMapping#expression}
    */
    readonly expression: string;
    /**
    * The mapping property key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/profile_mapping#id ProfileMapping#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/profile_mapping#push_status ProfileMapping#push_status}
    */
    readonly pushStatus?: string;
}
export declare function profileMappingMappingsToTerraform(struct?: ProfileMappingMappings | cdktf.IResolvable): any;
export declare class ProfileMappingMappingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProfileMappingMappings | cdktf.IResolvable | undefined;
    set internalValue(value: ProfileMappingMappings | cdktf.IResolvable | undefined);
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _pushStatus?;
    get pushStatus(): string;
    set pushStatus(value: string);
    resetPushStatus(): void;
    get pushStatusInput(): string | undefined;
}
export declare class ProfileMappingMappingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ProfileMappingMappings[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProfileMappingMappingsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/profile_mapping okta_profile_mapping}
*/
export declare class ProfileMapping extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_profile_mapping";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/profile_mapping okta_profile_mapping} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProfileMappingConfig
    */
    constructor(scope: Construct, id: string, config: ProfileMappingConfig);
    private _alwaysApply?;
    get alwaysApply(): boolean | cdktf.IResolvable;
    set alwaysApply(value: boolean | cdktf.IResolvable);
    resetAlwaysApply(): void;
    get alwaysApplyInput(): boolean | cdktf.IResolvable | undefined;
    private _deleteWhenAbsent?;
    get deleteWhenAbsent(): boolean | cdktf.IResolvable;
    set deleteWhenAbsent(value: boolean | cdktf.IResolvable);
    resetDeleteWhenAbsent(): void;
    get deleteWhenAbsentInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _sourceId?;
    get sourceId(): string;
    set sourceId(value: string);
    get sourceIdInput(): string | undefined;
    get sourceName(): string;
    get sourceType(): string;
    private _targetId?;
    get targetId(): string;
    set targetId(value: string);
    get targetIdInput(): string | undefined;
    get targetName(): string;
    get targetType(): string;
    private _mappings;
    get mappings(): ProfileMappingMappingsList;
    putMappings(value: ProfileMappingMappings[] | cdktf.IResolvable): void;
    resetMappings(): void;
    get mappingsInput(): cdktf.IResolvable | ProfileMappingMappings[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
