import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RateLimitingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Called during authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/rate_limiting#authorize RateLimiting#authorize}
    */
    readonly authorize: string;
    /**
    * Enables rate limit warning, violation, notification emails and banners when this org meets rate limits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/rate_limiting#communications_enabled RateLimiting#communications_enabled}
    */
    readonly communicationsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/rate_limiting#id RateLimiting#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Called when accessing the Okta hosted login page.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/rate_limiting#login RateLimiting#login}
    */
    readonly login: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/rate_limiting okta_rate_limiting}
*/
export declare class RateLimiting extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_rate_limiting";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/rate_limiting okta_rate_limiting} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RateLimitingConfig
    */
    constructor(scope: Construct, id: string, config: RateLimitingConfig);
    private _authorize?;
    get authorize(): string;
    set authorize(value: string);
    get authorizeInput(): string | undefined;
    private _communicationsEnabled?;
    get communicationsEnabled(): boolean | cdktf.IResolvable;
    set communicationsEnabled(value: boolean | cdktf.IResolvable);
    resetCommunicationsEnabled(): void;
    get communicationsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _login?;
    get login(): string;
    set login(value: string);
    get loginInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
