import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ResourceSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * A description of the Resource Set
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/resource_set#description ResourceSet#description}
    */
    readonly description: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/resource_set#id ResourceSet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Unique name given to the Resource Set
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/resource_set#label ResourceSet#label}
    */
    readonly label: string;
    /**
    * The endpoints that reference the resources to be included in the new Resource Set
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/resource_set#resources ResourceSet#resources}
    */
    readonly resources?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/resource_set okta_resource_set}
*/
export declare class ResourceSet extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_resource_set";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/resource_set okta_resource_set} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourceSetConfig
    */
    constructor(scope: Construct, id: string, config: ResourceSetConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    get labelInput(): string | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
