import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RoleSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/role_subscription#id RoleSubscription#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Type of the notification
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/role_subscription#notification_type RoleSubscription#notification_type}
    */
    readonly notificationType: string;
    /**
    * Type of the role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/role_subscription#role_type RoleSubscription#role_type}
    */
    readonly roleType: string;
    /**
    * Status of subscription
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/role_subscription#status RoleSubscription#status}
    */
    readonly status?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/role_subscription okta_role_subscription}
*/
export declare class RoleSubscription extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_role_subscription";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/role_subscription okta_role_subscription} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RoleSubscriptionConfig
    */
    constructor(scope: Construct, id: string, config: RoleSubscriptionConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _notificationType?;
    get notificationType(): string;
    set notificationType(value: string);
    get notificationTypeInput(): string | undefined;
    private _roleType?;
    get roleType(): string;
    set roleType(value: string);
    get roleTypeInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
