import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SamlAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Custom error page URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#accessibility_error_redirect_url SamlApp#accessibility_error_redirect_url}
    */
    readonly accessibilityErrorRedirectUrl?: string;
    /**
    * Custom login page URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#accessibility_login_redirect_url SamlApp#accessibility_login_redirect_url}
    */
    readonly accessibilityLoginRedirectUrl?: string;
    /**
    * Enable self service
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#accessibility_self_service SamlApp#accessibility_self_service}
    */
    readonly accessibilitySelfService?: boolean | cdktf.IResolvable;
    /**
    * List of ACS endpoints for this SAML application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#acs_endpoints SamlApp#acs_endpoints}
    */
    readonly acsEndpoints?: string[];
    /**
    * Application notes for admins.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#admin_note SamlApp#admin_note}
    */
    readonly adminNote?: string;
    /**
    * Displays specific appLinks for the app
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#app_links_json SamlApp#app_links_json}
    */
    readonly appLinksJson?: string;
    /**
    * Application settings in JSON format
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#app_settings_json SamlApp#app_settings_json}
    */
    readonly appSettingsJson?: string;
    /**
    * Determines whether the SAML assertion is digitally signed
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#assertion_signed SamlApp#assertion_signed}
    */
    readonly assertionSigned?: boolean | cdktf.IResolvable;
    /**
    * Audience Restriction
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#audience SamlApp#audience}
    */
    readonly audience?: string;
    /**
    * Id of this apps authentication policy
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#authentication_policy SamlApp#authentication_policy}
    */
    readonly authenticationPolicy?: string;
    /**
    * Identifies the SAML authentication context class for the assertion’s authentication statement
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#authn_context_class_ref SamlApp#authn_context_class_ref}
    */
    readonly authnContextClassRef?: string;
    /**
    * Display auto submit toolbar
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#auto_submit_toolbar SamlApp#auto_submit_toolbar}
    */
    readonly autoSubmitToolbar?: boolean | cdktf.IResolvable;
    /**
    * Identifies a specific application resource in an IDP initiated SSO scenario.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#default_relay_state SamlApp#default_relay_state}
    */
    readonly defaultRelayState?: string;
    /**
    * Identifies the location where the SAML response is intended to be sent inside of the SAML assertion
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#destination SamlApp#destination}
    */
    readonly destination?: string;
    /**
    * Determines the digest algorithm used to digitally sign the SAML assertion and response
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#digest_algorithm SamlApp#digest_algorithm}
    */
    readonly digestAlgorithm?: string;
    /**
    * Application notes for end users.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#enduser_note SamlApp#enduser_note}
    */
    readonly enduserNote?: string;
    /**
    * features to enable
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#features SamlApp#features}
    */
    readonly features?: string[];
    /**
    * Groups associated with the application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#groups SamlApp#groups}
    */
    readonly groups?: string[];
    /**
    * Do not display application icon on mobile app
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#hide_ios SamlApp#hide_ios}
    */
    readonly hideIos?: boolean | cdktf.IResolvable;
    /**
    * Do not display application icon to users
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#hide_web SamlApp#hide_web}
    */
    readonly hideWeb?: boolean | cdktf.IResolvable;
    /**
    * Prompt user to re-authenticate if SP asks for it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#honor_force_authn SamlApp#honor_force_authn}
    */
    readonly honorForceAuthn?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#id SamlApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * SAML issuer ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#idp_issuer SamlApp#idp_issuer}
    */
    readonly idpIssuer?: string;
    /**
    * *Early Access Property*. Enable Federation Broker Mode.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#implicit_assignment SamlApp#implicit_assignment}
    */
    readonly implicitAssignment?: boolean | cdktf.IResolvable;
    /**
    * Saml Inline Hook setting
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#inline_hook_id SamlApp#inline_hook_id}
    */
    readonly inlineHookId?: string;
    /**
    * Certificate name. This modulates the rotation of keys. New name == new key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#key_name SamlApp#key_name}
    */
    readonly keyName?: string;
    /**
    * Number of years the certificate is valid.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#key_years_valid SamlApp#key_years_valid}
    */
    readonly keyYearsValid?: number;
    /**
    * Pretty name of app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#label SamlApp#label}
    */
    readonly label: string;
    /**
    * Local path to logo of the application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#logo SamlApp#logo}
    */
    readonly logo?: string;
    /**
    * Name of preexisting SAML application. For instance 'slack'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#preconfigured_app SamlApp#preconfigured_app}
    */
    readonly preconfiguredApp?: string;
    /**
    * The location where the app may present the SAML assertion
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#recipient SamlApp#recipient}
    */
    readonly recipient?: string;
    /**
    * Denotes whether the request is compressed or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#request_compressed SamlApp#request_compressed}
    */
    readonly requestCompressed?: boolean | cdktf.IResolvable;
    /**
    * Determines whether the SAML auth response message is digitally signed
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#response_signed SamlApp#response_signed}
    */
    readonly responseSigned?: boolean | cdktf.IResolvable;
    /**
    * SAML version for the app's sign-on mode
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#saml_version SamlApp#saml_version}
    */
    readonly samlVersion?: string;
    /**
    * Signature algorithm used ot digitally sign the assertion and response
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#signature_algorithm SamlApp#signature_algorithm}
    */
    readonly signatureAlgorithm?: string;
    /**
    * x509 encoded certificate that the Service Provider uses to sign Single Logout requests
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#single_logout_certificate SamlApp#single_logout_certificate}
    */
    readonly singleLogoutCertificate?: string;
    /**
    * The issuer of the Service Provider that generates the Single Logout request
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#single_logout_issuer SamlApp#single_logout_issuer}
    */
    readonly singleLogoutIssuer?: string;
    /**
    * The location where the logout response is sent
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#single_logout_url SamlApp#single_logout_url}
    */
    readonly singleLogoutUrl?: string;
    /**
    * Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#skip_groups SamlApp#skip_groups}
    */
    readonly skipGroups?: boolean | cdktf.IResolvable;
    /**
    * Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#skip_users SamlApp#skip_users}
    */
    readonly skipUsers?: boolean | cdktf.IResolvable;
    /**
    * SAML SP issuer ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#sp_issuer SamlApp#sp_issuer}
    */
    readonly spIssuer?: string;
    /**
    * Single Sign On URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#sso_url SamlApp#sso_url}
    */
    readonly ssoUrl?: string;
    /**
    * Status of application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#status SamlApp#status}
    */
    readonly status?: string;
    /**
    * Identifies the SAML processing rules.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#subject_name_id_format SamlApp#subject_name_id_format}
    */
    readonly subjectNameIdFormat?: string;
    /**
    * Template for app user's username when a user is assigned to the app
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#subject_name_id_template SamlApp#subject_name_id_template}
    */
    readonly subjectNameIdTemplate?: string;
    /**
    * Username template
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#user_name_template SamlApp#user_name_template}
    */
    readonly userNameTemplate?: string;
    /**
    * Push username on update
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#user_name_template_push_status SamlApp#user_name_template_push_status}
    */
    readonly userNameTemplatePushStatus?: string;
    /**
    * Username template suffix
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#user_name_template_suffix SamlApp#user_name_template_suffix}
    */
    readonly userNameTemplateSuffix?: string;
    /**
    * Username template type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#user_name_template_type SamlApp#user_name_template_type}
    */
    readonly userNameTemplateType?: string;
    /**
    * attribute_statements block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#attribute_statements SamlApp#attribute_statements}
    */
    readonly attributeStatements?: SamlAppAttributeStatements[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#timeouts SamlApp#timeouts}
    */
    readonly timeouts?: SamlAppTimeouts;
    /**
    * users block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#users SamlApp#users}
    */
    readonly users?: SamlAppUsers[] | cdktf.IResolvable;
}
export interface SamlAppKeys {
}
export declare function samlAppKeysToTerraform(struct?: SamlAppKeys): any;
export declare class SamlAppKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SamlAppKeys | undefined;
    set internalValue(value: SamlAppKeys | undefined);
    get created(): string;
    get e(): string;
    get expiresAt(): string;
    get kid(): string;
    get kty(): string;
    get lastUpdated(): string;
    get n(): string;
    get use(): string;
    get x5C(): string[];
    get x5TS256(): string;
}
export declare class SamlAppKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SamlAppKeysOutputReference;
}
export interface SamlAppAttributeStatements {
    /**
    * Type of group attribute filter
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#filter_type SamlApp#filter_type}
    */
    readonly filterType?: string;
    /**
    * Filter value to use
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#filter_value SamlApp#filter_value}
    */
    readonly filterValue?: string;
    /**
    * The reference name of the attribute statement
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#name SamlApp#name}
    */
    readonly name: string;
    /**
    * The name format of the attribute
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#namespace SamlApp#namespace}
    */
    readonly namespace?: string;
    /**
    * The type of attribute statements object
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#type SamlApp#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#values SamlApp#values}
    */
    readonly values?: string[];
}
export declare function samlAppAttributeStatementsToTerraform(struct?: SamlAppAttributeStatements | cdktf.IResolvable): any;
export declare class SamlAppAttributeStatementsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SamlAppAttributeStatements | cdktf.IResolvable | undefined;
    set internalValue(value: SamlAppAttributeStatements | cdktf.IResolvable | undefined);
    private _filterType?;
    get filterType(): string;
    set filterType(value: string);
    resetFilterType(): void;
    get filterTypeInput(): string | undefined;
    private _filterValue?;
    get filterValue(): string;
    set filterValue(value: string);
    resetFilterValue(): void;
    get filterValueInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class SamlAppAttributeStatementsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SamlAppAttributeStatements[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SamlAppAttributeStatementsOutputReference;
}
export interface SamlAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#create SamlApp#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#read SamlApp#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#update SamlApp#update}
    */
    readonly update?: string;
}
export declare function samlAppTimeoutsToTerraform(struct?: SamlAppTimeoutsOutputReference | SamlAppTimeouts | cdktf.IResolvable): any;
export declare class SamlAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SamlAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SamlAppTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface SamlAppUsers {
    /**
    * User ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#id SamlApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Password for user application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#password SamlApp#password}
    */
    readonly password?: string;
    /**
    * Username for user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_app#username SamlApp#username}
    */
    readonly username?: string;
}
export declare function samlAppUsersToTerraform(struct?: SamlAppUsers | cdktf.IResolvable): any;
export declare class SamlAppUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SamlAppUsers | cdktf.IResolvable | undefined;
    set internalValue(value: SamlAppUsers | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    get scope(): string;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export declare class SamlAppUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SamlAppUsers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SamlAppUsersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/saml_app okta_saml_app}
*/
export declare class SamlApp extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_saml_app";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/saml_app okta_saml_app} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SamlAppConfig
    */
    constructor(scope: Construct, id: string, config: SamlAppConfig);
    private _accessibilityErrorRedirectUrl?;
    get accessibilityErrorRedirectUrl(): string;
    set accessibilityErrorRedirectUrl(value: string);
    resetAccessibilityErrorRedirectUrl(): void;
    get accessibilityErrorRedirectUrlInput(): string | undefined;
    private _accessibilityLoginRedirectUrl?;
    get accessibilityLoginRedirectUrl(): string;
    set accessibilityLoginRedirectUrl(value: string);
    resetAccessibilityLoginRedirectUrl(): void;
    get accessibilityLoginRedirectUrlInput(): string | undefined;
    private _accessibilitySelfService?;
    get accessibilitySelfService(): boolean | cdktf.IResolvable;
    set accessibilitySelfService(value: boolean | cdktf.IResolvable);
    resetAccessibilitySelfService(): void;
    get accessibilitySelfServiceInput(): boolean | cdktf.IResolvable | undefined;
    private _acsEndpoints?;
    get acsEndpoints(): string[];
    set acsEndpoints(value: string[]);
    resetAcsEndpoints(): void;
    get acsEndpointsInput(): string[] | undefined;
    private _adminNote?;
    get adminNote(): string;
    set adminNote(value: string);
    resetAdminNote(): void;
    get adminNoteInput(): string | undefined;
    private _appLinksJson?;
    get appLinksJson(): string;
    set appLinksJson(value: string);
    resetAppLinksJson(): void;
    get appLinksJsonInput(): string | undefined;
    private _appSettingsJson?;
    get appSettingsJson(): string;
    set appSettingsJson(value: string);
    resetAppSettingsJson(): void;
    get appSettingsJsonInput(): string | undefined;
    private _assertionSigned?;
    get assertionSigned(): boolean | cdktf.IResolvable;
    set assertionSigned(value: boolean | cdktf.IResolvable);
    resetAssertionSigned(): void;
    get assertionSignedInput(): boolean | cdktf.IResolvable | undefined;
    private _audience?;
    get audience(): string;
    set audience(value: string);
    resetAudience(): void;
    get audienceInput(): string | undefined;
    private _authenticationPolicy?;
    get authenticationPolicy(): string;
    set authenticationPolicy(value: string);
    resetAuthenticationPolicy(): void;
    get authenticationPolicyInput(): string | undefined;
    private _authnContextClassRef?;
    get authnContextClassRef(): string;
    set authnContextClassRef(value: string);
    resetAuthnContextClassRef(): void;
    get authnContextClassRefInput(): string | undefined;
    private _autoSubmitToolbar?;
    get autoSubmitToolbar(): boolean | cdktf.IResolvable;
    set autoSubmitToolbar(value: boolean | cdktf.IResolvable);
    resetAutoSubmitToolbar(): void;
    get autoSubmitToolbarInput(): boolean | cdktf.IResolvable | undefined;
    get certificate(): string;
    private _defaultRelayState?;
    get defaultRelayState(): string;
    set defaultRelayState(value: string);
    resetDefaultRelayState(): void;
    get defaultRelayStateInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    resetDestination(): void;
    get destinationInput(): string | undefined;
    private _digestAlgorithm?;
    get digestAlgorithm(): string;
    set digestAlgorithm(value: string);
    resetDigestAlgorithm(): void;
    get digestAlgorithmInput(): string | undefined;
    get embedUrl(): string;
    private _enduserNote?;
    get enduserNote(): string;
    set enduserNote(value: string);
    resetEnduserNote(): void;
    get enduserNoteInput(): string | undefined;
    get entityKey(): string;
    get entityUrl(): string;
    private _features?;
    get features(): string[];
    set features(value: string[]);
    resetFeatures(): void;
    get featuresInput(): string[] | undefined;
    private _groups?;
    get groups(): string[];
    set groups(value: string[]);
    resetGroups(): void;
    get groupsInput(): string[] | undefined;
    private _hideIos?;
    get hideIos(): boolean | cdktf.IResolvable;
    set hideIos(value: boolean | cdktf.IResolvable);
    resetHideIos(): void;
    get hideIosInput(): boolean | cdktf.IResolvable | undefined;
    private _hideWeb?;
    get hideWeb(): boolean | cdktf.IResolvable;
    set hideWeb(value: boolean | cdktf.IResolvable);
    resetHideWeb(): void;
    get hideWebInput(): boolean | cdktf.IResolvable | undefined;
    private _honorForceAuthn?;
    get honorForceAuthn(): boolean | cdktf.IResolvable;
    set honorForceAuthn(value: boolean | cdktf.IResolvable);
    resetHonorForceAuthn(): void;
    get honorForceAuthnInput(): boolean | cdktf.IResolvable | undefined;
    get httpPostBinding(): string;
    get httpRedirectBinding(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _idpIssuer?;
    get idpIssuer(): string;
    set idpIssuer(value: string);
    resetIdpIssuer(): void;
    get idpIssuerInput(): string | undefined;
    private _implicitAssignment?;
    get implicitAssignment(): boolean | cdktf.IResolvable;
    set implicitAssignment(value: boolean | cdktf.IResolvable);
    resetImplicitAssignment(): void;
    get implicitAssignmentInput(): boolean | cdktf.IResolvable | undefined;
    private _inlineHookId?;
    get inlineHookId(): string;
    set inlineHookId(value: string);
    resetInlineHookId(): void;
    get inlineHookIdInput(): string | undefined;
    get keyId(): string;
    private _keyName?;
    get keyName(): string;
    set keyName(value: string);
    resetKeyName(): void;
    get keyNameInput(): string | undefined;
    private _keyYearsValid?;
    get keyYearsValid(): number;
    set keyYearsValid(value: number);
    resetKeyYearsValid(): void;
    get keyYearsValidInput(): number | undefined;
    private _keys;
    get keys(): SamlAppKeysList;
    private _label?;
    get label(): string;
    set label(value: string);
    get labelInput(): string | undefined;
    private _logo?;
    get logo(): string;
    set logo(value: string);
    resetLogo(): void;
    get logoInput(): string | undefined;
    get logoUrl(): string;
    get metadata(): string;
    get metadataUrl(): string;
    get name(): string;
    private _preconfiguredApp?;
    get preconfiguredApp(): string;
    set preconfiguredApp(value: string);
    resetPreconfiguredApp(): void;
    get preconfiguredAppInput(): string | undefined;
    private _recipient?;
    get recipient(): string;
    set recipient(value: string);
    resetRecipient(): void;
    get recipientInput(): string | undefined;
    private _requestCompressed?;
    get requestCompressed(): boolean | cdktf.IResolvable;
    set requestCompressed(value: boolean | cdktf.IResolvable);
    resetRequestCompressed(): void;
    get requestCompressedInput(): boolean | cdktf.IResolvable | undefined;
    private _responseSigned?;
    get responseSigned(): boolean | cdktf.IResolvable;
    set responseSigned(value: boolean | cdktf.IResolvable);
    resetResponseSigned(): void;
    get responseSignedInput(): boolean | cdktf.IResolvable | undefined;
    private _samlVersion?;
    get samlVersion(): string;
    set samlVersion(value: string);
    resetSamlVersion(): void;
    get samlVersionInput(): string | undefined;
    get signOnMode(): string;
    private _signatureAlgorithm?;
    get signatureAlgorithm(): string;
    set signatureAlgorithm(value: string);
    resetSignatureAlgorithm(): void;
    get signatureAlgorithmInput(): string | undefined;
    private _singleLogoutCertificate?;
    get singleLogoutCertificate(): string;
    set singleLogoutCertificate(value: string);
    resetSingleLogoutCertificate(): void;
    get singleLogoutCertificateInput(): string | undefined;
    private _singleLogoutIssuer?;
    get singleLogoutIssuer(): string;
    set singleLogoutIssuer(value: string);
    resetSingleLogoutIssuer(): void;
    get singleLogoutIssuerInput(): string | undefined;
    private _singleLogoutUrl?;
    get singleLogoutUrl(): string;
    set singleLogoutUrl(value: string);
    resetSingleLogoutUrl(): void;
    get singleLogoutUrlInput(): string | undefined;
    private _skipGroups?;
    get skipGroups(): boolean | cdktf.IResolvable;
    set skipGroups(value: boolean | cdktf.IResolvable);
    resetSkipGroups(): void;
    get skipGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _skipUsers?;
    get skipUsers(): boolean | cdktf.IResolvable;
    set skipUsers(value: boolean | cdktf.IResolvable);
    resetSkipUsers(): void;
    get skipUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _spIssuer?;
    get spIssuer(): string;
    set spIssuer(value: string);
    resetSpIssuer(): void;
    get spIssuerInput(): string | undefined;
    private _ssoUrl?;
    get ssoUrl(): string;
    set ssoUrl(value: string);
    resetSsoUrl(): void;
    get ssoUrlInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _subjectNameIdFormat?;
    get subjectNameIdFormat(): string;
    set subjectNameIdFormat(value: string);
    resetSubjectNameIdFormat(): void;
    get subjectNameIdFormatInput(): string | undefined;
    private _subjectNameIdTemplate?;
    get subjectNameIdTemplate(): string;
    set subjectNameIdTemplate(value: string);
    resetSubjectNameIdTemplate(): void;
    get subjectNameIdTemplateInput(): string | undefined;
    private _userNameTemplate?;
    get userNameTemplate(): string;
    set userNameTemplate(value: string);
    resetUserNameTemplate(): void;
    get userNameTemplateInput(): string | undefined;
    private _userNameTemplatePushStatus?;
    get userNameTemplatePushStatus(): string;
    set userNameTemplatePushStatus(value: string);
    resetUserNameTemplatePushStatus(): void;
    get userNameTemplatePushStatusInput(): string | undefined;
    private _userNameTemplateSuffix?;
    get userNameTemplateSuffix(): string;
    set userNameTemplateSuffix(value: string);
    resetUserNameTemplateSuffix(): void;
    get userNameTemplateSuffixInput(): string | undefined;
    private _userNameTemplateType?;
    get userNameTemplateType(): string;
    set userNameTemplateType(value: string);
    resetUserNameTemplateType(): void;
    get userNameTemplateTypeInput(): string | undefined;
    private _attributeStatements;
    get attributeStatements(): SamlAppAttributeStatementsList;
    putAttributeStatements(value: SamlAppAttributeStatements[] | cdktf.IResolvable): void;
    resetAttributeStatements(): void;
    get attributeStatementsInput(): cdktf.IResolvable | SamlAppAttributeStatements[] | undefined;
    private _timeouts;
    get timeouts(): SamlAppTimeoutsOutputReference;
    putTimeouts(value: SamlAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SamlAppTimeouts | undefined;
    private _users;
    get users(): SamlAppUsersList;
    putUsers(value: SamlAppUsers[] | cdktf.IResolvable): void;
    resetUsers(): void;
    get usersInput(): cdktf.IResolvable | SamlAppUsers[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
