import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SamlIdpSigningKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp_signing_key#id SamlIdpSigningKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * base64-encoded X.509 certificate chain with DER encoding
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp_signing_key#x5c SamlIdpSigningKey#x5c}
    */
    readonly x5C: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/saml_idp_signing_key okta_saml_idp_signing_key}
*/
export declare class SamlIdpSigningKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_saml_idp_signing_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/saml_idp_signing_key okta_saml_idp_signing_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SamlIdpSigningKeyConfig
    */
    constructor(scope: Construct, id: string, config: SamlIdpSigningKeyConfig);
    get created(): string;
    get expiresAt(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kid(): string;
    get kty(): string;
    get use(): string;
    private _x5C?;
    get x5C(): string[];
    set x5C(value: string[]);
    get x5CInput(): string[] | undefined;
    get x5TS256(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
