import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SamlIdpConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#account_link_action SamlIdp#account_link_action}
    */
    readonly accountLinkAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#account_link_group_include SamlIdp#account_link_group_include}
    */
    readonly accountLinkGroupInclude?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#acs_binding SamlIdp#acs_binding}
    */
    readonly acsBinding?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#acs_type SamlIdp#acs_type}
    */
    readonly acsType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#deprovisioned_action SamlIdp#deprovisioned_action}
    */
    readonly deprovisionedAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#groups_action SamlIdp#groups_action}
    */
    readonly groupsAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#groups_assignment SamlIdp#groups_assignment}
    */
    readonly groupsAssignment?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#groups_attribute SamlIdp#groups_attribute}
    */
    readonly groupsAttribute?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#groups_filter SamlIdp#groups_filter}
    */
    readonly groupsFilter?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#id SamlIdp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#issuer SamlIdp#issuer}
    */
    readonly issuer: string;
    /**
    * Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#issuer_mode SamlIdp#issuer_mode}
    */
    readonly issuerMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#kid SamlIdp#kid}
    */
    readonly kid: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#max_clock_skew SamlIdp#max_clock_skew}
    */
    readonly maxClockSkew?: number;
    /**
    * Name of the IdP
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#name SamlIdp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#name_format SamlIdp#name_format}
    */
    readonly nameFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#profile_master SamlIdp#profile_master}
    */
    readonly profileMaster?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#provisioning_action SamlIdp#provisioning_action}
    */
    readonly provisioningAction?: string;
    /**
    * The XML digital Signature Algorithm used when signing an <AuthnRequest> message
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#request_signature_algorithm SamlIdp#request_signature_algorithm}
    */
    readonly requestSignatureAlgorithm?: string;
    /**
    * Specifies whether to digitally sign <AuthnRequest> messages to the IdP
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#request_signature_scope SamlIdp#request_signature_scope}
    */
    readonly requestSignatureScope?: string;
    /**
    * The minimum XML digital Signature Algorithm allowed when verifying a <SAMLResponse> message or <Assertion> element
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#response_signature_algorithm SamlIdp#response_signature_algorithm}
    */
    readonly responseSignatureAlgorithm?: string;
    /**
    * Specifies whether to verify a <SAMLResponse> message or <Assertion> element XML digital signature
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#response_signature_scope SamlIdp#response_signature_scope}
    */
    readonly responseSignatureScope?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#sso_binding SamlIdp#sso_binding}
    */
    readonly ssoBinding?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#sso_destination SamlIdp#sso_destination}
    */
    readonly ssoDestination?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#sso_url SamlIdp#sso_url}
    */
    readonly ssoUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#status SamlIdp#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#subject_filter SamlIdp#subject_filter}
    */
    readonly subjectFilter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#subject_format SamlIdp#subject_format}
    */
    readonly subjectFormat?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#subject_match_attribute SamlIdp#subject_match_attribute}
    */
    readonly subjectMatchAttribute?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#subject_match_type SamlIdp#subject_match_type}
    */
    readonly subjectMatchType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#suspended_action SamlIdp#suspended_action}
    */
    readonly suspendedAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp#username_template SamlIdp#username_template}
    */
    readonly usernameTemplate?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/saml_idp okta_saml_idp}
*/
export declare class SamlIdp extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_saml_idp";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/saml_idp okta_saml_idp} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SamlIdpConfig
    */
    constructor(scope: Construct, id: string, config: SamlIdpConfig);
    private _accountLinkAction?;
    get accountLinkAction(): string;
    set accountLinkAction(value: string);
    resetAccountLinkAction(): void;
    get accountLinkActionInput(): string | undefined;
    private _accountLinkGroupInclude?;
    get accountLinkGroupInclude(): string[];
    set accountLinkGroupInclude(value: string[]);
    resetAccountLinkGroupInclude(): void;
    get accountLinkGroupIncludeInput(): string[] | undefined;
    private _acsBinding?;
    get acsBinding(): string;
    set acsBinding(value: string);
    resetAcsBinding(): void;
    get acsBindingInput(): string | undefined;
    private _acsType?;
    get acsType(): string;
    set acsType(value: string);
    resetAcsType(): void;
    get acsTypeInput(): string | undefined;
    get audience(): string;
    private _deprovisionedAction?;
    get deprovisionedAction(): string;
    set deprovisionedAction(value: string);
    resetDeprovisionedAction(): void;
    get deprovisionedActionInput(): string | undefined;
    private _groupsAction?;
    get groupsAction(): string;
    set groupsAction(value: string);
    resetGroupsAction(): void;
    get groupsActionInput(): string | undefined;
    private _groupsAssignment?;
    get groupsAssignment(): string[];
    set groupsAssignment(value: string[]);
    resetGroupsAssignment(): void;
    get groupsAssignmentInput(): string[] | undefined;
    private _groupsAttribute?;
    get groupsAttribute(): string;
    set groupsAttribute(value: string);
    resetGroupsAttribute(): void;
    get groupsAttributeInput(): string | undefined;
    private _groupsFilter?;
    get groupsFilter(): string[];
    set groupsFilter(value: string[]);
    resetGroupsFilter(): void;
    get groupsFilterInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    get issuerInput(): string | undefined;
    private _issuerMode?;
    get issuerMode(): string;
    set issuerMode(value: string);
    resetIssuerMode(): void;
    get issuerModeInput(): string | undefined;
    private _kid?;
    get kid(): string;
    set kid(value: string);
    get kidInput(): string | undefined;
    private _maxClockSkew?;
    get maxClockSkew(): number;
    set maxClockSkew(value: number);
    resetMaxClockSkew(): void;
    get maxClockSkewInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nameFormat?;
    get nameFormat(): string;
    set nameFormat(value: string);
    resetNameFormat(): void;
    get nameFormatInput(): string | undefined;
    private _profileMaster?;
    get profileMaster(): boolean | cdktf.IResolvable;
    set profileMaster(value: boolean | cdktf.IResolvable);
    resetProfileMaster(): void;
    get profileMasterInput(): boolean | cdktf.IResolvable | undefined;
    private _provisioningAction?;
    get provisioningAction(): string;
    set provisioningAction(value: string);
    resetProvisioningAction(): void;
    get provisioningActionInput(): string | undefined;
    private _requestSignatureAlgorithm?;
    get requestSignatureAlgorithm(): string;
    set requestSignatureAlgorithm(value: string);
    resetRequestSignatureAlgorithm(): void;
    get requestSignatureAlgorithmInput(): string | undefined;
    private _requestSignatureScope?;
    get requestSignatureScope(): string;
    set requestSignatureScope(value: string);
    resetRequestSignatureScope(): void;
    get requestSignatureScopeInput(): string | undefined;
    private _responseSignatureAlgorithm?;
    get responseSignatureAlgorithm(): string;
    set responseSignatureAlgorithm(value: string);
    resetResponseSignatureAlgorithm(): void;
    get responseSignatureAlgorithmInput(): string | undefined;
    private _responseSignatureScope?;
    get responseSignatureScope(): string;
    set responseSignatureScope(value: string);
    resetResponseSignatureScope(): void;
    get responseSignatureScopeInput(): string | undefined;
    private _ssoBinding?;
    get ssoBinding(): string;
    set ssoBinding(value: string);
    resetSsoBinding(): void;
    get ssoBindingInput(): string | undefined;
    private _ssoDestination?;
    get ssoDestination(): string;
    set ssoDestination(value: string);
    resetSsoDestination(): void;
    get ssoDestinationInput(): string | undefined;
    private _ssoUrl?;
    get ssoUrl(): string;
    set ssoUrl(value: string);
    get ssoUrlInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _subjectFilter?;
    get subjectFilter(): string;
    set subjectFilter(value: string);
    resetSubjectFilter(): void;
    get subjectFilterInput(): string | undefined;
    private _subjectFormat?;
    get subjectFormat(): string[];
    set subjectFormat(value: string[]);
    resetSubjectFormat(): void;
    get subjectFormatInput(): string[] | undefined;
    private _subjectMatchAttribute?;
    get subjectMatchAttribute(): string;
    set subjectMatchAttribute(value: string);
    resetSubjectMatchAttribute(): void;
    get subjectMatchAttributeInput(): string | undefined;
    private _subjectMatchType?;
    get subjectMatchType(): string;
    set subjectMatchType(value: string);
    resetSubjectMatchType(): void;
    get subjectMatchTypeInput(): string | undefined;
    private _suspendedAction?;
    get suspendedAction(): string;
    set suspendedAction(value: string);
    resetSuspendedAction(): void;
    get suspendedActionInput(): string | undefined;
    get type(): string;
    get userTypeId(): string;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
