import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecurePasswordStoreAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Custom error page URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#accessibility_error_redirect_url SecurePasswordStoreApp#accessibility_error_redirect_url}
    */
    readonly accessibilityErrorRedirectUrl?: string;
    /**
    * Custom login page URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#accessibility_login_redirect_url SecurePasswordStoreApp#accessibility_login_redirect_url}
    */
    readonly accessibilityLoginRedirectUrl?: string;
    /**
    * Enable self service
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#accessibility_self_service SecurePasswordStoreApp#accessibility_self_service}
    */
    readonly accessibilitySelfService?: boolean | cdktf.IResolvable;
    /**
    * Application notes for admins.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#admin_note SecurePasswordStoreApp#admin_note}
    */
    readonly adminNote?: string;
    /**
    * Displays specific appLinks for the app
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#app_links_json SecurePasswordStoreApp#app_links_json}
    */
    readonly appLinksJson?: string;
    /**
    * Display auto submit toolbar
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#auto_submit_toolbar SecurePasswordStoreApp#auto_submit_toolbar}
    */
    readonly autoSubmitToolbar?: boolean | cdktf.IResolvable;
    /**
    * Application credentials scheme
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#credentials_scheme SecurePasswordStoreApp#credentials_scheme}
    */
    readonly credentialsScheme?: string;
    /**
    * Application notes for end users.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#enduser_note SecurePasswordStoreApp#enduser_note}
    */
    readonly enduserNote?: string;
    /**
    * Groups associated with the application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#groups SecurePasswordStoreApp#groups}
    */
    readonly groups?: string[];
    /**
    * Do not display application icon on mobile app
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#hide_ios SecurePasswordStoreApp#hide_ios}
    */
    readonly hideIos?: boolean | cdktf.IResolvable;
    /**
    * Do not display application icon to users
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#hide_web SecurePasswordStoreApp#hide_web}
    */
    readonly hideWeb?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#id SecurePasswordStoreApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Pretty name of app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#label SecurePasswordStoreApp#label}
    */
    readonly label: string;
    /**
    * Local path to logo of the application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#logo SecurePasswordStoreApp#logo}
    */
    readonly logo?: string;
    /**
    * Name of optional param in the login form
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#optional_field1 SecurePasswordStoreApp#optional_field1}
    */
    readonly optionalField1?: string;
    /**
    * Name of optional value in login form
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#optional_field1_value SecurePasswordStoreApp#optional_field1_value}
    */
    readonly optionalField1Value?: string;
    /**
    * Name of optional param in the login form
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#optional_field2 SecurePasswordStoreApp#optional_field2}
    */
    readonly optionalField2?: string;
    /**
    * Name of optional value in login form
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#optional_field2_value SecurePasswordStoreApp#optional_field2_value}
    */
    readonly optionalField2Value?: string;
    /**
    * Name of optional param in the login form
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#optional_field3 SecurePasswordStoreApp#optional_field3}
    */
    readonly optionalField3?: string;
    /**
    * Name of optional value in login form
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#optional_field3_value SecurePasswordStoreApp#optional_field3_value}
    */
    readonly optionalField3Value?: string;
    /**
    * Login password field
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#password_field SecurePasswordStoreApp#password_field}
    */
    readonly passwordField: string;
    /**
    * Allow user to reveal password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#reveal_password SecurePasswordStoreApp#reveal_password}
    */
    readonly revealPassword?: boolean | cdktf.IResolvable;
    /**
    * Shared password, required for certain schemes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#shared_password SecurePasswordStoreApp#shared_password}
    */
    readonly sharedPassword?: string;
    /**
    * Shared username, required for certain schemes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#shared_username SecurePasswordStoreApp#shared_username}
    */
    readonly sharedUsername?: string;
    /**
    * Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#skip_groups SecurePasswordStoreApp#skip_groups}
    */
    readonly skipGroups?: boolean | cdktf.IResolvable;
    /**
    * Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#skip_users SecurePasswordStoreApp#skip_users}
    */
    readonly skipUsers?: boolean | cdktf.IResolvable;
    /**
    * Status of application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#status SecurePasswordStoreApp#status}
    */
    readonly status?: string;
    /**
    * Login URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#url SecurePasswordStoreApp#url}
    */
    readonly url: string;
    /**
    * Username template
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#user_name_template SecurePasswordStoreApp#user_name_template}
    */
    readonly userNameTemplate?: string;
    /**
    * Push username on update
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#user_name_template_push_status SecurePasswordStoreApp#user_name_template_push_status}
    */
    readonly userNameTemplatePushStatus?: string;
    /**
    * Username template suffix
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#user_name_template_suffix SecurePasswordStoreApp#user_name_template_suffix}
    */
    readonly userNameTemplateSuffix?: string;
    /**
    * Username template type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#user_name_template_type SecurePasswordStoreApp#user_name_template_type}
    */
    readonly userNameTemplateType?: string;
    /**
    * Login username field
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#username_field SecurePasswordStoreApp#username_field}
    */
    readonly usernameField: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#timeouts SecurePasswordStoreApp#timeouts}
    */
    readonly timeouts?: SecurePasswordStoreAppTimeouts;
    /**
    * users block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#users SecurePasswordStoreApp#users}
    */
    readonly users?: SecurePasswordStoreAppUsers[] | cdktf.IResolvable;
}
export interface SecurePasswordStoreAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#create SecurePasswordStoreApp#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#read SecurePasswordStoreApp#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#update SecurePasswordStoreApp#update}
    */
    readonly update?: string;
}
export declare function securePasswordStoreAppTimeoutsToTerraform(struct?: SecurePasswordStoreAppTimeoutsOutputReference | SecurePasswordStoreAppTimeouts | cdktf.IResolvable): any;
export declare class SecurePasswordStoreAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurePasswordStoreAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SecurePasswordStoreAppTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface SecurePasswordStoreAppUsers {
    /**
    * User ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#id SecurePasswordStoreApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Password for user application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#password SecurePasswordStoreApp#password}
    */
    readonly password?: string;
    /**
    * Username for user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app#username SecurePasswordStoreApp#username}
    */
    readonly username?: string;
}
export declare function securePasswordStoreAppUsersToTerraform(struct?: SecurePasswordStoreAppUsers | cdktf.IResolvable): any;
export declare class SecurePasswordStoreAppUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecurePasswordStoreAppUsers | cdktf.IResolvable | undefined;
    set internalValue(value: SecurePasswordStoreAppUsers | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    get scope(): string;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export declare class SecurePasswordStoreAppUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SecurePasswordStoreAppUsers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecurePasswordStoreAppUsersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app okta_secure_password_store_app}
*/
export declare class SecurePasswordStoreApp extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_secure_password_store_app";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app okta_secure_password_store_app} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecurePasswordStoreAppConfig
    */
    constructor(scope: Construct, id: string, config: SecurePasswordStoreAppConfig);
    private _accessibilityErrorRedirectUrl?;
    get accessibilityErrorRedirectUrl(): string;
    set accessibilityErrorRedirectUrl(value: string);
    resetAccessibilityErrorRedirectUrl(): void;
    get accessibilityErrorRedirectUrlInput(): string | undefined;
    private _accessibilityLoginRedirectUrl?;
    get accessibilityLoginRedirectUrl(): string;
    set accessibilityLoginRedirectUrl(value: string);
    resetAccessibilityLoginRedirectUrl(): void;
    get accessibilityLoginRedirectUrlInput(): string | undefined;
    private _accessibilitySelfService?;
    get accessibilitySelfService(): boolean | cdktf.IResolvable;
    set accessibilitySelfService(value: boolean | cdktf.IResolvable);
    resetAccessibilitySelfService(): void;
    get accessibilitySelfServiceInput(): boolean | cdktf.IResolvable | undefined;
    private _adminNote?;
    get adminNote(): string;
    set adminNote(value: string);
    resetAdminNote(): void;
    get adminNoteInput(): string | undefined;
    private _appLinksJson?;
    get appLinksJson(): string;
    set appLinksJson(value: string);
    resetAppLinksJson(): void;
    get appLinksJsonInput(): string | undefined;
    private _autoSubmitToolbar?;
    get autoSubmitToolbar(): boolean | cdktf.IResolvable;
    set autoSubmitToolbar(value: boolean | cdktf.IResolvable);
    resetAutoSubmitToolbar(): void;
    get autoSubmitToolbarInput(): boolean | cdktf.IResolvable | undefined;
    private _credentialsScheme?;
    get credentialsScheme(): string;
    set credentialsScheme(value: string);
    resetCredentialsScheme(): void;
    get credentialsSchemeInput(): string | undefined;
    private _enduserNote?;
    get enduserNote(): string;
    set enduserNote(value: string);
    resetEnduserNote(): void;
    get enduserNoteInput(): string | undefined;
    private _groups?;
    get groups(): string[];
    set groups(value: string[]);
    resetGroups(): void;
    get groupsInput(): string[] | undefined;
    private _hideIos?;
    get hideIos(): boolean | cdktf.IResolvable;
    set hideIos(value: boolean | cdktf.IResolvable);
    resetHideIos(): void;
    get hideIosInput(): boolean | cdktf.IResolvable | undefined;
    private _hideWeb?;
    get hideWeb(): boolean | cdktf.IResolvable;
    set hideWeb(value: boolean | cdktf.IResolvable);
    resetHideWeb(): void;
    get hideWebInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    get labelInput(): string | undefined;
    private _logo?;
    get logo(): string;
    set logo(value: string);
    resetLogo(): void;
    get logoInput(): string | undefined;
    get logoUrl(): string;
    get name(): string;
    private _optionalField1?;
    get optionalField1(): string;
    set optionalField1(value: string);
    resetOptionalField1(): void;
    get optionalField1Input(): string | undefined;
    private _optionalField1Value?;
    get optionalField1Value(): string;
    set optionalField1Value(value: string);
    resetOptionalField1Value(): void;
    get optionalField1ValueInput(): string | undefined;
    private _optionalField2?;
    get optionalField2(): string;
    set optionalField2(value: string);
    resetOptionalField2(): void;
    get optionalField2Input(): string | undefined;
    private _optionalField2Value?;
    get optionalField2Value(): string;
    set optionalField2Value(value: string);
    resetOptionalField2Value(): void;
    get optionalField2ValueInput(): string | undefined;
    private _optionalField3?;
    get optionalField3(): string;
    set optionalField3(value: string);
    resetOptionalField3(): void;
    get optionalField3Input(): string | undefined;
    private _optionalField3Value?;
    get optionalField3Value(): string;
    set optionalField3Value(value: string);
    resetOptionalField3Value(): void;
    get optionalField3ValueInput(): string | undefined;
    private _passwordField?;
    get passwordField(): string;
    set passwordField(value: string);
    get passwordFieldInput(): string | undefined;
    private _revealPassword?;
    get revealPassword(): boolean | cdktf.IResolvable;
    set revealPassword(value: boolean | cdktf.IResolvable);
    resetRevealPassword(): void;
    get revealPasswordInput(): boolean | cdktf.IResolvable | undefined;
    private _sharedPassword?;
    get sharedPassword(): string;
    set sharedPassword(value: string);
    resetSharedPassword(): void;
    get sharedPasswordInput(): string | undefined;
    private _sharedUsername?;
    get sharedUsername(): string;
    set sharedUsername(value: string);
    resetSharedUsername(): void;
    get sharedUsernameInput(): string | undefined;
    get signOnMode(): string;
    private _skipGroups?;
    get skipGroups(): boolean | cdktf.IResolvable;
    set skipGroups(value: boolean | cdktf.IResolvable);
    resetSkipGroups(): void;
    get skipGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _skipUsers?;
    get skipUsers(): boolean | cdktf.IResolvable;
    set skipUsers(value: boolean | cdktf.IResolvable);
    resetSkipUsers(): void;
    get skipUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _userNameTemplate?;
    get userNameTemplate(): string;
    set userNameTemplate(value: string);
    resetUserNameTemplate(): void;
    get userNameTemplateInput(): string | undefined;
    private _userNameTemplatePushStatus?;
    get userNameTemplatePushStatus(): string;
    set userNameTemplatePushStatus(value: string);
    resetUserNameTemplatePushStatus(): void;
    get userNameTemplatePushStatusInput(): string | undefined;
    private _userNameTemplateSuffix?;
    get userNameTemplateSuffix(): string;
    set userNameTemplateSuffix(value: string);
    resetUserNameTemplateSuffix(): void;
    get userNameTemplateSuffixInput(): string | undefined;
    private _userNameTemplateType?;
    get userNameTemplateType(): string;
    set userNameTemplateType(value: string);
    resetUserNameTemplateType(): void;
    get userNameTemplateTypeInput(): string | undefined;
    private _usernameField?;
    get usernameField(): string;
    set usernameField(value: string);
    get usernameFieldInput(): string | undefined;
    private _timeouts;
    get timeouts(): SecurePasswordStoreAppTimeoutsOutputReference;
    putTimeouts(value: SecurePasswordStoreAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SecurePasswordStoreAppTimeouts | undefined;
    private _users;
    get users(): SecurePasswordStoreAppUsersList;
    putUsers(value: SecurePasswordStoreAppUsers[] | cdktf.IResolvable): void;
    resetUsers(): void;
    get usersInput(): cdktf.IResolvable | SecurePasswordStoreAppUsers[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
