import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecurityNotificationEmailsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/security_notification_emails#id SecurityNotificationEmails#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Notifies end users about suspicious or unrecognized activity from their account
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/security_notification_emails#report_suspicious_activity_enabled SecurityNotificationEmails#report_suspicious_activity_enabled}
    */
    readonly reportSuspiciousActivityEnabled?: boolean | cdktf.IResolvable;
    /**
    * Notifies end users of any activity on their account related to MFA factor enrollment
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/security_notification_emails#send_email_for_factor_enrollment_enabled SecurityNotificationEmails#send_email_for_factor_enrollment_enabled}
    */
    readonly sendEmailForFactorEnrollmentEnabled?: boolean | cdktf.IResolvable;
    /**
    * Notifies end users that one or more factors have been reset for their account
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/security_notification_emails#send_email_for_factor_reset_enabled SecurityNotificationEmails#send_email_for_factor_reset_enabled}
    */
    readonly sendEmailForFactorResetEnabled?: boolean | cdktf.IResolvable;
    /**
    * Notifies end users about new sign-on activity
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/security_notification_emails#send_email_for_new_device_enabled SecurityNotificationEmails#send_email_for_new_device_enabled}
    */
    readonly sendEmailForNewDeviceEnabled?: boolean | cdktf.IResolvable;
    /**
    * Notifies end users that the password for their account has changed
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/security_notification_emails#send_email_for_password_changed_enabled SecurityNotificationEmails#send_email_for_password_changed_enabled}
    */
    readonly sendEmailForPasswordChangedEnabled?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/security_notification_emails okta_security_notification_emails}
*/
export declare class SecurityNotificationEmails extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_security_notification_emails";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/security_notification_emails okta_security_notification_emails} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecurityNotificationEmailsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: SecurityNotificationEmailsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _reportSuspiciousActivityEnabled?;
    get reportSuspiciousActivityEnabled(): boolean | cdktf.IResolvable;
    set reportSuspiciousActivityEnabled(value: boolean | cdktf.IResolvable);
    resetReportSuspiciousActivityEnabled(): void;
    get reportSuspiciousActivityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sendEmailForFactorEnrollmentEnabled?;
    get sendEmailForFactorEnrollmentEnabled(): boolean | cdktf.IResolvable;
    set sendEmailForFactorEnrollmentEnabled(value: boolean | cdktf.IResolvable);
    resetSendEmailForFactorEnrollmentEnabled(): void;
    get sendEmailForFactorEnrollmentEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sendEmailForFactorResetEnabled?;
    get sendEmailForFactorResetEnabled(): boolean | cdktf.IResolvable;
    set sendEmailForFactorResetEnabled(value: boolean | cdktf.IResolvable);
    resetSendEmailForFactorResetEnabled(): void;
    get sendEmailForFactorResetEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sendEmailForNewDeviceEnabled?;
    get sendEmailForNewDeviceEnabled(): boolean | cdktf.IResolvable;
    set sendEmailForNewDeviceEnabled(value: boolean | cdktf.IResolvable);
    resetSendEmailForNewDeviceEnabled(): void;
    get sendEmailForNewDeviceEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sendEmailForPasswordChangedEnabled?;
    get sendEmailForPasswordChangedEnabled(): boolean | cdktf.IResolvable;
    set sendEmailForPasswordChangedEnabled(value: boolean | cdktf.IResolvable);
    resetSendEmailForPasswordChangedEnabled(): void;
    get sendEmailForPasswordChangedEnabledInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
